/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.messages;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;

public final class NetconfMessageHeader {
    private long length;
    private static final byte[] headerBegin = new byte[]{10, 35};
    private static final byte headerEnd = 10;
    private boolean parsed = false;

    public NetconfMessageHeader fromBytes(byte[] bytes) {
        this.length = Long.parseLong(Charsets.US_ASCII.decode(ByteBuffer.wrap(bytes, headerBegin.length, bytes.length - headerBegin.length - 1)).toString());
        Preconditions.checkState((this.length < Integer.MAX_VALUE && this.length > 0L ? 1 : 0) != 0);
        this.parsed = true;
        return this;
    }

    public byte[] toBytes() {
        byte[] l = String.valueOf(this.length).getBytes(Charsets.US_ASCII);
        byte[] h = new byte[headerBegin.length + l.length + 1];
        System.arraycopy(headerBegin, 0, h, 0, headerBegin.length);
        System.arraycopy(l, 0, h, headerBegin.length, l.length);
        System.arraycopy(new byte[]{10}, 0, h, headerBegin.length + l.length, 1);
        return h;
    }

    public int getLength() {
        return (int)this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    public void setParsed() {
        this.parsed = false;
    }
}

