/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.messages;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.opendaylight.controller.netconf.api.NetconfDeserializerException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.protocol.framework.DeserializerException;
import org.opendaylight.protocol.framework.DocumentedException;
import org.opendaylight.protocol.framework.ProtocolMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class NetconfMessageFactory
implements ProtocolMessageFactory<NetconfMessage> {
    private static final Logger logger = LoggerFactory.getLogger(NetconfMessageFactory.class);
    private static final List<byte[]> POSSIBLE_STARTS = ImmutableList.of((Object)"[".getBytes(Charsets.UTF_8), (Object)"\r\n[".getBytes(Charsets.UTF_8), (Object)"\n[".getBytes(Charsets.UTF_8));
    private static final List<byte[]> POSSIBLE_ENDS = ImmutableList.of((Object)"]\n".getBytes(Charsets.UTF_8), (Object)"]\r\n".getBytes(Charsets.UTF_8));
    private final Optional<String> clientId;

    public NetconfMessageFactory() {
        this.clientId = Optional.absent();
    }

    public NetconfMessageFactory(Optional<String> clientId) {
        this.clientId = clientId;
    }

    public NetconfMessage parse(byte[] bytes) throws DeserializerException, DocumentedException {
        NetconfMessage message;
        int endOfAuthHeader;
        this.logMessage(bytes);
        String additionalHeader = null;
        if (this.startsWithAdditionalHeader(bytes) && (endOfAuthHeader = this.getAdditionalHeaderEndIndex(bytes)) > -1) {
            byte[] additionalHeaderBytes = Arrays.copyOfRange(bytes, 0, endOfAuthHeader + 2);
            additionalHeader = this.additionalHeaderToString(additionalHeaderBytes);
            bytes = Arrays.copyOfRange(bytes, endOfAuthHeader + 2, bytes.length);
        }
        try {
            Document doc = XmlUtil.readXmlToDocument(new ByteArrayInputStream(bytes));
            message = new NetconfMessage(doc, additionalHeader);
        }
        catch (IOException | IllegalStateException | SAXException e) {
            throw new NetconfDeserializerException("Could not parse message from " + new String(bytes), e);
        }
        return message;
    }

    private static int findByteSequence(byte[] bytes, byte[] sequence) {
        if (bytes.length < sequence.length) {
            throw new IllegalArgumentException("Sequence to be found is longer than the given byte array.");
        }
        if (bytes.length == sequence.length) {
            if (Arrays.equals(bytes, sequence)) {
                return 0;
            }
            return -1;
        }
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == sequence[j]) {
                if (++j != sequence.length) continue;
                return i - j + 1;
            }
            j = 0;
        }
        return -1;
    }

    private int getAdditionalHeaderEndIndex(byte[] bytes) {
        for (byte[] possibleEnd : POSSIBLE_ENDS) {
            int idx = NetconfMessageFactory.findByteSequence(bytes, possibleEnd);
            if (idx == -1) continue;
            return idx;
        }
        return -1;
    }

    private boolean startsWithAdditionalHeader(byte[] bytes) {
        for (byte[] possibleStart : POSSIBLE_STARTS) {
            byte b;
            int i = 0;
            int i$ = 0;
            byte[] arr$ = possibleStart;
            int len$ = arr$.length;
            if (i$ >= len$ || bytes[i] != (b = arr$[i$])) continue;
            return true;
        }
        return false;
    }

    private void logMessage(byte[] bytes) {
        String s = Charsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
        logger.debug("Parsing message \n{}", (Object)s);
    }

    private String additionalHeaderToString(byte[] bytes) {
        return Charsets.UTF_8.decode(ByteBuffer.wrap(bytes)).toString();
    }

    public byte[] put(NetconfMessage netconfMessage) {
        ByteBuffer msgBytes;
        if (this.clientId.isPresent()) {
            Comment comment = netconfMessage.getDocument().createComment("clientId:" + (String)this.clientId.get());
            netconfMessage.getDocument().appendChild(comment);
        }
        if (netconfMessage.getAdditionalHeader().isPresent()) {
            String header = (String)netconfMessage.getAdditionalHeader().get();
            logger.trace("Header of netconf message parsed \n{}", (Object)header);
            msgBytes = Charsets.UTF_8.encode(header + this.xmlToString(netconfMessage.getDocument()));
        } else {
            msgBytes = Charsets.UTF_8.encode(this.xmlToString(netconfMessage.getDocument()));
        }
        String content = this.xmlToString(netconfMessage.getDocument());
        logger.trace("Putting message \n{}", (Object)content);
        byte[] b = new byte[msgBytes.limit()];
        msgBytes.get(b);
        return b;
    }

    private String xmlToString(Document doc) {
        return XmlUtil.toString(doc, false);
    }
}

