/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.mapping;

import java.util.Map;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfOperationRouter;
import org.opendaylight.controller.netconf.mapping.api.HandlingPriority;
import org.opendaylight.controller.netconf.mapping.api.NetconfOperation;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractNetconfOperation
implements NetconfOperation {
    private final String netconfSessionIdForReporting;

    protected AbstractNetconfOperation(String netconfSessionIdForReporting) {
        this.netconfSessionIdForReporting = netconfSessionIdForReporting;
    }

    public String getNetconfSessionIdForReporting() {
        return this.netconfSessionIdForReporting;
    }

    public HandlingPriority canHandle(Document message) {
        OperationNameAndNamespace operationNameAndNamespace = new OperationNameAndNamespace(message);
        return this.canHandle(operationNameAndNamespace.getOperationName(), operationNameAndNamespace.getNamespace());
    }

    protected static XmlElement getRequestElementWithCheck(Document message) {
        return XmlElement.fromDomElementWithExpected(message.getDocumentElement(), "rpc", "urn:ietf:params:xml:ns:netconf:base:1.0");
    }

    protected abstract HandlingPriority canHandle(String var1, String var2);

    public Document handle(Document message, NetconfOperationRouter opRouter) throws NetconfDocumentedException {
        XmlElement requestElement = AbstractNetconfOperation.getRequestElementWithCheck(message);
        Document document = XmlUtil.newDocument();
        XmlElement operationElement = requestElement.getOnlyChildElement();
        Map<String, Attr> attributes = requestElement.getAttributes();
        Element response = this.handle(document, operationElement, opRouter);
        Element rpcReply = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "rpc-reply");
        if (XmlElement.fromDomElement(response).hasNamespace()) {
            rpcReply.appendChild(response);
        } else {
            Element responseNS = document.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", response.getNodeName());
            NodeList list = response.getChildNodes();
            while (list.getLength() != 0) {
                responseNS.appendChild(list.item(0));
            }
            rpcReply.appendChild(responseNS);
        }
        for (String attrName : attributes.keySet()) {
            rpcReply.setAttributeNode((Attr)document.importNode(attributes.get(attrName), true));
        }
        document.appendChild(rpcReply);
        return document;
    }

    protected abstract Element handle(Document var1, XmlElement var2, NetconfOperationRouter var3) throws NetconfDocumentedException;

    public String toString() {
        return this.getClass() + "{" + this.netconfSessionIdForReporting + '}';
    }

    public static class OperationNameAndNamespace {
        private final String operationName;
        private final String namespace;

        public OperationNameAndNamespace(Document message) {
            XmlElement requestElement = AbstractNetconfOperation.getRequestElementWithCheck(message);
            XmlElement operationElement = requestElement.getOnlyChildElement();
            this.operationName = operationElement.getName();
            this.namespace = operationElement.getNamespace();
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getNamespace() {
            return this.namespace;
        }
    }
}

