/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler.ssh.client;

import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SshSession {
    final Session session;

    public SshSession(Session session) {
        this.session = session;
    }

    public void execCommand(String cmd) throws IOException {
        this.session.execCommand(cmd);
    }

    public void execCommand(String cmd, String charsetName) throws IOException {
        this.session.execCommand(cmd, charsetName);
    }

    public void startShell() throws IOException {
        this.session.startShell();
    }

    public void startSubSystem(String name) throws IOException {
        this.session.startSubSystem(name);
    }

    public int getState() {
        return this.session.getState();
    }

    public InputStream getStdout() {
        return new StreamGobbler(this.session.getStdout());
    }

    public InputStream getStderr() {
        return this.session.getStderr();
    }

    public OutputStream getStdin() {
        return this.session.getStdin();
    }

    public int waitUntilDataAvailable(long timeout) throws IOException {
        return this.session.waitUntilDataAvailable(timeout);
    }

    public int waitForCondition(int condition_set, long timeout) {
        return this.session.waitForCondition(condition_set, timeout);
    }

    public Integer getExitStatus() {
        return this.session.getExitStatus();
    }

    public String getExitSignal() {
        return this.session.getExitSignal();
    }
}

