/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler.ssh.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opendaylight.controller.netconf.util.handler.ssh.client.Invoker;
import org.opendaylight.controller.netconf.util.handler.ssh.client.SshClient;
import org.opendaylight.controller.netconf.util.handler.ssh.client.SshSession;
import org.opendaylight.controller.netconf.util.handler.ssh.virtualsocket.VirtualSocketException;

public class SshClientAdapter
implements Runnable {
    private final SshClient sshClient;
    private final Invoker invoker;
    private SshSession session;
    private InputStream stdOut;
    private InputStream stdErr;
    private OutputStream stdIn;
    private Queue<ByteBuf> postponned = new LinkedList<ByteBuf>();
    private ChannelHandlerContext ctx;
    private ChannelPromise disconnectPromise;
    private final AtomicBoolean stopRequested = new AtomicBoolean(false);
    private final Object lock = new Object();

    public SshClientAdapter(SshClient sshClient, Invoker invoker) {
        this.sshClient = sshClient;
        this.invoker = invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        Object readBuff;
        try {
            this.session = this.sshClient.openSession();
            this.invoker.invoke(this.session);
            this.stdOut = this.session.getStdout();
            this.stdErr = this.session.getStderr();
            Object object = this.lock;
            synchronized (object) {
                this.stdIn = this.session.getStdin();
                ByteBuf message = null;
                while ((message = this.postponned.poll()) != null) {
                    this.writeImpl(message);
                }
            }
            while (!this.stopRequested.get()) {
                readBuff = new byte[1024];
                int c = this.stdOut.read((byte[])readBuff);
                if (c == -1) continue;
                byte[] tranBuff = new byte[c];
                System.arraycopy(readBuff, 0, tranBuff, 0, c);
                ByteBuf byteBuf = Unpooled.buffer((int)c);
                byteBuf.writeBytes(tranBuff);
                this.ctx.fireChannelRead((Object)byteBuf);
            }
        }
        catch (VirtualSocketException e22222222222) {
            this.sshClient.close();
            Object e22222222222 = this.lock;
            synchronized (e22222222222) {
                if (this.disconnectPromise != null) {
                    this.ctx.disconnect(this.disconnectPromise);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
            {
                catch (Throwable throwable) {
                    this.sshClient.close();
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.disconnectPromise != null) {
                            this.ctx.disconnect(this.disconnectPromise);
                        }
                    }
                    throw throwable;
                }
            }
        }
        this.sshClient.close();
        Object object = this.lock;
        readBuff = object;
        synchronized (object) {
            if (this.disconnectPromise != null) {
                this.ctx.disconnect(this.disconnectPromise);
            }
            // ** MonitorExit[readBuff /* !! */ ] (shouldn't be in output)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuf message) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.stdIn == null) {
                this.postponned.add(message);
                return;
            }
            this.writeImpl(message);
        }
    }

    private void writeImpl(ByteBuf message) throws IOException {
        message.getBytes(0, this.stdIn, message.readableBytes());
        this.stdIn.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ChannelPromise promise) {
        Object object = this.lock;
        synchronized (object) {
            this.stopRequested.set(true);
            this.disconnectPromise = promise;
        }
    }

    public void start(ChannelHandlerContext ctx) {
        if (this.ctx != null) {
            return;
        }
        this.ctx = ctx;
        new Thread(this).start();
    }
}

