/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler.ssh.client;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.controller.netconf.util.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.controller.netconf.util.handler.ssh.client.SshSession;
import org.opendaylight.controller.netconf.util.handler.ssh.virtualsocket.VirtualSocket;

public class SshClient {
    private final VirtualSocket socket;
    private final Map<Integer, SshSession> openSessions = new HashMap<Integer, SshSession>();
    private final AuthenticationHandler authenticationHandler;
    private Connection connection;

    public SshClient(VirtualSocket socket, AuthenticationHandler authenticationHandler) throws IOException {
        this.socket = socket;
        this.authenticationHandler = authenticationHandler;
    }

    public SshSession openSession() throws IOException {
        if (this.connection == null) {
            this.connect();
        }
        Session session = this.connection.openSession();
        SshSession sshSession = new SshSession(session);
        this.openSessions.put(this.openSessions.size(), sshSession);
        return sshSession;
    }

    private void connect() throws IOException {
        this.connection = new Connection((Socket)this.socket);
        this.connection.connect();
        this.authenticationHandler.authenticate(this.connection);
    }

    public void closeSession(SshSession session) {
        if (session.getState() == 2 || session.getState() == 1) {
            session.session.close();
        }
    }

    public void close() {
        for (SshSession session : this.openSessions.values()) {
            this.closeSession(session);
        }
        this.openSessions.clear();
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

