/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler.ssh;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import org.opendaylight.controller.netconf.util.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.controller.netconf.util.handler.ssh.client.Invoker;
import org.opendaylight.controller.netconf.util.handler.ssh.client.SshClient;
import org.opendaylight.controller.netconf.util.handler.ssh.client.SshClientAdapter;
import org.opendaylight.controller.netconf.util.handler.ssh.virtualsocket.VirtualSocket;

public class SshHandler
extends ChannelOutboundHandlerAdapter {
    private final VirtualSocket virtualSocket = new VirtualSocket();
    private final SshClientAdapter sshClientAdapter;

    public SshHandler(AuthenticationHandler authenticationHandler, Invoker invoker) throws IOException {
        SshClient sshClient = new SshClient(this.virtualSocket, authenticationHandler);
        this.sshClientAdapter = new SshClientAdapter(sshClient, invoker);
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (ctx.channel().pipeline().get("socket") == null) {
            ctx.channel().pipeline().addFirst("socket", (ChannelHandler)this.virtualSocket);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().pipeline().get("socket") != null) {
            ctx.channel().pipeline().remove("socket");
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.sshClientAdapter.write((ByteBuf)msg);
    }

    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                SshHandler.this.sshClientAdapter.start(ctx);
            }
        });
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.sshClientAdapter.stop(promise);
    }
}

