/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.Charset;
import java.util.List;
import org.opendaylight.protocol.framework.DeserializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfMessageChunkDecoder
extends ByteToMessageDecoder {
    private static final Logger logger = LoggerFactory.getLogger(NetconfMessageChunkDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        ByteBuf byteBufMsg = Unpooled.buffer((int)in.readableBytes());
        int chunkSize = -1;
        boolean isParsed = false;
        while (in.isReadable()) {
            try {
                if (!isParsed) {
                    chunkSize = this.readHeader(in);
                    isParsed = true;
                }
                if (chunkSize != -1 && isParsed) {
                    in.readBytes(byteBufMsg, chunkSize);
                    isParsed = false;
                    continue;
                }
                throw new DeserializerException("Unable to parse chunked data or header.");
            }
            catch (Exception e) {
                logger.error("Failed to decode chunked message.", (Throwable)e);
                this.exceptionCaught(ctx, e);
            }
        }
        out.add(byteBufMsg);
        isParsed = false;
    }

    private int readHeader(ByteBuf in) {
        ByteBuf chunkSize = Unpooled.buffer((int)4, (int)13);
        byte b = in.readByte();
        if (b != 10) {
            return -1;
        }
        b = in.readByte();
        if (b != 35) {
            return -1;
        }
        while ((b = in.readByte()) != 10) {
            chunkSize.writeByte((int)b);
        }
        return Integer.parseInt(chunkSize.toString(Charset.forName("UTF-8")));
    }
}

