/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.MessageToByteEncoder;
import org.opendaylight.controller.netconf.util.handler.ChunkedFramingMechanismEncoder;
import org.opendaylight.controller.netconf.util.handler.EOMFramingMechanismEncoder;
import org.opendaylight.controller.netconf.util.messages.FramingMechanism;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FramingMechanismHandlerFactory {
    private static final Logger logger = LoggerFactory.getLogger(FramingMechanismHandlerFactory.class);

    public static MessageToByteEncoder<ByteBuf> createHandler(FramingMechanism framingMechanism) {
        logger.debug("{} framing mechanism was selected.", (Object)framingMechanism);
        if (framingMechanism == FramingMechanism.EOM) {
            return new EOMFramingMechanismEncoder();
        }
        return new ChunkedFramingMechanismEncoder();
    }
}

