/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.opendaylight.controller.netconf.util.messages.NetconfMessageConstants;
import org.opendaylight.controller.netconf.util.messages.NetconfMessageHeader;

public class ChunkedFramingMechanismEncoder
extends MessageToByteEncoder<ByteBuf> {
    private NetconfMessageHeader messageHeader = new NetconfMessageHeader();
    private static final int MAX_CHUNK_SIZE = 1024;

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        while (msg.readableBytes() > 1024) {
            ByteBuf chunk = Unpooled.buffer((int)1024);
            chunk.writeBytes(this.createChunkHeader(1024));
            chunk.writeBytes(msg.readBytes(1024));
            ctx.write((Object)chunk);
        }
        out.writeBytes(this.createChunkHeader(msg.readableBytes()));
        out.writeBytes(msg.readBytes(msg.readableBytes()));
        out.writeBytes(NetconfMessageConstants.endOfChunk);
    }

    private ByteBuf createChunkHeader(int chunkSize) {
        this.messageHeader.setLength(chunkSize);
        return Unpooled.wrappedBuffer((byte[])this.messageHeader.toBytes());
    }
}

