/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.opendaylight.controller.config.api.ConflictingVersionException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.util.xml.XMLNetconfUtil;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NetconfUtil {
    private static final Logger logger = LoggerFactory.getLogger(NetconfUtil.class);

    public static NetconfMessage createMessage(File f) {
        Preconditions.checkNotNull((Object)f, (Object)"File parameter was null");
        try {
            return NetconfUtil.createMessage(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            logger.warn("File {} not found.", (Object)f, (Object)e);
            return null;
        }
    }

    public static NetconfMessage createMessage(InputStream is) {
        Preconditions.checkNotNull((Object)is, (Object)"InputStream parameter was null");
        Document doc = null;
        try {
            doc = XmlUtil.readXmlToDocument(is);
        }
        catch (IOException e) {
            logger.warn("Error ocurred while parsing stream.", (Throwable)e);
        }
        catch (SAXException e) {
            logger.warn("Error ocurred while final parsing stream.", (Throwable)e);
        }
        return doc == null ? null : new NetconfMessage(doc);
    }

    public static void checkIsMessageOk(NetconfMessage responseMessage) throws ConflictingVersionException {
        XmlElement element = XmlElement.fromDomDocument(responseMessage.getDocument());
        Preconditions.checkState((boolean)element.getName().equals("rpc-reply"));
        element = element.getOnlyChildElement();
        if (element.getName().equals("ok")) {
            return;
        }
        if (element.getName().equals("rpc-error")) {
            logger.warn("Can not load last configuration, operation failed");
            XPathExpression xPathExpression = XMLNetconfUtil.compileXPath("/netconf:rpc-reply/netconf:rpc-error/netconf:error-info/netconf:error");
            String error = (String)XmlUtil.evaluateXPath(xPathExpression, element.getDomElement(), XPathConstants.STRING);
            if (error != null && error.contains(ConflictingVersionException.class.getCanonicalName())) {
                throw new ConflictingVersionException(error);
            }
            throw new IllegalStateException("Can not load last configuration, operation failed: " + XmlUtil.toString(responseMessage.getDocument()));
        }
        logger.warn("Can not load last configuration. Operation failed.");
        throw new IllegalStateException("Can not load last configuration. Operation failed: " + XmlUtil.toString(responseMessage.getDocument()));
    }
}

