/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.api.NetconfSessionPreferences;
import org.opendaylight.controller.netconf.util.handler.FramingMechanismHandlerFactory;
import org.opendaylight.controller.netconf.util.handler.NetconfMessageAggregator;
import org.opendaylight.controller.netconf.util.handler.NetconfMessageChunkDecoder;
import org.opendaylight.controller.netconf.util.messages.FramingMechanism;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.protocol.framework.AbstractProtocolSession;
import org.opendaylight.protocol.framework.AbstractSessionNegotiator;
import org.opendaylight.protocol.framework.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public abstract class AbstractNetconfSessionNegotiator<P extends NetconfSessionPreferences, S extends NetconfSession>
extends AbstractSessionNegotiator<NetconfMessage, S> {
    private static final long INITIAL_HOLDTIMER = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractNetconfSessionNegotiator.class);
    public static final String NAME_OF_EXCEPTION_HANDLER = "lastExceptionHandler";
    protected final P sessionPreferences;
    private final SessionListener sessionListener;
    private Timeout timeout;
    private State state = State.IDLE;
    private final Timer timer;

    protected AbstractNetconfSessionNegotiator(P sessionPreferences, Promise<S> promise, Channel channel, Timer timer, SessionListener sessionListener) {
        super(promise, channel);
        this.sessionPreferences = sessionPreferences;
        this.timer = timer;
        this.sessionListener = sessionListener;
    }

    protected void startNegotiation() {
        Optional<SslHandler> sslHandler = AbstractNetconfSessionNegotiator.getSslHandler(this.channel);
        if (sslHandler.isPresent()) {
            Future future = ((SslHandler)sslHandler.get()).handshakeFuture();
            future.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                public void operationComplete(Future<? super Channel> future) throws Exception {
                    Preconditions.checkState((boolean)future.isSuccess(), (Object)"Ssl handshake was not successful");
                    logger.debug("Ssl handshake complete");
                    AbstractNetconfSessionNegotiator.this.start();
                }
            });
        } else {
            this.start();
        }
    }

    private static Optional<SslHandler> getSslHandler(Channel channel) {
        SslHandler sslHandler = (SslHandler)channel.pipeline().get(SslHandler.class);
        return sslHandler == null ? Optional.absent() : Optional.of((Object)sslHandler);
    }

    private void start() {
        NetconfMessage helloMessage = this.sessionPreferences.getHelloMessage();
        logger.debug("Session negotiation started with hello message {}", (Object)XmlUtil.toString(helloMessage.getDocument()));
        this.channel.pipeline().addLast(NAME_OF_EXCEPTION_HANDLER, new ChannelHandler(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            }

            public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                logger.warn("An exception occurred during negotiation on channel {}", (Object)AbstractNetconfSessionNegotiator.this.channel.localAddress(), (Object)cause);
                AbstractNetconfSessionNegotiator.this.cancelTimeout();
                AbstractNetconfSessionNegotiator.this.negotiationFailed(cause);
                AbstractNetconfSessionNegotiator.this.changeState(State.FAILED);
            }
        });
        this.timeout = this.timer.newTimeout(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(Timeout timeout) throws Exception {
                3 var2_2 = this;
                synchronized (var2_2) {
                    if (AbstractNetconfSessionNegotiator.this.state != State.ESTABLISHED) {
                        IllegalStateException cause = new IllegalStateException("Session was not established after " + timeout);
                        AbstractNetconfSessionNegotiator.this.negotiationFailed(cause);
                        AbstractNetconfSessionNegotiator.this.changeState(State.FAILED);
                    } else if (AbstractNetconfSessionNegotiator.this.channel.isOpen()) {
                        AbstractNetconfSessionNegotiator.this.channel.pipeline().remove(AbstractNetconfSessionNegotiator.NAME_OF_EXCEPTION_HANDLER);
                    }
                }
            }
        }, 1L, TimeUnit.MINUTES);
        this.sendMessage(helloMessage);
        this.changeState(State.OPEN_WAIT);
    }

    private void cancelTimeout() {
        if (this.timeout != null) {
            this.timeout.cancel();
        }
    }

    private void sendMessage(NetconfMessage message) {
        this.channel.writeAndFlush((Object)message);
    }

    protected void handleMessage(NetconfMessage netconfMessage) {
        Document doc = netconfMessage.getDocument();
        if (this.isHelloMessage(doc)) {
            if (this.containsBase11Capability(doc) && this.containsBase11Capability(this.sessionPreferences.getHelloMessage().getDocument())) {
                this.channel.pipeline().replace("frameEncoder", "frameEncoder", FramingMechanismHandlerFactory.createHandler(FramingMechanism.CHUNK));
                this.channel.pipeline().replace("aggregator", "aggregator", (ChannelHandler)new NetconfMessageAggregator(FramingMechanism.CHUNK));
                this.channel.pipeline().addAfter("aggregator", "chunkDecoder", (ChannelHandler)new NetconfMessageChunkDecoder());
            }
            this.changeState(State.ESTABLISHED);
            S session = this.getSession(this.sessionListener, this.channel, netconfMessage);
            this.negotiationSuccessful((AbstractProtocolSession)session);
        } else {
            IllegalStateException cause = new IllegalStateException("Received message was not hello as expected, but was " + XmlUtil.toString(doc));
            logger.warn("Negotiation of netconf session failed", (Throwable)cause);
            this.negotiationFailed(cause);
        }
    }

    protected abstract S getSession(SessionListener var1, Channel var2, NetconfMessage var3);

    private boolean isHelloMessage(Document doc) {
        try {
            XmlElement.fromDomElementWithExpected(doc.getDocumentElement(), "hello", "urn:ietf:params:xml:ns:netconf:base:1.0");
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return false;
        }
        return true;
    }

    private void changeState(State newState) {
        logger.debug("Changing state from : {} to : {}", (Object)this.state, (Object)newState);
        Preconditions.checkState((boolean)AbstractNetconfSessionNegotiator.isStateChangePermitted(this.state, newState), (String)"Cannot change state from %s to %s", (Object[])new Object[]{this.state, newState});
        this.state = newState;
    }

    private boolean containsBase11Capability(Document doc) {
        NodeList nList = doc.getElementsByTagName("capability");
        for (int i = 0; i < nList.getLength(); ++i) {
            if (!nList.item(i).getTextContent().contains("base:1.1")) continue;
            return true;
        }
        return false;
    }

    private static boolean isStateChangePermitted(State state, State newState) {
        if (state == State.IDLE && newState == State.OPEN_WAIT) {
            return true;
        }
        if (state == State.OPEN_WAIT && newState == State.ESTABLISHED) {
            return true;
        }
        return state == State.OPEN_WAIT && newState == State.FAILED;
    }

    private static enum State {
        IDLE,
        OPEN_WAIT,
        FAILED,
        ESTABLISHED;

    }
}

