/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util;

import io.netty.channel.ChannelHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Promise;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.util.handler.FramingMechanismHandlerFactory;
import org.opendaylight.controller.netconf.util.handler.NetconfHandlerFactory;
import org.opendaylight.controller.netconf.util.handler.NetconfMessageAggregator;
import org.opendaylight.controller.netconf.util.messages.FramingMechanism;
import org.opendaylight.controller.netconf.util.messages.NetconfMessageFactory;

public abstract class AbstractChannelInitializer {
    public void initialize(SocketChannel ch, Promise<? extends NetconfSession> promise) {
        NetconfHandlerFactory handlerFactory = new NetconfHandlerFactory(new NetconfMessageFactory());
        ch.pipeline().addLast("aggregator", (ChannelHandler)new NetconfMessageAggregator(FramingMechanism.EOM));
        ch.pipeline().addLast(handlerFactory.getDecoders());
        this.initializeAfterDecoder(ch, promise);
        ch.pipeline().addLast("frameEncoder", FramingMechanismHandlerFactory.createHandler(FramingMechanism.EOM));
        ch.pipeline().addLast(handlerFactory.getEncoders());
    }

    protected abstract void initializeAfterDecoder(SocketChannel var1, Promise<? extends NetconfSession> var2);
}

