/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.simpleforwarding.internal;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.IfNewHostNotify;
import org.opendaylight.controller.hosttracker.hostAware.HostNodeConnector;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.action.SetDlDst;
import org.opendaylight.controller.sal.action.SetVlanId;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Path;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.routing.IListenRoutingUpdates;
import org.opendaylight.controller.sal.routing.IRouting;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.NodeConnectorCreator;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.samples.simpleforwarding.HostNodePair;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleForwardingImpl
implements IfNewHostNotify,
IListenRoutingUpdates,
IInventoryListener {
    private static Logger log = LoggerFactory.getLogger(SimpleForwardingImpl.class);
    private static short DEFAULT_IPSWITCH_PRIORITY = 1;
    private static String FORWARDING_RULES_CACHE_NAME = "forwarding.ipswitch.rules";
    private IfIptoHost hostTracker;
    private IForwardingRulesManager frm;
    private ITopologyManager topologyManager;
    private IRouting routing;
    private ConcurrentMap<HostNodePair, HashMap<NodeConnector, FlowEntry>> rulesDB;
    private Map<Node, List<FlowEntry>> tobePrunedPos = new HashMap<Node, List<FlowEntry>>();
    private IClusterContainerServices clusterContainerService = null;
    private ISwitchManager switchManager;

    public void setRouting(IRouting routing) {
        this.routing = routing;
    }

    public void unsetRouting(IRouting routing) {
        if (this.routing == routing) {
            this.routing = null;
        }
    }

    public ITopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    public void setTopologyManager(ITopologyManager topologyManager) {
        log.debug("Setting topologyManager");
        this.topologyManager = topologyManager;
    }

    public void unsetTopologyManager(ITopologyManager topologyManager) {
        if (this.topologyManager == topologyManager) {
            this.topologyManager = null;
        }
    }

    public void setHostTracker(IfIptoHost hostTracker) {
        log.debug("Setting HostTracker");
        this.hostTracker = hostTracker;
    }

    public void setForwardingRulesManager(IForwardingRulesManager forwardingRulesManager) {
        log.debug("Setting ForwardingRulesManager");
        this.frm = forwardingRulesManager;
    }

    public void unsetHostTracker(IfIptoHost hostTracker) {
        if (this.hostTracker == hostTracker) {
            this.hostTracker = null;
        }
    }

    public void unsetForwardingRulesManager(IForwardingRulesManager forwardingRulesManager) {
        if (this.frm == forwardingRulesManager) {
            this.frm = null;
        }
    }

    public void startUp() {
        this.allocateCaches();
        this.retrieveCaches();
    }

    public void shutDown() {
        log.debug("Destroy all the host Rules given we are shutting down");
        this.uninstallPerHostRules();
        this.destroyCaches();
    }

    private void allocateCaches() {
        if (this.clusterContainerService == null) {
            log.trace("un-initialized clusterContainerService, can't create cache");
            return;
        }
        try {
            this.clusterContainerService.createCache(FORWARDING_RULES_CACHE_NAME, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheExistException cee) {
            log.error("\nCache already exists - destroy and recreate if needed");
        }
        catch (CacheConfigException cce) {
            log.error("\nCache configuration invalid - check cache mode");
        }
    }

    private void retrieveCaches() {
        if (this.clusterContainerService == null) {
            log.trace("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        this.rulesDB = this.clusterContainerService.getCache(FORWARDING_RULES_CACHE_NAME);
        if (this.rulesDB == null) {
            log.error("\nFailed to get rulesDB handle");
        }
    }

    private void destroyCaches() {
        if (this.clusterContainerService == null) {
            log.trace("un-initialized clusterContainerService, can't destroy cache");
            return;
        }
        this.clusterContainerService.destroyCache(FORWARDING_RULES_CACHE_NAME);
    }

    private void updatePerHostRuleInSW(HostNodeConnector host, Node currNode, Node rootNode, Edge link, HostNodePair key) {
        if (host == null || key == null || currNode == null || rootNode == null) {
            return;
        }
        HashSet<NodeConnector> ports = new HashSet<NodeConnector>();
        ports.add(NodeConnectorCreator.createNodeConnector((String)NodeConnector.NodeConnectorIDType.ALL, (Object)NodeConnector.SPECIALNODECONNECTORID, (Node)currNode));
        HashMap<NodeConnector, FlowEntry> pos = (HashMap<NodeConnector, FlowEntry>)this.rulesDB.get(key);
        if (pos == null) {
            pos = new HashMap<NodeConnector, FlowEntry>();
        }
        for (NodeConnector inPort : ports) {
            if (currNode.equals((Object)rootNode) && host.getnodeConnector().equals((Object)inPort)) continue;
            FlowEntry removed_po = (FlowEntry)pos.remove(inPort);
            Match match = new Match();
            ArrayList<Object> actions = new ArrayList<Object>();
            match.setField(MatchType.DL_TYPE, (Object)EtherTypes.IPv4.shortValue());
            match.setField(MatchType.NW_DST, (Object)host.getNetworkAddress());
            NodeConnector outPort = null;
            if (currNode.equals((Object)rootNode)) {
                outPort = host.getnodeConnector();
                if (inPort.equals((Object)outPort)) continue;
                actions.add(new SetDlDst(host.getDataLayerAddressBytes()));
                if (!inPort.getType().equals(NodeConnector.NodeConnectorIDType.ALL)) {
                    actions.add(new PopVlan());
                }
            } else if (link != null) {
                outPort = link.getTailNodeConnector();
                if (inPort.equals((Object)outPort)) continue;
                if (this.topologyManager.isInternal(outPort)) {
                    log.debug("outPort {}/{} is internal uplink port", (Object)currNode, (Object)outPort);
                } else {
                    log.debug("outPort {}/{} is host facing port", (Object)currNode, (Object)outPort);
                }
                if (!inPort.getType().equals(NodeConnector.NodeConnectorIDType.ALL) && this.topologyManager.isInternal(outPort)) {
                    Node nextNode = link.getHeadNodeConnector().getNode();
                    short tag = 0;
                    if (tag != 0) {
                        log.debug("adding SET_VLAN {} for traffic leaving {}/{} toward switch {}", new Object[]{tag, currNode, outPort, nextNode});
                        actions.add(new SetVlanId((int)tag));
                    } else {
                        log.debug("No tag assigned to switch {}", (Object)nextNode);
                    }
                }
            }
            if (outPort != null) {
                actions.add(new Output(outPort));
            }
            if (!inPort.getType().equals(NodeConnector.NodeConnectorIDType.ALL)) {
                match.setField(MatchType.IN_PORT, (Object)inPort);
                if (this.topologyManager.isInternal(inPort)) {
                    log.debug("inPort {}/{} is internal uplink port", (Object)currNode, (Object)inPort);
                } else {
                    log.debug("inPort {}/{} is host facing port", (Object)currNode, (Object)inPort);
                }
                if (this.topologyManager.isInternal(inPort)) {
                    short tag = 0;
                    if (tag != 0) {
                        log.debug("adding MATCH VLAN {} for traffic entering  {}/{}", new Object[]{tag, currNode, inPort});
                        match.setField(MatchType.DL_VLAN, (Object)tag);
                    } else {
                        log.debug("No tag assigned to switch {}", (Object)currNode);
                    }
                }
            }
            Flow flow = new Flow(match, actions);
            flow.setIdleTimeout((short)0);
            flow.setHardTimeout((short)0);
            flow.setPriority(DEFAULT_IPSWITCH_PRIORITY);
            String policyName = host.getNetworkAddress().getHostAddress() + "/32";
            String flowName = "[" + (!inPort.getType().equals(NodeConnector.NodeConnectorIDType.ALL) ? inPort.getID().toString() + "," : "") + host.getNetworkAddress().getHostAddress() + "/32 on N " + currNode + "]";
            FlowEntry po = new FlowEntry(policyName, flowName, flow, currNode);
            pos.put(inPort, po);
            this.rulesDB.put(key, pos);
            if (!inPort.getType().equals(NodeConnector.NodeConnectorIDType.ALL)) {
                log.debug("Adding Match(inPort = {} , DIP = {}) Action(outPort= {}) to node {}", new Object[]{inPort, host.getNetworkAddress().getHostAddress(), outPort, currNode});
                if (removed_po == null || po.getFlow().getMatch().equals((Object)removed_po.getFlow().getMatch())) continue;
                log.debug("Old Flow match: {}, New Flow match: {}", (Object)removed_po.getFlow().getMatch(), (Object)po.getFlow().getMatch());
                this.addTobePrunedPolicy(currNode, removed_po, po);
                continue;
            }
            log.debug("Adding policyMatch(DIP = {}) Action(outPort= {}) to node {}", new Object[]{host.getNetworkAddress().getHostAddress(), outPort, currNode});
        }
    }

    private Set<Node> preparePerHostRules(HostNodeConnector host) {
        if (host == null) {
            return null;
        }
        if (this.routing == null) {
            return null;
        }
        if (this.switchManager == null) {
            return null;
        }
        if (this.rulesDB == null) {
            return null;
        }
        Node rootNode = host.getnodeconnectorNode();
        Set nodes = this.switchManager.getNodes();
        HashSet<Node> switchesToProgram = new HashSet<Node>();
        for (Node node : nodes) {
            HostNodePair key;
            List links;
            if (node.equals((Object)rootNode)) continue;
            Path res = this.routing.getRoute(node, rootNode);
            if (res == null || (links = res.getEdges()) == null) {
                log.debug("NO Route/Path between SW[{}] --> SW[{}] cleaning potentially existing entries", (Object)node, (Object)rootNode);
                key = new HostNodePair(host, node);
                HashMap pos = (HashMap)this.rulesDB.get(key);
                if (pos == null) continue;
                for (Map.Entry e : pos.entrySet()) {
                    FlowEntry po = (FlowEntry)e.getValue();
                    if (po == null) continue;
                    this.frm.uninstallFlowEntry(po);
                }
                this.rulesDB.remove(key);
                continue;
            }
            log.debug("Route between SW[{}] --> SW[{}]", (Object)node, (Object)rootNode);
            Node currNode = node;
            key = new HostNodePair(host, currNode);
            for (Edge link : links) {
                if (link == null) {
                    log.error("Could not retrieve the Link");
                    continue;
                }
                log.debug(link.toString());
                this.updatePerHostRuleInSW(host, currNode, rootNode, link, key);
                if (this.rulesDB.get(key) != null) {
                    switchesToProgram.add(currNode);
                }
                currNode = link.getHeadNodeConnector().getNode();
                key = new HostNodePair(host, currNode);
            }
        }
        switchesToProgram.add(rootNode);
        this.updatePerHostRuleInSW(host, rootNode, rootNode, null, new HostNodePair(host, rootNode));
        return switchesToProgram;
    }

    private Set<Node> preparePerHostPerSwitchRules(HostNodeConnector host, Node node, NodeConnector swport) {
        List links;
        if (host == null || node == null) {
            return null;
        }
        if (this.routing == null) {
            return null;
        }
        if (this.switchManager == null) {
            return null;
        }
        if (this.rulesDB == null) {
            return null;
        }
        Node rootNode = host.getnodeconnectorNode();
        HashSet<Node> switchesToProgram = new HashSet<Node>();
        Path res = this.routing.getRoute(node, rootNode);
        if (res == null || (links = res.getEdges()) == null) {
            log.debug("NO Route/Path between SW[{}] --> SW[{}] cleaning potentially existing entries", (Object)node, (Object)rootNode);
            HostNodePair key = new HostNodePair(host, node);
            Map pos = (Map)this.rulesDB.get(key);
            if (pos != null) {
                for (Map.Entry e : pos.entrySet()) {
                    FlowEntry po = (FlowEntry)e.getValue();
                    if (po == null) continue;
                    this.frm.uninstallFlowEntry(po);
                }
                this.rulesDB.remove(key);
            }
            return null;
        }
        log.debug("Route between SW[{}] --> SW[{}]", (Object)node, (Object)rootNode);
        Node currNode = node;
        HostNodePair key = new HostNodePair(host, currNode);
        Integer curr = 0;
        while (curr < links.size()) {
            Edge link = (Edge)links.get(curr);
            if (link != null) {
                log.debug("Link [{}/{}] --> [{}/{}]", new Object[]{currNode, link.getHeadNodeConnector(), link.getHeadNodeConnector().getNode(), link.getTailNodeConnector()});
                switchesToProgram.add(currNode);
                this.updatePerHostRuleInSW(host, currNode, rootNode, link, key);
                break;
            }
            log.error("Could not retrieve the Link");
            Integer n = curr;
            Integer n2 = curr = Integer.valueOf(curr + 1);
        }
        return switchesToProgram;
    }

    private RulesProgrammingReturnCode installPerHostRules(HostNodeConnector host, Set<Node> switchesToProgram) {
        RulesProgrammingReturnCode retCode = RulesProgrammingReturnCode.SUCCESS;
        if (host == null || switchesToProgram == null) {
            return RulesProgrammingReturnCode.FAILED_WRONG_PARAMS;
        }
        log.debug("Inside installPerHostRules");
        for (Node swId : switchesToProgram) {
            HostNodePair key = new HostNodePair(host, swId);
            Map pos = (Map)this.rulesDB.get(key);
            if (pos == null) continue;
            for (Map.Entry e : pos.entrySet()) {
                FlowEntry po = (FlowEntry)e.getValue();
                if (po != null) {
                    Status poStatus = this.frm.modifyOrAddFlowEntry(po);
                    if (!poStatus.isSuccess()) {
                        log.error("Failed to install policy: " + po.getGroupName() + " (" + poStatus.getDescription() + ")");
                        retCode = RulesProgrammingReturnCode.FAILED_FEW_SWITCHES;
                        this.rulesDB.remove(key);
                        continue;
                    }
                    log.debug("Successfully installed policy " + po.toString() + " on switch " + swId);
                    continue;
                }
                log.error("Cannot find a policy for SW:({}) Host: ({})", (Object)swId, (Object)host);
            }
        }
        log.debug("Leaving installPerHostRules");
        return retCode;
    }

    private RulesProgrammingReturnCode uninstallPerHostRules(HostNodeConnector host) {
        RulesProgrammingReturnCode retCode = RulesProgrammingReturnCode.SUCCESS;
        for (HostNodePair key : this.rulesDB.keySet()) {
            if (host != null && !key.getHost().equals((Object)host)) continue;
            Map pos = (Map)this.rulesDB.get(key);
            for (Map.Entry e : pos.entrySet()) {
                FlowEntry po = (FlowEntry)e.getValue();
                if (po == null) continue;
                this.frm.uninstallFlowEntry(po);
            }
            this.rulesDB.remove(key);
        }
        return retCode;
    }

    private void uninstallPerNodeRules(Node targetNode) {
        for (HostNodePair key : this.rulesDB.keySet()) {
            Node node = key.getNode();
            if (targetNode != null && !node.equals((Object)targetNode)) continue;
            log.debug("Work on {} host {}", (Object)node, (Object)key.getHost());
            Map pos = (Map)this.rulesDB.get(key);
            for (Map.Entry e : pos.entrySet()) {
                FlowEntry po = (FlowEntry)e.getValue();
                if (po == null) continue;
                this.frm.uninstallFlowEntry(po);
            }
            log.debug("Remove {}", (Object)key);
            this.rulesDB.remove(key);
        }
    }

    private RulesProgrammingReturnCode uninstallPerHostRules() {
        return this.uninstallPerHostRules(null);
    }

    public void recalculateDone() {
        if (this.hostTracker == null) {
            return;
        }
        Set allHosts = this.hostTracker.getAllHosts();
        for (HostNodeConnector host : allHosts) {
            Set<Node> switches = this.preparePerHostRules(host);
            if (switches == null) continue;
            this.installPerHostRules(host, switches);
            this.pruneExcessRules(switches);
        }
    }

    void addTobePrunedPolicy(Node swId, FlowEntry po, FlowEntry new_po) {
        List<FlowEntry> pl = this.tobePrunedPos.get(swId);
        if (pl == null) {
            pl = new LinkedList<FlowEntry>();
            this.tobePrunedPos.put(swId, pl);
        }
        pl.add(po);
        log.debug("Adding Pruned Policy for SwId: {}", (Object)swId);
        log.debug("Old Policy: {}", (Object)po);
        log.debug("New Policy: {}", (Object)new_po);
    }

    private void pruneExcessRules(Set<Node> switches) {
        for (Node swId : switches) {
            List<FlowEntry> pl = this.tobePrunedPos.get(swId);
            if (pl == null) continue;
            log.debug("Policies for Switch: {} in the list to be deleted: {}", (Object)swId, pl);
            Iterator<FlowEntry> plIter = pl.iterator();
            while (plIter.hasNext()) {
                FlowEntry po = plIter.next();
                log.error("Removing Policy, Switch: {} Policy: {}", (Object)swId, (Object)po);
                this.frm.uninstallFlowEntry(po);
                plIter.remove();
            }
        }
    }

    private void updateRulesforHIFup(Node node, NodeConnector swPort) {
        if (this.hostTracker == null) {
            return;
        }
        log.debug("Host Facing Port in a container came up, install the rules for all hosts from this port !");
        Set allHosts = this.hostTracker.getAllHosts();
        for (HostNodeConnector host : allHosts) {
            Set<Node> switches;
            if (node.equals((Object)host.getnodeconnectorNode()) || (switches = this.preparePerHostPerSwitchRules(host, node, swPort)) == null) continue;
            this.installPerHostRules(host, switches);
        }
    }

    public void notifyHTClient(HostNodeConnector host) {
        if (host == null) {
            return;
        }
        Set<Node> switches = this.preparePerHostRules(host);
        if (switches != null) {
            this.installPerHostRules(host, switches);
        }
    }

    public void notifyHTClientHostRemoved(HostNodeConnector host) {
        if (host == null) {
            return;
        }
        this.uninstallPerHostRules(host);
    }

    public void notifyNode(Node node, UpdateType type, Map<String, Property> propMap) {
        if (node == null) {
            return;
        }
        switch (type) {
            case REMOVED: {
                log.debug("Node {} gone, doing a cleanup", (Object)node);
                this.uninstallPerNodeRules(node);
                break;
            }
        }
    }

    public void notifyNodeConnector(NodeConnector nodeConnector, UpdateType type, Map<String, Property> propMap) {
        if (nodeConnector == null) {
            return;
        }
        boolean up = false;
        switch (type) {
            case ADDED: {
                up = true;
                break;
            }
            case REMOVED: {
                break;
            }
            case CHANGED: {
                State state = (State)propMap.get("state");
                if (state == null || state.getValue() != 1) break;
                up = true;
                break;
            }
            default: {
                return;
            }
        }
        if (up) {
            this.handleNodeConnectorStatusUp(nodeConnector);
        } else {
            this.handleNodeConnectorStatusDown(nodeConnector);
        }
    }

    private void handleNodeConnectorStatusUp(NodeConnector nodeConnector) {
        if (this.topologyManager == null) {
            log.debug("topologyManager is not set yet");
            return;
        }
        if (this.topologyManager.isInternal(nodeConnector)) {
            log.debug("{} is not a host facing link", (Object)nodeConnector);
            return;
        }
        log.debug("{} is up", (Object)nodeConnector);
        this.updateRulesforHIFup(nodeConnector.getNode(), nodeConnector);
    }

    private void handleNodeConnectorStatusDown(NodeConnector nodeConnector) {
        log.debug("{} is down", (Object)nodeConnector);
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    void init() {
        this.startUp();
    }

    void destroy() {
    }

    void start() {
    }

    void stop() {
    }

    public void setSwitchManager(ISwitchManager switchManager) {
        this.switchManager = switchManager;
    }

    public void unsetSwitchManager(ISwitchManager switchManager) {
        if (this.switchManager == switchManager) {
            this.switchManager = null;
        }
    }

    public static enum RulesProgrammingReturnCode {
        SUCCESS,
        FAILED_FEW_SWITCHES,
        FAILED_ALL_SWITCHES,
        FAILED_WRONG_PARAMS;

    }
}

