/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.simpleforwarding.internal;

import java.util.HashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.packet.Ethernet;
import org.opendaylight.controller.sal.packet.IDataPacketService;
import org.opendaylight.controller.sal.packet.IListenDataPacket;
import org.opendaylight.controller.sal.packet.Packet;
import org.opendaylight.controller.sal.packet.PacketResult;
import org.opendaylight.controller.sal.packet.RawPacket;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.samples.simpleforwarding.IBroadcastHandler;
import org.opendaylight.controller.samples.simpleforwarding.IBroadcastPortSelector;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBroadcastHandlerImpl
implements IBroadcastHandler,
IListenDataPacket {
    private static Logger log = LoggerFactory.getLogger(SimpleBroadcastHandlerImpl.class);
    protected IDataPacketService dataPacketService = null;
    protected ITopologyManager topoManager = null;
    protected ISwitchManager swMgr = null;
    protected IBroadcastPortSelector bcastPorts = null;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    IBroadcastHandler.BroadcastMode mode = IBroadcastHandler.BroadcastMode.BROADCAST_TO_NONINTERNAL;

    public PacketResult receiveDataPacket(RawPacket inPkt) {
        Ethernet eth;
        if (this.mode == IBroadcastHandler.BroadcastMode.DISABLED) {
            return PacketResult.IGNORED;
        }
        Packet decodedPkt = this.dataPacketService.decodeDataPacket(inPkt);
        if (decodedPkt instanceof Ethernet && (eth = (Ethernet)decodedPkt).getEtherType() != EtherTypes.LLDP.shortValue()) {
            if (eth.isBroadcast()) {
                this.broadcastPacket(inPkt);
            } else if (eth.isMulticast()) {
                this.broadcastPacket(inPkt);
            }
        }
        return PacketResult.KEEP_PROCESSING;
    }

    @Override
    public boolean broadcastPacket(RawPacket pkt) {
        HashSet<NodeConnector> toPacketOut = new HashSet<NodeConnector>();
        this.lock.readLock().lock();
        if (this.topoManager == null || this.dataPacketService == null || this.swMgr == null) {
            return false;
        }
        switch (this.mode) {
            case DISABLED: {
                break;
            }
            case BROADCAST_TO_HOSTS: {
                toPacketOut.addAll(this.topoManager.getNodeConnectorWithHost());
                break;
            }
            case BROADCAST_TO_NONINTERNAL: {
                for (Node n : this.swMgr.getNodes()) {
                    for (NodeConnector nc : this.swMgr.getUpNodeConnectors(n)) {
                        if (this.topoManager.isInternal(nc)) continue;
                        toPacketOut.add(nc);
                    }
                }
                break;
            }
            case EXTERNAL_QUERY: {
                if (this.bcastPorts != null) {
                    toPacketOut.addAll(this.bcastPorts.getBroadcastPorts());
                    break;
                }
                log.error("Mode set to " + (Object)((Object)IBroadcastHandler.BroadcastMode.EXTERNAL_QUERY) + ", but no external source of broadcast ports was provided.");
                return false;
            }
            default: {
                log.error("Mode " + (Object)((Object)this.mode) + " is not supported.");
            }
        }
        toPacketOut.remove(pkt.getIncomingNodeConnector());
        for (NodeConnector nc : toPacketOut) {
            try {
                RawPacket toSend = new RawPacket(pkt);
                toSend.setOutgoingNodeConnector(nc);
                this.dataPacketService.transmitDataPacket(toSend);
            }
            catch (ConstructionException e) {
                log.error("Could create packet: {}", (Throwable)e);
            }
        }
        this.lock.readLock().unlock();
        return true;
    }

    public void setDataPacketService(IDataPacketService s) {
        this.lock.writeLock().lock();
        this.dataPacketService = s;
        this.lock.writeLock().unlock();
    }

    public void unsetDataPacketService(IDataPacketService s) {
        this.lock.writeLock().lock();
        if (this.dataPacketService == s) {
            this.dataPacketService = null;
        }
        this.lock.writeLock().unlock();
    }

    public void setTopologyManager(ITopologyManager t) {
        this.lock.writeLock().lock();
        this.topoManager = t;
        this.lock.writeLock().unlock();
    }

    public void unsetTopologyManager(ITopologyManager t) {
        this.lock.writeLock().lock();
        if (this.topoManager == t) {
            this.topoManager = null;
        }
        this.lock.writeLock().unlock();
    }

    public void setSwitchManager(ISwitchManager i) {
        this.lock.writeLock().lock();
        this.swMgr = i;
        this.lock.writeLock().unlock();
    }

    public void unsetSwitchManager(ISwitchManager i) {
        this.lock.writeLock().lock();
        if (this.swMgr == i) {
            this.swMgr = null;
        }
        this.lock.writeLock().unlock();
    }

    public void setBroadcastPortSelector(IBroadcastPortSelector bps) {
        this.lock.writeLock().lock();
        this.bcastPorts = bps;
        this.lock.writeLock().unlock();
    }

    public void unsetBroadcastPortSelector(IBroadcastPortSelector bps) {
        this.lock.writeLock().lock();
        if (this.bcastPorts == bps) {
            this.bcastPorts = null;
        }
        this.lock.writeLock().unlock();
    }

    @Override
    public void setMode(IBroadcastHandler.BroadcastMode m) {
        this.lock.writeLock().lock();
        this.mode = m;
        this.lock.writeLock().unlock();
    }
}

