/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.samples.simpleforwarding.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.hosttracker.IfIptoHost;
import org.opendaylight.controller.hosttracker.IfNewHostNotify;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.packet.IDataPacketService;
import org.opendaylight.controller.sal.packet.IListenDataPacket;
import org.opendaylight.controller.sal.routing.IListenRoutingUpdates;
import org.opendaylight.controller.sal.routing.IRouting;
import org.opendaylight.controller.samples.simpleforwarding.IBroadcastHandler;
import org.opendaylight.controller.samples.simpleforwarding.IBroadcastPortSelector;
import org.opendaylight.controller.samples.simpleforwarding.internal.SimpleBroadcastHandlerImpl;
import org.opendaylight.controller.samples.simpleforwarding.internal.SimpleForwardingImpl;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{SimpleForwardingImpl.class, SimpleBroadcastHandlerImpl.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        if (imp.equals(SimpleForwardingImpl.class)) {
            c.setInterface(new String[]{IInventoryListener.class.getName(), IfNewHostNotify.class.getName(), IListenRoutingUpdates.class.getName()}, null);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IClusterContainerServices.class).setCallbacks("setClusterContainerService", "unsetClusterContainerService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISwitchManager.class).setCallbacks("setSwitchManager", "unsetSwitchManager").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IfIptoHost.class).setCallbacks("setHostTracker", "unsetHostTracker").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IForwardingRulesManager.class).setCallbacks("setForwardingRulesManager", "unsetForwardingRulesManager").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ITopologyManager.class).setCallbacks("setTopologyManager", "unsetTopologyManager").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IRouting.class).setCallbacks("setRouting", "unsetRouting").setRequired(false));
        } else if (imp.equals(SimpleBroadcastHandlerImpl.class)) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("salListenerName", "simplebroadcasthandler");
            c.setInterface(new String[]{IBroadcastHandler.class.getName(), IListenDataPacket.class.getName()}, props);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IDataPacketService.class).setCallbacks("setDataPacketService", "unsetDataPacketService").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ITopologyManager.class).setCallbacks("setTopologyManager", "unsetTopologyManager").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IBroadcastPortSelector.class).setCallbacks("setBroadcastPortSelector", "unsetBroadcastPortSelector").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISwitchManager.class).setCallbacks("setSwitchManager", "unsetSwitchManager").setRequired(false));
        }
    }
}

