/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.routing.dijkstra_implementation.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.service.command.Descriptor;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.Path;
import org.opendaylight.controller.sal.routing.IRouting;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.osgi.framework.ServiceRegistration;

public class DijkstraImplementationCLI {
    private ServiceRegistration sr = null;

    public void init() {
    }

    public void destroy() {
    }

    public void start() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", "odpcontroller");
        ((Dictionary)props).put("osgi.command.function", new String[]{"getRoute"});
        this.sr = ServiceHelper.registerGlobalServiceWReg(DijkstraImplementationCLI.class, (Object)this, props);
    }

    public void stop() {
        if (this.sr != null) {
            this.sr.unregister();
            this.sr = null;
        }
    }

    @Descriptor(value="Retrieves a Route between two Nodes in the discovered Topology DB")
    public void getRoute(@Descriptor(value="Container on the context of which the routing service need to be looked up") String container, @Descriptor(value="String representation of the Source Node, this need to be consumable from Node.fromString()") String srcNode, @Descriptor(value="String representation of the Destination Node") String dstNode) {
        Node dst;
        IRouting r = (IRouting)ServiceHelper.getInstance(IRouting.class, (String)container, (Object)this);
        if (r == null) {
            System.out.println("Cannot find the routing instance on container:" + container);
            return;
        }
        Node src = Node.fromString((String)srcNode);
        Path p = r.getRoute(src, dst = Node.fromString((String)dstNode));
        if (p != null) {
            System.out.println("Route between srcNode:" + src + " and dstNode:" + dst + " = " + p);
        } else {
            System.out.println("There is no route between srcNode:" + src + " and dstNode:" + dst);
        }
    }
}

