/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.routing.dijkstra_implementation.internal;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections15.Transformer;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.sal.core.Bandwidth;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Edge;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Path;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.routing.IListenRoutingUpdates;
import org.opendaylight.controller.sal.routing.IRouting;
import org.opendaylight.controller.sal.topology.TopoEdgeUpdate;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.topologymanager.ITopologyManager;
import org.opendaylight.controller.topologymanager.ITopologyManagerClusterWideAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DijkstraImplementation
implements IRouting,
ITopologyManagerClusterWideAware {
    private static Logger log = LoggerFactory.getLogger(DijkstraImplementation.class);
    private ConcurrentMap<Short, Graph<Node, Edge>> topologyBWAware;
    private ConcurrentMap<Short, DijkstraShortestPath<Node, Edge>> sptBWAware;
    DijkstraShortestPath<Node, Edge> mtp;
    private Set<IListenRoutingUpdates> routingAware;
    private ISwitchManager switchManager;
    private ITopologyManager topologyManager;
    private static final long DEFAULT_LINK_SPEED = Bandwidth.BW1Gbps;
    private IClusterContainerServices clusterContainerService;

    public void setListenRoutingUpdates(IListenRoutingUpdates i) {
        if (this.routingAware == null) {
            this.routingAware = new HashSet<IListenRoutingUpdates>();
        }
        if (this.routingAware != null) {
            log.debug("Adding routingAware listener: {}", (Object)i);
            this.routingAware.add(i);
        }
    }

    public void unsetListenRoutingUpdates(IListenRoutingUpdates i) {
        if (this.routingAware == null) {
            return;
        }
        log.debug("Removing routingAware listener");
        this.routingAware.remove(i);
        if (this.routingAware.isEmpty()) {
            this.routingAware = null;
        }
    }

    public synchronized void initMaxThroughput(final Map<Edge, Number> EdgeWeightMap) {
        if (this.mtp != null) {
            log.error("Max Throughput Dijkstra is already enabled!");
            return;
        }
        Object mtTransformer = null;
        mtTransformer = EdgeWeightMap == null ? new Transformer<Edge, Double>(){

            public Double transform(Edge e) {
                long avlDstThruPut;
                long avlSrcThruPut;
                long avlThruPut;
                if (DijkstraImplementation.this.switchManager == null) {
                    log.error("switchManager is null");
                    return -1.0;
                }
                NodeConnector srcNC = e.getTailNodeConnector();
                NodeConnector dstNC = e.getHeadNodeConnector();
                if (srcNC == null || dstNC == null) {
                    log.error("srcNC:{} or dstNC:{} is null", (Object)srcNC, (Object)dstNC);
                    return -1.0;
                }
                Bandwidth bwSrc = (Bandwidth)DijkstraImplementation.this.switchManager.getNodeConnectorProp(srcNC, "bandwidth");
                Bandwidth bwDst = (Bandwidth)DijkstraImplementation.this.switchManager.getNodeConnectorProp(dstNC, "bandwidth");
                long srcLinkSpeed = 0L;
                long dstLinkSpeed = 0L;
                if (bwSrc == null || (srcLinkSpeed = bwSrc.getValue()) == 0L) {
                    log.debug("srcNC: {} - Setting srcLinkSpeed to Default!", (Object)srcNC);
                    srcLinkSpeed = DEFAULT_LINK_SPEED;
                }
                if (bwDst == null || (dstLinkSpeed = bwDst.getValue()) == 0L) {
                    log.debug("dstNC: {} - Setting dstLinkSpeed to Default!", (Object)dstNC);
                    dstLinkSpeed = DEFAULT_LINK_SPEED;
                }
                long l = avlThruPut = (avlSrcThruPut = srcLinkSpeed) < (avlDstThruPut = dstLinkSpeed) ? avlSrcThruPut : avlDstThruPut;
                if (avlThruPut <= 0L) {
                    log.debug("Edge {}: Available Throughput {} <= 0!", (Object)e, (Object)avlThruPut);
                    return -1.0;
                }
                return Bandwidth.BW1Pbps / avlThruPut;
            }
        } : new Transformer<Edge, Number>(){

            public Number transform(Edge e) {
                return (Number)EdgeWeightMap.get(e);
            }
        };
        Short baseBW = 0;
        Graph g = (Graph)this.topologyBWAware.get(baseBW);
        if (g == null) {
            log.error("Default Topology Graph is null");
            return;
        }
        this.mtp = new DijkstraShortestPath(g, (Transformer)mtTransformer);
    }

    public Path getRoute(Node src, Node dst) {
        if (src == null || dst == null) {
            return null;
        }
        return this.getRoute(src, dst, (short)0);
    }

    public synchronized Path getMaxThroughputRoute(Node src, Node dst) {
        Path res;
        List path;
        if (this.mtp == null) {
            log.error("Max Throughput Path Calculation Uninitialized!");
            return null;
        }
        try {
            path = this.mtp.getMaxThroughputPath((Object)src, (Object)dst);
        }
        catch (IllegalArgumentException ie) {
            log.debug("A vertex is yet not known between {} {}", (Object)src, (Object)dst);
            return null;
        }
        try {
            res = new Path(path);
        }
        catch (ConstructionException e) {
            log.debug("A vertex is yet not known between {} {}", (Object)src, (Object)dst);
            return null;
        }
        return res;
    }

    public synchronized Path getRoute(Node src, Node dst, Short Bw) {
        Path res;
        List path;
        DijkstraShortestPath spt = (DijkstraShortestPath)this.sptBWAware.get(Bw);
        if (spt == null) {
            return null;
        }
        try {
            path = spt.getPath((Object)src, (Object)dst);
        }
        catch (IllegalArgumentException ie) {
            log.debug("A vertex is yet not known between {} {}", (Object)src, (Object)dst);
            return null;
        }
        try {
            res = new Path(path);
        }
        catch (ConstructionException e) {
            log.debug("A vertex is yet not known between {} {}", (Object)src, (Object)dst);
            return null;
        }
        return res;
    }

    public synchronized void clear() {
        for (Short bw : this.sptBWAware.keySet()) {
            DijkstraShortestPath spt = (DijkstraShortestPath)this.sptBWAware.get(bw);
            if (spt == null) continue;
            spt.reset();
        }
        this.clearMaxThroughput();
    }

    public synchronized void clearMaxThroughput() {
        if (this.mtp != null) {
            this.mtp.reset();
        }
    }

    private synchronized boolean updateTopo(Edge edge, Short bw, UpdateType type) {
        Graph topo = (Graph)this.topologyBWAware.get(bw);
        DijkstraShortestPath spt = (DijkstraShortestPath)this.sptBWAware.get(bw);
        boolean edgePresentInGraph = false;
        Short baseBW = 0;
        if (topo == null) {
            SparseMultigraph g = new SparseMultigraph();
            this.topologyBWAware.put(bw, (Graph<Node, Edge>)g);
            topo = (Graph)this.topologyBWAware.get(bw);
            this.sptBWAware.put(bw, (DijkstraShortestPath<Node, Edge>)new DijkstraShortestPath((Graph)g));
            spt = (DijkstraShortestPath)this.sptBWAware.get(bw);
        }
        if (topo != null) {
            NodeConnector src = edge.getTailNodeConnector();
            NodeConnector dst = edge.getHeadNodeConnector();
            if (spt == null) {
                spt = new DijkstraShortestPath(topo);
                this.sptBWAware.put(bw, (DijkstraShortestPath<Node, Edge>)spt);
            }
            switch (type) {
                case ADDED: {
                    topo.addVertex((Object)src.getNode());
                    topo.addVertex((Object)dst.getNode());
                    edgePresentInGraph = topo.containsEdge((Object)edge);
                    if (!edgePresentInGraph) {
                        try {
                            topo.addEdge((Object)new Edge(src, dst), (Object)src.getNode(), (Object)dst.getNode(), EdgeType.DIRECTED);
                            break;
                        }
                        catch (ConstructionException e) {
                            log.error("", (Throwable)e);
                            return edgePresentInGraph;
                        }
                    }
                }
                case CHANGED: {
                    break;
                }
                case REMOVED: {
                    try {
                        topo.removeEdge((Object)new Edge(src, dst));
                    }
                    catch (ConstructionException e) {
                        log.error("", (Throwable)e);
                        return edgePresentInGraph;
                    }
                    if (topo.containsVertex((Object)src.getNode()) && topo.inDegree((Object)src.getNode()) == 0 && topo.outDegree((Object)src.getNode()) == 0) {
                        log.debug("Removing vertex {}", (Object)src);
                        topo.removeVertex((Object)src.getNode());
                    }
                    if (!topo.containsVertex((Object)dst.getNode()) || topo.inDegree((Object)dst.getNode()) != 0 || topo.outDegree((Object)dst.getNode()) != 0) break;
                    log.debug("Removing vertex {}", (Object)dst);
                    topo.removeVertex((Object)dst.getNode());
                }
            }
            spt.reset();
            if (bw.equals(baseBW)) {
                this.clearMaxThroughput();
            }
        } else {
            log.error("Cannot find topology for BW {} this is unexpected!", (Object)bw);
        }
        return edgePresentInGraph;
    }

    private boolean edgeUpdate(Edge e, UpdateType type, Set<Property> props, boolean local) {
        Short baseBW;
        String srcType = null;
        String dstType = null;
        log.trace("Got an edgeUpdate: {} props: {} update type: {} local: {}", new Object[]{e, props, type, local});
        if (e == null || type == null) {
            log.error("Edge or Update type are null!");
            return false;
        }
        srcType = e.getTailNodeConnector().getType();
        dstType = e.getHeadNodeConnector().getType();
        if (srcType.equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            log.debug("Skip updates for {}", (Object)e);
            return false;
        }
        if (dstType.equals(NodeConnector.NodeConnectorIDType.PRODUCTION)) {
            log.debug("Skip updates for {}", (Object)e);
            return false;
        }
        Bandwidth bw = new Bandwidth(0);
        boolean newEdge = false;
        if (props != null) {
            props.remove(bw);
        }
        boolean bl = newEdge = !this.updateTopo(e, baseBW = Short.valueOf((short)0), type);
        if (newEdge && bw.getValue() != (long)baseBW.shortValue()) {
            this.updateTopo(e, (short)bw.getValue(), type);
        }
        return newEdge;
    }

    public void edgeUpdate(List<TopoEdgeUpdate> topoedgeupdateList) {
        log.trace("Start of a Bulk EdgeUpdate with " + topoedgeupdateList.size() + " elements");
        boolean callListeners = false;
        for (int i = 0; i < topoedgeupdateList.size(); ++i) {
            boolean isLocal;
            Edge e = topoedgeupdateList.get(i).getEdge();
            Set p = topoedgeupdateList.get(i).getProperty();
            UpdateType type = topoedgeupdateList.get(i).getUpdateType();
            if (!this.edgeUpdate(e, type, p, isLocal = topoedgeupdateList.get(i).isLocal()) || callListeners) continue;
            callListeners = true;
        }
        boolean amICoordinator = true;
        if (this.clusterContainerService != null) {
            amICoordinator = this.clusterContainerService.amICoordinator();
        }
        if (callListeners && this.routingAware != null && amICoordinator) {
            log.trace("Calling the routing listeners");
            for (IListenRoutingUpdates ra : this.routingAware) {
                try {
                    ra.recalculateDone();
                }
                catch (Exception ex) {
                    log.error("Exception on routingAware listener call", (Throwable)ex);
                }
            }
        }
        log.trace("End of a Bulk EdgeUpdate");
    }

    public void init() {
        log.debug("Routing init() is called");
        this.topologyBWAware = new ConcurrentHashMap<Short, Graph<Node, Edge>>();
        this.sptBWAware = new ConcurrentHashMap<Short, DijkstraShortestPath<Node, Edge>>();
        SparseMultigraph g = new SparseMultigraph();
        Short sZero = 0;
        this.topologyBWAware.put(sZero, (Graph<Node, Edge>)g);
        this.sptBWAware.put(sZero, (DijkstraShortestPath<Node, Edge>)new DijkstraShortestPath((Graph)g));
    }

    void destroy() {
        log.debug("Routing destroy() is called");
    }

    void start() {
        log.debug("Routing start() is called");
        Map edges = this.topologyManager.getEdges();
        if (edges.isEmpty()) {
            return;
        }
        ArrayList<TopoEdgeUpdate> topoedgeupdateList = new ArrayList<TopoEdgeUpdate>();
        log.debug("Creating routing database from the topology");
        for (Map.Entry entry : edges.entrySet()) {
            Edge e = (Edge)entry.getKey();
            Set props = (Set)entry.getValue();
            TopoEdgeUpdate topoedgeupdate = new TopoEdgeUpdate(e, props, UpdateType.ADDED);
            topoedgeupdateList.add(topoedgeupdate);
        }
        this.edgeUpdate(topoedgeupdateList);
    }

    public void stop() {
        log.debug("Routing stop() is called");
    }

    public void setSwitchManager(ISwitchManager switchManager) {
        this.switchManager = switchManager;
    }

    public void unsetSwitchManager(ISwitchManager switchManager) {
        if (this.switchManager == switchManager) {
            this.switchManager = null;
        }
    }

    public void setTopologyManager(ITopologyManager tm) {
        this.topologyManager = tm;
    }

    public void unsetTopologyManager(ITopologyManager tm) {
        if (this.topologyManager == tm) {
            this.topologyManager = null;
        }
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    public void edgeOverUtilized(Edge edge) {
    }

    public void edgeUtilBackToNormal(Edge edge) {
    }
}

