/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics;

import com.google.common.collect.Range;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.node.connector.statistics.Bytes;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BytesBuilder {
    private BigInteger _received;
    private BigInteger _transmitted;
    private Map<Class<? extends Augmentation<Bytes>>, Augmentation<Bytes>> augmentation = new HashMap<Class<? extends Augmentation<Bytes>>, Augmentation<Bytes>>();

    public BigInteger getReceived() {
        return this._received;
    }

    public BigInteger getTransmitted() {
        return this._transmitted;
    }

    public <E extends Augmentation<Bytes>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BytesBuilder setReceived(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._received = value;
        return this;
    }

    public BytesBuilder setTransmitted(BigInteger value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new BigInteger("0"), (Comparable)new BigInteger("18446744073709551615")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._transmitted = value;
        return this;
    }

    public BytesBuilder addAugmentation(Class<? extends Augmentation<Bytes>> augmentationType, Augmentation<Bytes> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public Bytes build() {
        return new BytesImpl(this);
    }

    private static final class BytesImpl
    implements Bytes {
        private final BigInteger _received;
        private final BigInteger _transmitted;
        private Map<Class<? extends Augmentation<Bytes>>, Augmentation<Bytes>> augmentation = new HashMap<Class<? extends Augmentation<Bytes>>, Augmentation<Bytes>>();

        public Class<Bytes> getImplementedInterface() {
            return Bytes.class;
        }

        private BytesImpl(BytesBuilder builder) {
            this._received = builder.getReceived();
            this._transmitted = builder.getTransmitted();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public BigInteger getReceived() {
            return this._received;
        }

        @Override
        public BigInteger getTransmitted() {
            return this._transmitted;
        }

        public <E extends Augmentation<Bytes>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._received == null ? 0 : this._received.hashCode());
            result = 31 * result + (this._transmitted == null ? 0 : this._transmitted.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BytesImpl other = (BytesImpl)obj;
            if (this._received == null ? other._received != null : !this._received.equals(other._received)) {
                return false;
            }
            if (this._transmitted == null ? other._transmitted != null : !this._transmitted.equals(other._transmitted)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Bytes [_received=");
            builder.append(this._received);
            builder.append(", _transmitted=");
            builder.append(this._transmitted);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

