/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.Duration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.statistics.MeterBandStats;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterStatisticsBuilder {
    private Counter64 _byteInCount;
    private Duration _duration;
    private Counter32 _flowCount;
    private MeterBandStats _meterBandStats;
    private MeterId _meterId;
    private Counter64 _packetInCount;
    private Map<Class<? extends Augmentation<MeterStatistics>>, Augmentation<MeterStatistics>> augmentation = new HashMap<Class<? extends Augmentation<MeterStatistics>>, Augmentation<MeterStatistics>>();

    public MeterStatisticsBuilder() {
    }

    public MeterStatisticsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics arg) {
        this._byteInCount = arg.getByteInCount();
        this._duration = arg.getDuration();
        this._flowCount = arg.getFlowCount();
        this._meterBandStats = arg.getMeterBandStats();
        this._meterId = arg.getMeterId();
        this._packetInCount = arg.getPacketInCount();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics) {
            this._byteInCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics)arg).getByteInCount();
            this._duration = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics)arg).getDuration();
            this._flowCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics)arg).getFlowCount();
            this._meterBandStats = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics)arg).getMeterBandStats();
            this._meterId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics)arg).getMeterId();
            this._packetInCount = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics)arg).getPacketInCount();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterStatistics] \nbut was: " + arg);
        }
    }

    public Counter64 getByteInCount() {
        return this._byteInCount;
    }

    public Duration getDuration() {
        return this._duration;
    }

    public Counter32 getFlowCount() {
        return this._flowCount;
    }

    public MeterBandStats getMeterBandStats() {
        return this._meterBandStats;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public Counter64 getPacketInCount() {
        return this._packetInCount;
    }

    public <E extends Augmentation<MeterStatistics>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterStatisticsBuilder setByteInCount(Counter64 value) {
        this._byteInCount = value;
        return this;
    }

    public MeterStatisticsBuilder setDuration(Duration value) {
        this._duration = value;
        return this;
    }

    public MeterStatisticsBuilder setFlowCount(Counter32 value) {
        this._flowCount = value;
        return this;
    }

    public MeterStatisticsBuilder setMeterBandStats(MeterBandStats value) {
        this._meterBandStats = value;
        return this;
    }

    public MeterStatisticsBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterStatisticsBuilder setPacketInCount(Counter64 value) {
        this._packetInCount = value;
        return this;
    }

    public MeterStatisticsBuilder addAugmentation(Class<? extends Augmentation<MeterStatistics>> augmentationType, Augmentation<MeterStatistics> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterStatistics build() {
        return new MeterStatisticsImpl(this);
    }

    private static final class MeterStatisticsImpl
    implements MeterStatistics {
        private final Counter64 _byteInCount;
        private final Duration _duration;
        private final Counter32 _flowCount;
        private final MeterBandStats _meterBandStats;
        private final MeterId _meterId;
        private final Counter64 _packetInCount;
        private Map<Class<? extends Augmentation<MeterStatistics>>, Augmentation<MeterStatistics>> augmentation = new HashMap<Class<? extends Augmentation<MeterStatistics>>, Augmentation<MeterStatistics>>();

        public Class<MeterStatistics> getImplementedInterface() {
            return MeterStatistics.class;
        }

        private MeterStatisticsImpl(MeterStatisticsBuilder builder) {
            this._byteInCount = builder.getByteInCount();
            this._duration = builder.getDuration();
            this._flowCount = builder.getFlowCount();
            this._meterBandStats = builder.getMeterBandStats();
            this._meterId = builder.getMeterId();
            this._packetInCount = builder.getPacketInCount();
            this.augmentation.putAll(builder.augmentation);
        }

        public Counter64 getByteInCount() {
            return this._byteInCount;
        }

        public Duration getDuration() {
            return this._duration;
        }

        public Counter32 getFlowCount() {
            return this._flowCount;
        }

        public MeterBandStats getMeterBandStats() {
            return this._meterBandStats;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public Counter64 getPacketInCount() {
            return this._packetInCount;
        }

        public <E extends Augmentation<MeterStatistics>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._byteInCount == null ? 0 : this._byteInCount.hashCode());
            result = 31 * result + (this._duration == null ? 0 : this._duration.hashCode());
            result = 31 * result + (this._flowCount == null ? 0 : this._flowCount.hashCode());
            result = 31 * result + (this._meterBandStats == null ? 0 : this._meterBandStats.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._packetInCount == null ? 0 : this._packetInCount.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterStatisticsImpl other = (MeterStatisticsImpl)obj;
            if (this._byteInCount == null ? other._byteInCount != null : !this._byteInCount.equals((Object)other._byteInCount)) {
                return false;
            }
            if (this._duration == null ? other._duration != null : !this._duration.equals(other._duration)) {
                return false;
            }
            if (this._flowCount == null ? other._flowCount != null : !this._flowCount.equals((Object)other._flowCount)) {
                return false;
            }
            if (this._meterBandStats == null ? other._meterBandStats != null : !this._meterBandStats.equals(other._meterBandStats)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals((Object)other._meterId)) {
                return false;
            }
            if (this._packetInCount == null ? other._packetInCount != null : !this._packetInCount.equals((Object)other._packetInCount)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterStatistics [_byteInCount=");
            builder.append(this._byteInCount);
            builder.append(", _duration=");
            builder.append(this._duration);
            builder.append(", _flowCount=");
            builder.append(this._flowCount);
            builder.append(", _meterBandStats=");
            builder.append(this._meterBandStats);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", _packetInCount=");
            builder.append(this._packetInCount);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

