/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.meter.MeterConfigStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.meter.MeterBandHeaders;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterConfigStatsBuilder {
    private Boolean _barrier;
    private String _containerName;
    private MeterFlags _flags;
    private MeterBandHeaders _meterBandHeaders;
    private MeterId _meterId;
    private String _meterName;
    private Map<Class<? extends Augmentation<MeterConfigStats>>, Augmentation<MeterConfigStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterConfigStats>>, Augmentation<MeterConfigStats>>();

    public MeterConfigStatsBuilder() {
    }

    public MeterConfigStatsBuilder(Meter arg) {
        this._barrier = arg.isBarrier();
        this._containerName = arg.getContainerName();
        this._flags = arg.getFlags();
        this._meterBandHeaders = arg.getMeterBandHeaders();
        this._meterId = arg.getMeterId();
        this._meterName = arg.getMeterName();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Meter) {
            this._barrier = ((Meter)arg).isBarrier();
            this._containerName = ((Meter)arg).getContainerName();
            this._flags = ((Meter)arg).getFlags();
            this._meterBandHeaders = ((Meter)arg).getMeterBandHeaders();
            this._meterId = ((Meter)arg).getMeterId();
            this._meterName = ((Meter)arg).getMeterName();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter] \nbut was: " + arg);
        }
    }

    public Boolean isBarrier() {
        return this._barrier;
    }

    public String getContainerName() {
        return this._containerName;
    }

    public MeterFlags getFlags() {
        return this._flags;
    }

    public MeterBandHeaders getMeterBandHeaders() {
        return this._meterBandHeaders;
    }

    public MeterId getMeterId() {
        return this._meterId;
    }

    public String getMeterName() {
        return this._meterName;
    }

    public <E extends Augmentation<MeterConfigStats>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterConfigStatsBuilder setBarrier(Boolean value) {
        this._barrier = value;
        return this;
    }

    public MeterConfigStatsBuilder setContainerName(String value) {
        this._containerName = value;
        return this;
    }

    public MeterConfigStatsBuilder setFlags(MeterFlags value) {
        this._flags = value;
        return this;
    }

    public MeterConfigStatsBuilder setMeterBandHeaders(MeterBandHeaders value) {
        this._meterBandHeaders = value;
        return this;
    }

    public MeterConfigStatsBuilder setMeterId(MeterId value) {
        this._meterId = value;
        return this;
    }

    public MeterConfigStatsBuilder setMeterName(String value) {
        this._meterName = value;
        return this;
    }

    public MeterConfigStatsBuilder addAugmentation(Class<? extends Augmentation<MeterConfigStats>> augmentationType, Augmentation<MeterConfigStats> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterConfigStats build() {
        return new MeterConfigStatsImpl(this);
    }

    private static final class MeterConfigStatsImpl
    implements MeterConfigStats {
        private final Boolean _barrier;
        private final String _containerName;
        private final MeterFlags _flags;
        private final MeterBandHeaders _meterBandHeaders;
        private final MeterId _meterId;
        private final String _meterName;
        private Map<Class<? extends Augmentation<MeterConfigStats>>, Augmentation<MeterConfigStats>> augmentation = new HashMap<Class<? extends Augmentation<MeterConfigStats>>, Augmentation<MeterConfigStats>>();

        public Class<MeterConfigStats> getImplementedInterface() {
            return MeterConfigStats.class;
        }

        private MeterConfigStatsImpl(MeterConfigStatsBuilder builder) {
            this._barrier = builder.isBarrier();
            this._containerName = builder.getContainerName();
            this._flags = builder.getFlags();
            this._meterBandHeaders = builder.getMeterBandHeaders();
            this._meterId = builder.getMeterId();
            this._meterName = builder.getMeterName();
            this.augmentation.putAll(builder.augmentation);
        }

        public Boolean isBarrier() {
            return this._barrier;
        }

        public String getContainerName() {
            return this._containerName;
        }

        public MeterFlags getFlags() {
            return this._flags;
        }

        public MeterBandHeaders getMeterBandHeaders() {
            return this._meterBandHeaders;
        }

        public MeterId getMeterId() {
            return this._meterId;
        }

        public String getMeterName() {
            return this._meterName;
        }

        public <E extends Augmentation<MeterConfigStats>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._barrier == null ? 0 : this._barrier.hashCode());
            result = 31 * result + (this._containerName == null ? 0 : this._containerName.hashCode());
            result = 31 * result + (this._flags == null ? 0 : this._flags.hashCode());
            result = 31 * result + (this._meterBandHeaders == null ? 0 : this._meterBandHeaders.hashCode());
            result = 31 * result + (this._meterId == null ? 0 : this._meterId.hashCode());
            result = 31 * result + (this._meterName == null ? 0 : this._meterName.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterConfigStatsImpl other = (MeterConfigStatsImpl)obj;
            if (this._barrier == null ? other._barrier != null : !this._barrier.equals(other._barrier)) {
                return false;
            }
            if (this._containerName == null ? other._containerName != null : !this._containerName.equals(other._containerName)) {
                return false;
            }
            if (this._flags == null ? other._flags != null : !this._flags.equals((Object)other._flags)) {
                return false;
            }
            if (this._meterBandHeaders == null ? other._meterBandHeaders != null : !this._meterBandHeaders.equals(other._meterBandHeaders)) {
                return false;
            }
            if (this._meterId == null ? other._meterId != null : !this._meterId.equals((Object)other._meterId)) {
                return false;
            }
            if (this._meterName == null ? other._meterName != null : !this._meterName.equals(other._meterName)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterConfigStats [_barrier=");
            builder.append(this._barrier);
            builder.append(", _containerName=");
            builder.append(this._containerName);
            builder.append(", _flags=");
            builder.append(this._flags);
            builder.append(", _meterBandHeaders=");
            builder.append(this._meterBandHeaders);
            builder.append(", _meterId=");
            builder.append(this._meterId);
            builder.append(", _meterName=");
            builder.append(this._meterName);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

