/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.statistics.rev131111.nodes.node.MeterFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterCapability;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MeterFeaturesBuilder {
    private Short _maxBands;
    private Short _maxColor;
    private Counter32 _maxMeter;
    private List<Class<? extends MeterBand>> _meterBandSupported;
    private List<Class<? extends MeterCapability>> _meterCapabilitiesSupported;
    private Map<Class<? extends Augmentation<MeterFeatures>>, Augmentation<MeterFeatures>> augmentation = new HashMap<Class<? extends Augmentation<MeterFeatures>>, Augmentation<MeterFeatures>>();

    public MeterFeaturesBuilder() {
    }

    public MeterFeaturesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures arg) {
        this._maxBands = arg.getMaxBands();
        this._maxColor = arg.getMaxColor();
        this._maxMeter = arg.getMaxMeter();
        this._meterBandSupported = arg.getMeterBandSupported();
        this._meterCapabilitiesSupported = arg.getMeterCapabilitiesSupported();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures) {
            this._maxBands = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures)arg).getMaxBands();
            this._maxColor = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures)arg).getMaxColor();
            this._maxMeter = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures)arg).getMaxMeter();
            this._meterBandSupported = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures)arg).getMeterBandSupported();
            this._meterCapabilitiesSupported = ((org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures)arg).getMeterCapabilitiesSupported();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterFeatures] \nbut was: " + arg);
        }
    }

    public Short getMaxBands() {
        return this._maxBands;
    }

    public Short getMaxColor() {
        return this._maxColor;
    }

    public Counter32 getMaxMeter() {
        return this._maxMeter;
    }

    public List<Class<? extends MeterBand>> getMeterBandSupported() {
        return this._meterBandSupported;
    }

    public List<Class<? extends MeterCapability>> getMeterCapabilitiesSupported() {
        return this._meterCapabilitiesSupported;
    }

    public <E extends Augmentation<MeterFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public MeterFeaturesBuilder setMaxBands(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxBands = value;
        return this;
    }

    public MeterFeaturesBuilder setMaxColor(Short value) {
        if (value != null) {
            boolean isValidRange = false;
            ArrayList<Range> rangeConstraints = new ArrayList<Range>();
            rangeConstraints.add(Range.closed((Comparable)new Short("0"), (Comparable)new Short("255")));
            for (Range r : rangeConstraints) {
                if (!r.contains((Comparable)value)) continue;
                isValidRange = true;
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, rangeConstraints));
            }
        }
        this._maxColor = value;
        return this;
    }

    public MeterFeaturesBuilder setMaxMeter(Counter32 value) {
        this._maxMeter = value;
        return this;
    }

    public MeterFeaturesBuilder setMeterBandSupported(List<Class<? extends MeterBand>> value) {
        this._meterBandSupported = value;
        return this;
    }

    public MeterFeaturesBuilder setMeterCapabilitiesSupported(List<Class<? extends MeterCapability>> value) {
        this._meterCapabilitiesSupported = value;
        return this;
    }

    public MeterFeaturesBuilder addAugmentation(Class<? extends Augmentation<MeterFeatures>> augmentationType, Augmentation<MeterFeatures> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public MeterFeatures build() {
        return new MeterFeaturesImpl(this);
    }

    private static final class MeterFeaturesImpl
    implements MeterFeatures {
        private final Short _maxBands;
        private final Short _maxColor;
        private final Counter32 _maxMeter;
        private final List<Class<? extends MeterBand>> _meterBandSupported;
        private final List<Class<? extends MeterCapability>> _meterCapabilitiesSupported;
        private Map<Class<? extends Augmentation<MeterFeatures>>, Augmentation<MeterFeatures>> augmentation = new HashMap<Class<? extends Augmentation<MeterFeatures>>, Augmentation<MeterFeatures>>();

        public Class<MeterFeatures> getImplementedInterface() {
            return MeterFeatures.class;
        }

        private MeterFeaturesImpl(MeterFeaturesBuilder builder) {
            this._maxBands = builder.getMaxBands();
            this._maxColor = builder.getMaxColor();
            this._maxMeter = builder.getMaxMeter();
            this._meterBandSupported = builder.getMeterBandSupported();
            this._meterCapabilitiesSupported = builder.getMeterCapabilitiesSupported();
            this.augmentation.putAll(builder.augmentation);
        }

        public Short getMaxBands() {
            return this._maxBands;
        }

        public Short getMaxColor() {
            return this._maxColor;
        }

        public Counter32 getMaxMeter() {
            return this._maxMeter;
        }

        public List<Class<? extends MeterBand>> getMeterBandSupported() {
            return this._meterBandSupported;
        }

        public List<Class<? extends MeterCapability>> getMeterCapabilitiesSupported() {
            return this._meterCapabilitiesSupported;
        }

        public <E extends Augmentation<MeterFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._maxBands == null ? 0 : this._maxBands.hashCode());
            result = 31 * result + (this._maxColor == null ? 0 : this._maxColor.hashCode());
            result = 31 * result + (this._maxMeter == null ? 0 : this._maxMeter.hashCode());
            result = 31 * result + (this._meterBandSupported == null ? 0 : this._meterBandSupported.hashCode());
            result = 31 * result + (this._meterCapabilitiesSupported == null ? 0 : this._meterCapabilitiesSupported.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MeterFeaturesImpl other = (MeterFeaturesImpl)obj;
            if (this._maxBands == null ? other._maxBands != null : !this._maxBands.equals(other._maxBands)) {
                return false;
            }
            if (this._maxColor == null ? other._maxColor != null : !this._maxColor.equals(other._maxColor)) {
                return false;
            }
            if (this._maxMeter == null ? other._maxMeter != null : !this._maxMeter.equals((Object)other._maxMeter)) {
                return false;
            }
            if (this._meterBandSupported == null ? other._meterBandSupported != null : !this._meterBandSupported.equals(other._meterBandSupported)) {
                return false;
            }
            if (this._meterCapabilitiesSupported == null ? other._meterCapabilitiesSupported != null : !this._meterCapabilitiesSupported.equals(other._meterCapabilitiesSupported)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MeterFeatures [_maxBands=");
            builder.append(this._maxBands);
            builder.append(", _maxColor=");
            builder.append(this._maxColor);
            builder.append(", _maxMeter=");
            builder.append(this._maxMeter);
            builder.append(", _meterBandSupported=");
            builder.append(this._meterBandSupported);
            builder.append(", _meterCapabilitiesSupported=");
            builder.append(this._meterCapabilitiesSupported);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

