/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.features;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.statistics.rev131111.group.features.GroupFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupCapability;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupType;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class GroupFeaturesBuilder {
    private List<Long> _actions;
    private List<Class<? extends GroupCapability>> _groupCapabilitiesSupported;
    private List<Class<? extends GroupType>> _groupTypesSupported;
    private List<Long> _maxGroups;
    private Map<Class<? extends Augmentation<GroupFeatures>>, Augmentation<GroupFeatures>> augmentation = new HashMap<Class<? extends Augmentation<GroupFeatures>>, Augmentation<GroupFeatures>>();

    public GroupFeaturesBuilder() {
    }

    public GroupFeaturesBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures arg) {
        this._actions = arg.getActions();
        this._groupCapabilitiesSupported = arg.getGroupCapabilitiesSupported();
        this._groupTypesSupported = arg.getGroupTypesSupported();
        this._maxGroups = arg.getMaxGroups();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures) {
            this._actions = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures)arg).getActions();
            this._groupCapabilitiesSupported = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures)arg).getGroupCapabilitiesSupported();
            this._groupTypesSupported = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures)arg).getGroupTypesSupported();
            this._maxGroups = ((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures)arg).getMaxGroups();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupFeatures] \nbut was: " + arg);
        }
    }

    public List<Long> getActions() {
        return this._actions;
    }

    public List<Class<? extends GroupCapability>> getGroupCapabilitiesSupported() {
        return this._groupCapabilitiesSupported;
    }

    public List<Class<? extends GroupType>> getGroupTypesSupported() {
        return this._groupTypesSupported;
    }

    public List<Long> getMaxGroups() {
        return this._maxGroups;
    }

    public <E extends Augmentation<GroupFeatures>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public GroupFeaturesBuilder setActions(List<Long> value) {
        this._actions = value;
        return this;
    }

    public GroupFeaturesBuilder setGroupCapabilitiesSupported(List<Class<? extends GroupCapability>> value) {
        this._groupCapabilitiesSupported = value;
        return this;
    }

    public GroupFeaturesBuilder setGroupTypesSupported(List<Class<? extends GroupType>> value) {
        this._groupTypesSupported = value;
        return this;
    }

    public GroupFeaturesBuilder setMaxGroups(List<Long> value) {
        this._maxGroups = value;
        return this;
    }

    public GroupFeaturesBuilder addAugmentation(Class<? extends Augmentation<GroupFeatures>> augmentationType, Augmentation<GroupFeatures> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public GroupFeatures build() {
        return new GroupFeaturesImpl(this);
    }

    private static final class GroupFeaturesImpl
    implements GroupFeatures {
        private final List<Long> _actions;
        private final List<Class<? extends GroupCapability>> _groupCapabilitiesSupported;
        private final List<Class<? extends GroupType>> _groupTypesSupported;
        private final List<Long> _maxGroups;
        private Map<Class<? extends Augmentation<GroupFeatures>>, Augmentation<GroupFeatures>> augmentation = new HashMap<Class<? extends Augmentation<GroupFeatures>>, Augmentation<GroupFeatures>>();

        public Class<GroupFeatures> getImplementedInterface() {
            return GroupFeatures.class;
        }

        private GroupFeaturesImpl(GroupFeaturesBuilder builder) {
            this._actions = builder.getActions();
            this._groupCapabilitiesSupported = builder.getGroupCapabilitiesSupported();
            this._groupTypesSupported = builder.getGroupTypesSupported();
            this._maxGroups = builder.getMaxGroups();
            this.augmentation.putAll(builder.augmentation);
        }

        public List<Long> getActions() {
            return this._actions;
        }

        public List<Class<? extends GroupCapability>> getGroupCapabilitiesSupported() {
            return this._groupCapabilitiesSupported;
        }

        public List<Class<? extends GroupType>> getGroupTypesSupported() {
            return this._groupTypesSupported;
        }

        public List<Long> getMaxGroups() {
            return this._maxGroups;
        }

        public <E extends Augmentation<GroupFeatures>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._actions == null ? 0 : this._actions.hashCode());
            result = 31 * result + (this._groupCapabilitiesSupported == null ? 0 : this._groupCapabilitiesSupported.hashCode());
            result = 31 * result + (this._groupTypesSupported == null ? 0 : this._groupTypesSupported.hashCode());
            result = 31 * result + (this._maxGroups == null ? 0 : this._maxGroups.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupFeaturesImpl other = (GroupFeaturesImpl)obj;
            if (this._actions == null ? other._actions != null : !this._actions.equals(other._actions)) {
                return false;
            }
            if (this._groupCapabilitiesSupported == null ? other._groupCapabilitiesSupported != null : !this._groupCapabilitiesSupported.equals(other._groupCapabilitiesSupported)) {
                return false;
            }
            if (this._groupTypesSupported == null ? other._groupTypesSupported != null : !this._groupTypesSupported.equals(other._groupTypesSupported)) {
                return false;
            }
            if (this._maxGroups == null ? other._maxGroups != null : !this._maxGroups.equals(other._maxGroups)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("GroupFeatures [_actions=");
            builder.append(this._actions);
            builder.append(", _groupCapabilitiesSupported=");
            builder.append(this._groupCapabilitiesSupported);
            builder.append(", _groupTypesSupported=");
            builder.append(this._groupTypesSupported);
            builder.append(", _maxGroups=");
            builder.append(this._maxGroups);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

