/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.statistics;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter32;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.Counter64;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.table.statistics.rev131215.flow.table.statistics.FlowTableStatistics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.GenericTableStatistics;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowTableStatisticsBuilder {
    private Counter32 _activeFlows;
    private Counter64 _packetsLookedUp;
    private Counter64 _packetsMatched;
    private Map<Class<? extends Augmentation<FlowTableStatistics>>, Augmentation<FlowTableStatistics>> augmentation = new HashMap<Class<? extends Augmentation<FlowTableStatistics>>, Augmentation<FlowTableStatistics>>();

    public FlowTableStatisticsBuilder() {
    }

    public FlowTableStatisticsBuilder(GenericTableStatistics arg) {
        this._activeFlows = arg.getActiveFlows();
        this._packetsLookedUp = arg.getPacketsLookedUp();
        this._packetsMatched = arg.getPacketsMatched();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof GenericTableStatistics) {
            this._activeFlows = ((GenericTableStatistics)arg).getActiveFlows();
            this._packetsLookedUp = ((GenericTableStatistics)arg).getPacketsLookedUp();
            this._packetsMatched = ((GenericTableStatistics)arg).getPacketsMatched();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.model.statistics.types.rev130925.GenericTableStatistics] \nbut was: " + arg);
        }
    }

    public Counter32 getActiveFlows() {
        return this._activeFlows;
    }

    public Counter64 getPacketsLookedUp() {
        return this._packetsLookedUp;
    }

    public Counter64 getPacketsMatched() {
        return this._packetsMatched;
    }

    public <E extends Augmentation<FlowTableStatistics>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowTableStatisticsBuilder setActiveFlows(Counter32 value) {
        this._activeFlows = value;
        return this;
    }

    public FlowTableStatisticsBuilder setPacketsLookedUp(Counter64 value) {
        this._packetsLookedUp = value;
        return this;
    }

    public FlowTableStatisticsBuilder setPacketsMatched(Counter64 value) {
        this._packetsMatched = value;
        return this;
    }

    public FlowTableStatisticsBuilder addAugmentation(Class<? extends Augmentation<FlowTableStatistics>> augmentationType, Augmentation<FlowTableStatistics> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public FlowTableStatistics build() {
        return new FlowTableStatisticsImpl(this);
    }

    private static final class FlowTableStatisticsImpl
    implements FlowTableStatistics {
        private final Counter32 _activeFlows;
        private final Counter64 _packetsLookedUp;
        private final Counter64 _packetsMatched;
        private Map<Class<? extends Augmentation<FlowTableStatistics>>, Augmentation<FlowTableStatistics>> augmentation = new HashMap<Class<? extends Augmentation<FlowTableStatistics>>, Augmentation<FlowTableStatistics>>();

        public Class<FlowTableStatistics> getImplementedInterface() {
            return FlowTableStatistics.class;
        }

        private FlowTableStatisticsImpl(FlowTableStatisticsBuilder builder) {
            this._activeFlows = builder.getActiveFlows();
            this._packetsLookedUp = builder.getPacketsLookedUp();
            this._packetsMatched = builder.getPacketsMatched();
            this.augmentation.putAll(builder.augmentation);
        }

        @Override
        public Counter32 getActiveFlows() {
            return this._activeFlows;
        }

        @Override
        public Counter64 getPacketsLookedUp() {
            return this._packetsLookedUp;
        }

        @Override
        public Counter64 getPacketsMatched() {
            return this._packetsMatched;
        }

        public <E extends Augmentation<FlowTableStatistics>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._activeFlows == null ? 0 : this._activeFlows.hashCode());
            result = 31 * result + (this._packetsLookedUp == null ? 0 : this._packetsLookedUp.hashCode());
            result = 31 * result + (this._packetsMatched == null ? 0 : this._packetsMatched.hashCode());
            result = 31 * result + (this.augmentation == null ? 0 : this.augmentation.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FlowTableStatisticsImpl other = (FlowTableStatisticsImpl)obj;
            if (this._activeFlows == null ? other._activeFlows != null : !this._activeFlows.equals((Object)other._activeFlows)) {
                return false;
            }
            if (this._packetsLookedUp == null ? other._packetsLookedUp != null : !this._packetsLookedUp.equals((Object)other._packetsLookedUp)) {
                return false;
            }
            if (this._packetsMatched == null ? other._packetsMatched != null : !this._packetsMatched.equals((Object)other._packetsMatched)) {
                return false;
            }
            return !(this.augmentation == null ? other.augmentation != null : !this.augmentation.equals(other.augmentation));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("FlowTableStatistics [_activeFlows=");
            builder.append(this._activeFlows);
            builder.append(", _packetsLookedUp=");
            builder.append(this._packetsLookedUp);
            builder.append(", _packetsMatched=");
            builder.append(this._packetsMatched);
            builder.append(", augmentation=");
            builder.append(this.augmentation.values());
            builder.append("]");
            return builder.toString();
        }
    }
}

