/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.northbound.bundlescanner.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.opendaylight.controller.northbound.bundlescanner.IBundleScanService;
import org.opendaylight.controller.northbound.bundlescanner.internal.BundleInfo;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleScanner
implements SynchronousBundleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleScanner.class);
    private static BundleScanner INSTANCE;
    private final Pattern annotationPattern;
    private final Map<Long, BundleInfo> bundleAnnotations = new HashMap<Long, BundleInfo>();

    public static synchronized BundleScanner getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BundleScanner();
        }
        return INSTANCE;
    }

    BundleScanner(Bundle[] bundles) {
        this.annotationPattern = BundleScanner.mergePatterns(IBundleScanService.ANNOTATIONS_TO_SCAN, true);
        this.init(bundles);
    }

    BundleScanner() {
        this(FrameworkUtil.getBundle(BundleScanner.class).getBundleContext().getBundles());
    }

    public List<Class<?>> getAnnotatedClasses(BundleContext context, String[] annotations, Set<String> excludes, boolean includeDependentBundleClasses) {
        BundleInfo info = this.bundleAnnotations.get(context.getBundle().getBundleId());
        if (info == null) {
            return Collections.emptyList();
        }
        Pattern pattern = BundleScanner.mergePatterns(annotations, false);
        List<Class<?>> result = null;
        if (includeDependentBundleClasses) {
            result = info.getAnnotatedClasses(this.bundleAnnotations.values(), pattern, context.getBundle(), excludes);
            Collections.reverse(result);
            this.validate(result);
        } else {
            result = info.getAnnotatedClasses(pattern, excludes);
        }
        LOGGER.debug("Annotated classes detected: {} matching: {}", result, (Object)pattern);
        return result;
    }

    public void bundleChanged(BundleEvent event) {
        Bundle bundle = event.getBundle();
        long id = bundle.getBundleId();
        switch (event.getType()) {
            case 32: {
                this.scan(bundle);
                return;
            }
            case 16: 
            case 64: {
                this.bundleAnnotations.remove(id);
                return;
            }
        }
    }

    private synchronized void init(Bundle[] bundles) {
        for (Bundle bundle : bundles) {
            int state = bundle.getState();
            if (state != 4 && state != 8 && state != 32) continue;
            this.scan(bundle);
        }
    }

    private static String path2class(String path) {
        return path.replace(".class", "").replaceAll("/", ".");
    }

    private static String class2path(String clz) {
        return clz.replaceAll("\\.", "/");
    }

    private static String class2signature(String clz) {
        return "L" + BundleScanner.class2path(clz) + ";";
    }

    private static String signature2class(String sig) {
        if (sig.startsWith("L") && sig.endsWith(";")) {
            sig = sig.substring(1, sig.length() - 1);
        }
        return BundleScanner.path2class(sig);
    }

    private static List<URL> getBundleClasses(Bundle bundle, String[] pkgs) {
        ArrayList<URL> result = new ArrayList<URL>();
        boolean recurse = false;
        if (pkgs == null) {
            recurse = true;
            pkgs = new String[]{"/"};
        }
        for (String pkg : pkgs) {
            Enumeration e = bundle.findEntries(pkg = BundleScanner.class2path(pkg), "*.class", recurse);
            if (e == null) continue;
            while (e.hasMoreElements()) {
                URL url = (URL)e.nextElement();
                result.add(url);
            }
        }
        return result;
    }

    private synchronized void scan(Bundle bundle) {
        AnnotationDetector detector = new AnnotationDetector(this.annotationPattern);
        try {
            for (URL u : BundleScanner.getBundleClasses(bundle, null)) {
                InputStream is = u.openStream();
                new ClassReader(is).accept((ClassVisitor)detector, 0);
                is.close();
            }
        }
        catch (IOException ioe) {
            LOGGER.error("Error scanning classes in bundle: {}", (Object)bundle.getSymbolicName(), (Object)ioe);
        }
        Map<String, Set<String>> classes = detector.getMatchedClasses();
        if (classes != null && classes.size() > 0) {
            BundleInfo info = new BundleInfo(bundle, classes);
            this.bundleAnnotations.put(bundle.getBundleId(), info);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("bindings found in bundle: {}[{}] dependencies {} classes {}", new Object[]{bundle.getSymbolicName(), bundle.getBundleId(), info.getDependencies(this.bundleAnnotations.values()), classes});
            }
        }
    }

    public static List<Class<?>> loadClasses(Collection<String> annotatedClasses, Bundle initBundle, Set<String> excludes) {
        ArrayList result = new ArrayList();
        StringBuilder errors = new StringBuilder();
        for (String name : annotatedClasses) {
            try {
                if (excludes != null && excludes.contains(name)) continue;
                result.add(initBundle.loadClass(name));
            }
            catch (ClassNotFoundException e) {
                errors.append(name).append(", ");
            }
        }
        if (LOGGER.isDebugEnabled() && errors.length() > 0) {
            LOGGER.debug("Bundle: {} could not load classes: {}", (Object)initBundle.getSymbolicName(), (Object)errors.toString());
        }
        return result;
    }

    public static Pattern mergePatterns(String[] patterns, boolean convert2signature) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        StringBuilder regex = new StringBuilder();
        for (String c : patterns) {
            if (c.endsWith("*")) {
                c = c.substring(0, c.length() - 1);
            }
            if (regex.length() > 0) {
                regex.append("|");
            }
            regex.append("^");
            if (convert2signature) {
                regex.append("L").append(c.replaceAll("\\.", "/"));
                continue;
            }
            regex.append(c);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Merged regex: [{}]", (Object)regex.toString());
        }
        return Pattern.compile(regex.toString());
    }

    private void validate(List<Class<?>> classes) {
        if (classes == null || classes.size() == 0) {
            return;
        }
        HashMap<String, String> names = new HashMap<String, String>();
        StringBuilder conflictsMsg = new StringBuilder();
        for (Class<?> c : classes) {
            String other;
            XmlRootElement root = c.getAnnotation(XmlRootElement.class);
            if (root == null) continue;
            String rootName = root.name();
            if ("##default".equals(rootName)) {
                String clsName = c.getSimpleName();
                rootName = Character.toLowerCase(clsName.charAt(0)) + clsName.substring(1);
            }
            if ((other = (String)names.get(rootName)) != null && !other.equals(c.getName())) {
                conflictsMsg.append(System.lineSeparator()).append("[").append(rootName).append(":").append(c.getName()).append(",").append(other).append("]");
                continue;
            }
            names.put(rootName, c.getName());
        }
        if (conflictsMsg.length() > 0) {
            LOGGER.warn("JAXB type conflicts detected : {}", (Object)conflictsMsg.toString());
        }
    }

    private static class AnnotationDetector
    extends ClassVisitor {
        private final Map<String, Set<String>> matchedClasses = new HashMap<String, Set<String>>();
        private final Pattern annotationsPattern;
        private Set<String> annotations;
        private String className;
        private boolean accessible;
        private boolean matchedAnnotation;

        public AnnotationDetector(Pattern pattern) {
            super(262144);
            this.annotationsPattern = pattern;
        }

        public Map<String, Set<String>> getMatchedClasses() {
            return new HashMap<String, Set<String>>(this.matchedClasses);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.accessible = (access & 1) == 1;
            this.matchedAnnotation = false;
            this.annotations = new HashSet<String>();
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.annotations.add(BundleScanner.signature2class(desc));
            if (!this.matchedAnnotation) {
                this.matchedAnnotation = this.annotationsPattern == null || this.annotationsPattern.matcher(desc).find();
            }
            return null;
        }

        public void visitEnd() {
            if (this.matchedAnnotation && this.accessible) {
                this.className = BundleScanner.path2class(this.className);
                this.matchedClasses.put(this.className, new HashSet<String>(this.annotations));
            }
        }
    }
}

