/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.northbound.bundlescanner.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.opendaylight.controller.northbound.bundlescanner.internal.BundleScanner;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BundleInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleInfo.class);
    private final Bundle bundle;
    private final Map<String, Set<String>> annotatedClasses;
    private final Set<String> exportPkgs;
    private final Set<String> importPkgs;

    public BundleInfo(Bundle bundle, Map<String, Set<String>> classes) {
        this.bundle = bundle;
        this.annotatedClasses = classes;
        Dictionary dict = bundle.getHeaders();
        this.importPkgs = BundleInfo.parsePackages((String)dict.get("Import-Package"));
        this.exportPkgs = BundleInfo.parsePackages((String)dict.get("Export-Package"));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("{name:").append(this.bundle.getSymbolicName()).append(" id:").append(this.getId()).append(" annotated-classes:").append(this.annotatedClasses).append(" imports:").append(this.importPkgs).append(" exports:").append(this.exportPkgs).append("}");
        return sb.toString();
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long getId() {
        return this.bundle.getBundleId();
    }

    public List<Class<?>> getAnnotatedClasses(Pattern pattern, Set<String> excludes) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.annotatedClasses.entrySet()) {
            if (!this.matches(pattern, entry.getValue())) continue;
            result.add(entry.getKey());
        }
        return BundleScanner.loadClasses(result, this.bundle, excludes);
    }

    private boolean matches(Pattern pattern, Set<String> values) {
        if (pattern == null) {
            return true;
        }
        for (String s : values) {
            if (!pattern.matcher(s).find()) continue;
            return true;
        }
        return false;
    }

    public List<Class<?>> getAnnotatedClasses(Collection<BundleInfo> allbundles, Pattern pattern, Bundle initBundle, Set<String> excludes) {
        List<Class<?>> classes = this.getAnnotatedClasses(pattern, excludes);
        BundleInfo.processAnnotatedClassesInternal(this, allbundles, pattern, new HashSet<BundleInfo>(), classes, initBundle, excludes);
        return classes;
    }

    private List<String> getExportedAnnotatedClasses(Pattern pattern) {
        ArrayList<String> classes = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.annotatedClasses.entrySet()) {
            String cls = entry.getKey();
            int idx = cls.lastIndexOf(".");
            String pkg = idx == -1 ? "" : cls.substring(0, idx);
            if (!this.exportPkgs.contains(pkg) || !this.matches(pattern, entry.getValue())) continue;
            classes.add(cls);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found in bundle:{} exported classes:[{}]", (Object)this.getBundle().getSymbolicName(), classes);
        }
        return classes;
    }

    private static void processAnnotatedClassesInternal(BundleInfo target, Collection<BundleInfo> bundlesToScan, Pattern pattern, Collection<BundleInfo> visited, List<Class<?>> classes, Bundle initBundle, Set<String> excludes) {
        for (BundleInfo other : bundlesToScan) {
            if (other.getId() == target.getId() || !target.isDependantOn(other) || visited.contains(other)) continue;
            classes.addAll(BundleScanner.loadClasses(other.getExportedAnnotatedClasses(pattern), initBundle, excludes));
            visited.add(other);
            BundleInfo.processAnnotatedClassesInternal(other, bundlesToScan, pattern, visited, classes, initBundle, excludes);
        }
    }

    private boolean isDependantOn(BundleInfo other) {
        for (String pkg : this.importPkgs) {
            if (!other.exportPkgs.contains(pkg)) continue;
            return true;
        }
        return false;
    }

    public List<BundleInfo> getDependencies(Collection<BundleInfo> bundles) {
        ArrayList<BundleInfo> result = new ArrayList<BundleInfo>();
        for (BundleInfo bundle : bundles) {
            if (!this.isDependantOn(bundle)) continue;
            result.add(bundle);
        }
        return result;
    }

    private static Set<String> parsePackages(String packageString) {
        if (packageString == null) {
            return Collections.emptySet();
        }
        String[] packages = packageString.split(",");
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < packages.length; ++i) {
            String[] nameAndAttrs = packages[i].split(";");
            String packageName = nameAndAttrs[0].trim();
            result.add(packageName);
        }
        return result;
    }
}

