/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.statistics.northbound;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ResourceNotFoundException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.statistics.northbound.AllFlowStatistics;
import org.opendaylight.controller.statistics.northbound.AllPortStatistics;
import org.opendaylight.controller.statistics.northbound.AllTableStatistics;
import org.opendaylight.controller.statistics.northbound.FlowStatistics;
import org.opendaylight.controller.statistics.northbound.PortStatistics;
import org.opendaylight.controller.statistics.northbound.TableStatistics;
import org.opendaylight.controller.statisticsmanager.IStatisticsManager;
import org.opendaylight.controller.switchmanager.ISwitchManager;

@Path(value="/")
public class StatisticsNorthbound {
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private IStatisticsManager getStatisticsService(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new ServiceUnavailableException("Container " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        boolean found = false;
        List containerNames = containerManager.getContainerNames();
        for (String cName : containerNames) {
            if (!cName.trim().equalsIgnoreCase(containerName.trim())) continue;
            found = true;
        }
        if (!found) {
            throw new ResourceNotFoundException(containerName + " " + RestMessages.NOCONTAINER.toString());
        }
        IStatisticsManager statsManager = (IStatisticsManager)ServiceHelper.getInstance(IStatisticsManager.class, (String)containerName, (Object)this);
        if (statsManager == null) {
            throw new ServiceUnavailableException("Statistics " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        return statsManager;
    }

    @Path(value="/{containerName}/flow")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=AllFlowStatistics.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public AllFlowStatistics getFlowStatistics(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        IStatisticsManager statisticsManager = this.getStatisticsService(containerName);
        if (statisticsManager == null) {
            throw new ServiceUnavailableException("Statistics " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ArrayList<FlowStatistics> statistics = new ArrayList<FlowStatistics>();
        for (Node node : switchManager.getNodes()) {
            ArrayList<FlowOnNode> flowStats = new ArrayList<FlowOnNode>();
            List flows = statisticsManager.getFlows(node);
            for (FlowOnNode flowOnSwitch : flows) {
                flowStats.add(flowOnSwitch);
            }
            FlowStatistics stat = new FlowStatistics(node, flowStats);
            statistics.add(stat);
        }
        return new AllFlowStatistics(statistics);
    }

    @Path(value="/{containerName}/flow/node/{nodeType}/{nodeId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=FlowStatistics.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public FlowStatistics getFlowStatistics(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IStatisticsManager statisticsManager = this.getStatisticsService(containerName);
        if (statisticsManager == null) {
            throw new ServiceUnavailableException("Statistics " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        return new FlowStatistics(node, statisticsManager.getFlows(node));
    }

    @Path(value="/{containerName}/port")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=AllPortStatistics.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public AllPortStatistics getPortStatistics(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        IStatisticsManager statisticsManager = this.getStatisticsService(containerName);
        if (statisticsManager == null) {
            throw new ServiceUnavailableException("Statistics " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ArrayList<PortStatistics> statistics = new ArrayList<PortStatistics>();
        for (Node node : switchManager.getNodes()) {
            List stat = statisticsManager.getNodeConnectorStatistics(node);
            PortStatistics portStat = new PortStatistics(node, stat);
            statistics.add(portStat);
        }
        return new AllPortStatistics(statistics);
    }

    @Path(value="/{containerName}/port/node/{nodeType}/{nodeId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=PortStatistics.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public PortStatistics getPortStatistics(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IStatisticsManager statisticsManager = this.getStatisticsService(containerName);
        if (statisticsManager == null) {
            throw new ServiceUnavailableException("Statistics " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        return new PortStatistics(node, statisticsManager.getNodeConnectorStatistics(node));
    }

    @Path(value="/{containerName}/table")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=AllTableStatistics.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public AllTableStatistics getTableStatistics(@PathParam(value="containerName") String containerName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IStatisticsManager statisticsManager = this.getStatisticsService(containerName);
        if (statisticsManager == null) {
            throw new ServiceUnavailableException("Statistics manager" + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ArrayList<TableStatistics> statistics = new ArrayList<TableStatistics>();
        for (Node node : switchManager.getNodes()) {
            List stat = statisticsManager.getNodeTableStatistics(node);
            TableStatistics tableStat = new TableStatistics(node, stat);
            statistics.add(tableStat);
        }
        return new AllTableStatistics(statistics);
    }

    @Path(value="/{containerName}/table/node/{nodeType}/{nodeId}")
    @GET
    @Produces(value={"application/json", "application/xml"})
    @TypeHint(value=TableStatistics.class)
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=404, condition="The containerName is not found"), @ResponseCode(code=503, condition="One or more of Controller Services are unavailable")})
    public TableStatistics getTableStatistics(@PathParam(value="containerName") String containerName, @PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)containerName, (Privilege)Privilege.READ, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation on container " + containerName);
        }
        this.handleDefaultDisabled(containerName);
        IStatisticsManager statisticsManager = this.getStatisticsService(containerName);
        if (statisticsManager == null) {
            throw new ServiceUnavailableException("Statistics " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            throw new ServiceUnavailableException("Switch manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = this.handleNodeAvailability(containerName, nodeType, nodeId);
        return new TableStatistics(node, statisticsManager.getNodeTableStatistics(node));
    }

    private void handleDefaultDisabled(String containerName) {
        IContainerManager containerManager = (IContainerManager)ServiceHelper.getGlobalInstance(IContainerManager.class, (Object)this);
        if (containerManager == null) {
            throw new InternalServerErrorException(RestMessages.INTERNALERROR.toString());
        }
        if (containerName.equals(GlobalConstants.DEFAULT.toString()) && containerManager.hasNonDefaultContainer()) {
            throw new ResourceConflictException(RestMessages.DEFAULTDISABLED.toString());
        }
    }

    private Node handleNodeAvailability(String containerName, String nodeType, String nodeId) {
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        if (node == null) {
            throw new ResourceNotFoundException(nodeId + " : " + RestMessages.NONODE.toString());
        }
        ISwitchManager sm = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (sm == null) {
            throw new ServiceUnavailableException("Switch Manager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!sm.getNodes().contains(node)) {
            throw new ResourceNotFoundException(node.toString() + " : " + RestMessages.NONODE.toString());
        }
        return node;
    }
}

