/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.Controller;
import org.opendaylight.controller.sal.action.Drop;
import org.opendaylight.controller.sal.action.Flood;
import org.opendaylight.controller.sal.action.FloodAll;
import org.opendaylight.controller.sal.action.HwPath;
import org.opendaylight.controller.sal.action.Loopback;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.action.PopVlan;
import org.opendaylight.controller.sal.action.PushVlan;
import org.opendaylight.controller.sal.action.SetDlDst;
import org.opendaylight.controller.sal.action.SetDlSrc;
import org.opendaylight.controller.sal.action.SetDlType;
import org.opendaylight.controller.sal.action.SetNwDst;
import org.opendaylight.controller.sal.action.SetNwSrc;
import org.opendaylight.controller.sal.action.SetNwTos;
import org.opendaylight.controller.sal.action.SetTpDst;
import org.opendaylight.controller.sal.action.SetTpSrc;
import org.opendaylight.controller.sal.action.SetVlanCfi;
import org.opendaylight.controller.sal.action.SetVlanId;
import org.opendaylight.controller.sal.action.SetVlanPcp;
import org.opendaylight.controller.sal.action.SwPath;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.NodeTable;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.reader.FlowOnNode;
import org.opendaylight.controller.sal.reader.IPluginInReadService;
import org.opendaylight.controller.sal.reader.NodeConnectorStatistics;
import org.opendaylight.controller.sal.reader.NodeDescription;
import org.opendaylight.controller.sal.reader.NodeTableStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadService
implements IPluginInReadService {
    private static final Logger logger = LoggerFactory.getLogger(ReadService.class);

    void init() {
    }

    void destroy() {
    }

    void start() {
    }

    void stop() {
    }

    public FlowOnNode readFlow(Node node, Flow flow, boolean cached) {
        FlowOnNode fn1 = new FlowOnNode(flow);
        fn1.setByteCount(100L);
        fn1.setDurationNanoseconds(400);
        fn1.setDurationSeconds(40);
        fn1.setTableId((byte)1);
        fn1.setPacketCount(200L);
        return fn1;
    }

    public List<FlowOnNode> readAllFlow(Node node, boolean cached) {
        ArrayList<FlowOnNode> list = new ArrayList<FlowOnNode>();
        ArrayList<Object> actionList = new ArrayList<Object>();
        actionList.add(new Drop());
        actionList.add(new Loopback());
        actionList.add(new Flood());
        actionList.add(new FloodAll());
        actionList.add(new Controller());
        actionList.add(new SwPath());
        actionList.add(new HwPath());
        try {
            actionList.add(new Output(new NodeConnector("STUB", (Object)51966, node)));
        }
        catch (ConstructionException e) {
            // empty catch block
        }
        byte[] dst = new byte[]{1, 2, 3, 4, 5};
        byte[] src = new byte[]{5, 4, 3, 2, 1};
        actionList.add(new SetDlSrc(src));
        actionList.add(new SetDlDst(dst));
        actionList.add(new SetDlType(10));
        actionList.add(new SetVlanId(2));
        actionList.add(new SetVlanPcp(3));
        actionList.add(new SetVlanCfi(1));
        actionList.add(new PopVlan());
        actionList.add(new PushVlan(33024, 1, 1, 1234));
        try {
            actionList.add(new SetNwSrc(InetAddress.getByName("2.2.2.2")));
            actionList.add(new SetNwDst(InetAddress.getByName("1.1.1.1")));
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        actionList.add(new SetNwTos(16));
        actionList.add(new SetTpSrc(4201));
        actionList.add(new SetTpDst(8080));
        short priority = 3500;
        for (Action action : actionList) {
            Flow flow = new Flow();
            Match match = new Match();
            try {
                match.setField(MatchType.NW_DST, (Object)InetAddress.getByName("1.1.1.1"));
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            flow.setMatch(match);
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.add(action);
            flow.setActions(actions);
            short s = priority;
            priority = (short)(priority + 1);
            flow.setPriority(s);
            flow.setIdleTimeout((short)1000);
            flow.setHardTimeout((short)2000);
            flow.setId(12345L);
            FlowOnNode fn1 = new FlowOnNode(flow);
            fn1.setByteCount(100L);
            fn1.setDurationNanoseconds(400);
            fn1.setDurationSeconds(40);
            fn1.setTableId((byte)1);
            fn1.setPacketCount(200L);
            list.add(fn1);
        }
        return list;
    }

    public NodeDescription readDescription(Node node, boolean cached) {
        NodeDescription desc = new NodeDescription();
        desc.setDescription("This is a sample node description");
        desc.setHardware("stub hardware");
        desc.setSoftware("stub software");
        desc.setSerialNumber("123");
        desc.setManufacturer("opendaylight");
        return desc;
    }

    public NodeConnectorStatistics readNodeConnector(NodeConnector connector, boolean cached) {
        NodeConnectorStatistics stats = new NodeConnectorStatistics();
        stats.setNodeConnector(connector);
        stats.setCollisionCount(4L);
        stats.setReceiveByteCount(1000L);
        stats.setReceiveCRCErrorCount(1L);
        stats.setReceiveDropCount(2L);
        stats.setReceiveErrorCount(3L);
        stats.setReceiveFrameErrorCount(5L);
        stats.setReceiveOverRunErrorCount(6L);
        stats.setReceivePacketCount(250L);
        stats.setTransmitByteCount(5000L);
        stats.setTransmitDropCount(50L);
        stats.setTransmitErrorCount(10L);
        stats.setTransmitPacketCount(500L);
        return stats;
    }

    public List<NodeConnectorStatistics> readAllNodeConnector(Node node, boolean cached) {
        NodeConnectorStatistics stats = new NodeConnectorStatistics();
        try {
            NodeConnector nc = new NodeConnector("STUB", (Object)51966, node);
            stats.setNodeConnector(nc);
        }
        catch (ConstructionException e) {
            // empty catch block
        }
        stats.setCollisionCount(4L);
        stats.setReceiveByteCount(1000L);
        stats.setReceiveCRCErrorCount(1L);
        stats.setReceiveDropCount(2L);
        stats.setReceiveErrorCount(3L);
        stats.setReceiveFrameErrorCount(5L);
        stats.setReceiveOverRunErrorCount(6L);
        stats.setReceivePacketCount(250L);
        stats.setTransmitByteCount(5000L);
        stats.setTransmitDropCount(50L);
        stats.setTransmitErrorCount(10L);
        stats.setTransmitPacketCount(500L);
        ArrayList<NodeConnectorStatistics> result = new ArrayList<NodeConnectorStatistics>();
        result.add(stats);
        return result;
    }

    public long getTransmitRate(NodeConnector connector) {
        return 100L;
    }

    public NodeTableStatistics readNodeTable(NodeTable table, boolean b) {
        NodeTableStatistics stats = new NodeTableStatistics();
        stats.setNodeTable(table);
        stats.setActiveCount(4);
        stats.setLookupCount(4L);
        stats.setMatchedCount(4L);
        return stats;
    }

    public List<NodeTableStatistics> readAllNodeTable(Node node, boolean cached) {
        NodeTableStatistics stats = new NodeTableStatistics();
        try {
            NodeTable nt = new NodeTable(NodeTable.NodeTableIDType.OPENFLOW, (Object)Byte.valueOf("10"), node);
            stats.setNodeTable(nt);
        }
        catch (ConstructionException e) {
            // empty catch block
        }
        stats.setActiveCount(4);
        stats.setLookupCount(4L);
        stats.setMatchedCount(4L);
        ArrayList<NodeTableStatistics> result = new ArrayList<NodeTableStatistics>();
        result.add(stats);
        return result;
    }
}

