/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import com.google.common.collect.Maps;
import java.io.PrintStream;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.collections.MapUtils;
import org.opendaylight.ovsdb.lib.database.DatabaseSchema;
import org.opendaylight.ovsdb.lib.table.internal.Table;

public class NodeDB {
    private DatabaseSchema schema;
    ConcurrentMap<String, ConcurrentMap<String, Table<?>>> cache = Maps.newConcurrentMap();

    public DatabaseSchema getSchema() {
        return this.schema;
    }

    public void setSchema(DatabaseSchema schema) {
        this.schema = schema;
    }

    public ConcurrentMap<String, ConcurrentMap<String, Table<?>>> getTableCache() {
        return this.cache;
    }

    public ConcurrentMap<String, Table<?>> getTableCache(String tableName) {
        return (ConcurrentMap)this.cache.get(tableName);
    }

    private void setTableCache(String tableName, ConcurrentMap<String, Table<?>> tableCache) {
        this.cache.put(tableName, tableCache);
    }

    public Table<?> getRow(String tableName, String uuid) {
        ConcurrentMap<String, Table<?>> tableCache = this.getTableCache(tableName);
        if (tableCache != null) {
            return (Table)tableCache.get(uuid);
        }
        return null;
    }

    public void updateRow(String tableName, String uuid, Table<?> row) {
        ConcurrentMap tableCache = this.getTableCache(tableName);
        if (tableCache == null) {
            tableCache = Maps.newConcurrentMap();
            this.setTableCache(tableName, tableCache);
        }
        tableCache.put(uuid, row);
    }

    public void removeRow(String tableName, String uuid) {
        ConcurrentMap<String, Table<?>> tableCache = this.getTableCache(tableName);
        if (tableCache != null) {
            tableCache.remove(uuid);
        }
    }

    public void printTableCache() {
        MapUtils.debugPrint((PrintStream)System.out, null, this.schema.getTables());
        MapUtils.debugPrint((PrintStream)System.out, null, this.cache);
    }
}

