/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.inventory.IPluginInInventoryService;
import org.opendaylight.controller.sal.inventory.IPluginOutInventoryService;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.ovsdb.lib.database.DatabaseSchema;
import org.opendaylight.ovsdb.lib.message.TableUpdate;
import org.opendaylight.ovsdb.lib.message.TableUpdates;
import org.opendaylight.ovsdb.lib.notation.OvsDBSet;
import org.opendaylight.ovsdb.lib.table.Bridge;
import org.opendaylight.ovsdb.lib.table.internal.Table;
import org.opendaylight.ovsdb.plugin.InventoryServiceInternal;
import org.opendaylight.ovsdb.plugin.NodeDB;
import org.opendaylight.ovsdb.plugin.OVSDBInventoryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InventoryService
implements IPluginInInventoryService,
InventoryServiceInternal {
    private static final Logger logger = LoggerFactory.getLogger(InventoryService.class);
    private final Set<IPluginOutInventoryService> pluginOutInventoryServices = new CopyOnWriteArraySet<IPluginOutInventoryService>();
    private ConcurrentMap<Node, Map<String, Property>> nodeProps;
    private ConcurrentMap<NodeConnector, Map<String, Property>> nodeConnectorProps;
    private ConcurrentMap<Node, NodeDB> dbCache = Maps.newConcurrentMap();
    private ScheduledExecutorService executor;

    public void init() {
        this.nodeProps = new ConcurrentHashMap<Node, Map<String, Property>>();
        this.nodeConnectorProps = new ConcurrentHashMap<NodeConnector, Map<String, Property>>();
        Node.NodeIDType.registerIDType((String)"OVS", String.class);
        NodeConnector.NodeConnectorIDType.registerIDType((String)"OVS", String.class, (String)"OVS");
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void destroy() {
    }

    public void start() {
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public void setPluginOutInventoryServices(IPluginOutInventoryService service) {
        this.pluginOutInventoryServices.add(service);
    }

    public void unsetPluginOutInventoryServices(IPluginOutInventoryService service) {
        this.pluginOutInventoryServices.remove(service);
    }

    public ConcurrentMap<Node, Map<String, Property>> getNodeProps() {
        return this.nodeProps;
    }

    public ConcurrentMap<NodeConnector, Map<String, Property>> getNodeConnectorProps(Boolean refresh) {
        return this.nodeConnectorProps;
    }

    @Override
    public ConcurrentMap<String, ConcurrentMap<String, Table<?>>> getCache(Node n) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db == null) {
            return null;
        }
        return db.getTableCache();
    }

    @Override
    public ConcurrentMap<String, Table<?>> getTableCache(Node n, String tableName) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db == null) {
            return null;
        }
        return db.getTableCache(tableName);
    }

    @Override
    public Table<?> getRow(Node n, String tableName, String uuid) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db == null) {
            return null;
        }
        return db.getRow(tableName, uuid);
    }

    @Override
    public void updateRow(Node n, String tableName, String uuid, Table<?> row) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db == null) {
            db = new NodeDB();
            this.dbCache.put(n, db);
        }
        db.updateRow(tableName, uuid, row);
    }

    @Override
    public void removeRow(Node n, String tableName, String uuid) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db != null) {
            db.removeRow(tableName, uuid);
        }
    }

    @Override
    public void processTableUpdates(Node n, TableUpdates tableUpdates) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db == null) {
            db = new NodeDB();
            this.dbCache.put(n, db);
        }
        OVSDBInventoryListener inventoryListener = (OVSDBInventoryListener)ServiceHelper.getGlobalInstance(OVSDBInventoryListener.class, (Object)this);
        Set<Table.Name> available = tableUpdates.availableUpdates();
        for (Table.Name name : available) {
            TableUpdate tableUpdate = tableUpdates.getUpdate(name);
            Collection rows = tableUpdate.getRows();
            for (TableUpdate.Row row : rows) {
                String uuid = row.getId();
                Table newRow = (Table)row.getNew();
                Table oldRow = (Table)row.getOld();
                if (newRow != null) {
                    db.updateRow(name.getName(), uuid, newRow);
                    if (name.getName().equalsIgnoreCase("bridge")) {
                        logger.debug("Received Bridge Table udpate for node {}", (Object)n);
                    }
                    if (oldRow == null && inventoryListener != null) {
                        inventoryListener.rowAdded(n, name.getName(), uuid, newRow);
                        continue;
                    }
                    if (inventoryListener == null) continue;
                    inventoryListener.rowUpdated(n, name.getName(), uuid, oldRow, newRow);
                    continue;
                }
                if (oldRow == null) continue;
                if (inventoryListener != null) {
                    inventoryListener.rowRemoved(n, name.getName(), uuid, oldRow);
                }
                db.removeRow(name.getName(), uuid);
            }
        }
    }

    private void updateOFBridgeName(Node node, final Bridge bridge) {
        Runnable updateNameRunnable = new Runnable(){

            @Override
            public void run() {
                OvsDBSet<String> dpids = bridge.getDatapath_id();
                String bridgeName = bridge.getName();
                if (dpids == null || bridgeName == null) {
                    return;
                }
                Iterator i$ = dpids.iterator();
                while (i$.hasNext()) {
                    String dpid = (String)i$.next();
                    Long dpidLong = HexEncode.stringToLong((String)dpid);
                    try {
                        Node ofNode = new Node(Node.NodeIDType.OPENFLOW, (Object)dpidLong);
                        Description descProp = new Description(bridgeName);
                        HashSet<Description> props = new HashSet<Description>();
                        props.add(descProp);
                        IPluginOutInventoryService salInventoryService = (IPluginOutInventoryService)ServiceHelper.getInstance(IPluginOutInventoryService.class, (String)"default", (Object)this);
                        if (salInventoryService != null) {
                            logger.debug("Updating Bridge Name {} on OF node {}", (Object)bridgeName, (Object)ofNode);
                            salInventoryService.updateNode(ofNode, UpdateType.CHANGED, props);
                            continue;
                        }
                        logger.error("Error accessing SAL Inventory plugin");
                    }
                    catch (ConstructionException e) {
                        logger.error("Failed to construct node for " + dpid, (Throwable)e);
                    }
                }
            }
        };
        this.executor.execute(updateNameRunnable);
        this.executor.schedule(updateNameRunnable, 30L, TimeUnit.SECONDS);
    }

    @Override
    public void printCache(Node n) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db != null) {
            db.printTableCache();
        }
    }

    @Override
    public void addNode(Node node, Set<Property> props) {
        this.addNodeProperty(node, UpdateType.ADDED, props);
    }

    @Override
    public void notifyNodeAdded(Node node) {
        OVSDBInventoryListener inventoryListener = (OVSDBInventoryListener)ServiceHelper.getGlobalInstance(OVSDBInventoryListener.class, (Object)this);
        if (inventoryListener != null) {
            inventoryListener.nodeAdded(node);
        }
    }

    @Override
    public void addNodeProperty(Node node, UpdateType type, Set<Property> props) {
        HashMap<String, Property> nProp = (HashMap<String, Property>)this.nodeProps.get(node);
        if (nProp == null) {
            nProp = new HashMap<String, Property>();
        }
        for (Property prop : props) {
            nProp.put(prop.getName(), prop);
        }
        this.nodeProps.put(node, nProp);
        for (IPluginOutInventoryService service : this.pluginOutInventoryServices) {
            service.updateNode(node, type, props);
        }
    }

    @Override
    public DatabaseSchema getDatabaseSchema(Node n) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db != null) {
            return db.getSchema();
        }
        return null;
    }

    @Override
    public void updateDatabaseSchema(Node n, DatabaseSchema schema) {
        NodeDB db = (NodeDB)this.dbCache.get(n);
        if (db == null) {
            db = new NodeDB();
            this.dbCache.put(n, db);
        }
        db.setSchema(schema);
    }

    @Override
    public void removeNode(Node node) {
        OVSDBInventoryListener inventoryListener = (OVSDBInventoryListener)ServiceHelper.getGlobalInstance(OVSDBInventoryListener.class, (Object)this);
        if (inventoryListener != null) {
            inventoryListener.nodeRemoved(node);
        }
        for (IPluginOutInventoryService service : this.pluginOutInventoryServices) {
            service.updateNode(node, UpdateType.REMOVED, null);
        }
        this.nodeProps.remove(node);
        this.dbCache.remove(node);
    }

    public Set<Node> getConfiguredNotConnectedNodes() {
        return Collections.emptySet();
    }
}

