/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.connection.IPluginInConnectionService;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.ovsdb.lib.database.DatabaseSchema;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpcDecoder;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpcEndpoint;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpcServiceBinderHandler;
import org.opendaylight.ovsdb.lib.message.MonitorRequestBuilder;
import org.opendaylight.ovsdb.lib.message.OvsdbRPC;
import org.opendaylight.ovsdb.lib.message.TableUpdates;
import org.opendaylight.ovsdb.lib.message.UpdateNotification;
import org.opendaylight.ovsdb.lib.notation.OvsDBSet;
import org.opendaylight.ovsdb.lib.table.Bridge;
import org.opendaylight.ovsdb.lib.table.Controller;
import org.opendaylight.ovsdb.lib.table.Open_vSwitch;
import org.opendaylight.ovsdb.lib.table.internal.Table;
import org.opendaylight.ovsdb.lib.table.internal.Tables;
import org.opendaylight.ovsdb.plugin.ChannelConnectionHandler;
import org.opendaylight.ovsdb.plugin.Connection;
import org.opendaylight.ovsdb.plugin.IConnectionServiceInternal;
import org.opendaylight.ovsdb.plugin.IPAddressProperty;
import org.opendaylight.ovsdb.plugin.InventoryServiceInternal;
import org.opendaylight.ovsdb.plugin.L4PortProperty;
import org.opendaylight.ovsdb.plugin.OVSDBConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService
implements IPluginInConnectionService,
IConnectionServiceInternal,
OvsdbRPC.Callback {
    protected static final Logger logger = LoggerFactory.getLogger(ConnectionService.class);
    private static final String OVSDB_LISTENPORT = "ovsdb.listenPort";
    private static final String OVSDB_AUTOCONFIGURECONTROLLER = "ovsdb.autoconfigurecontroller";
    protected static final String OPENFLOW_10 = "1.0";
    protected static final String OPENFLOW_13 = "1.3";
    private static final Integer defaultOvsdbPort;
    private static final boolean defaultAutoConfigureController = true;
    private static Integer ovsdbListenPort;
    private static boolean autoConfigureController;
    private ConcurrentMap<String, Connection> ovsdbConnections;
    private List<ChannelHandler> handlers = null;
    private InventoryServiceInternal inventoryServiceInternal;
    private Channel serverListenChannel = null;
    private IClusterGlobalServices clusterServices;

    public InventoryServiceInternal getInventoryServiceInternal() {
        return this.inventoryServiceInternal;
    }

    public void setInventoryServiceInternal(InventoryServiceInternal inventoryServiceInternal) {
        this.inventoryServiceInternal = inventoryServiceInternal;
    }

    public void unsetInventoryServiceInternal(InventoryServiceInternal inventoryServiceInternal) {
        if (this.inventoryServiceInternal == inventoryServiceInternal) {
            this.inventoryServiceInternal = null;
        }
    }

    public void init() {
        this.ovsdbConnections = new ConcurrentHashMap<String, Connection>();
        int listenPort = defaultOvsdbPort;
        String portString = System.getProperty(OVSDB_LISTENPORT);
        if (portString != null) {
            listenPort = Integer.decode(portString);
        }
        ovsdbListenPort = listenPort;
        if (System.getProperty(OVSDB_AUTOCONFIGURECONTROLLER) != null) {
            autoConfigureController = Boolean.getBoolean(OVSDB_AUTOCONFIGURECONTROLLER);
        }
    }

    void destroy() {
    }

    void start() {
        this.startOvsdbManager();
    }

    void stopping() {
        for (Connection connection : this.ovsdbConnections.values()) {
            connection.disconnect();
        }
        this.serverListenChannel.disconnect();
    }

    public Status disconnect(Node node) {
        String identifier = (String)node.getID();
        Connection connection = (Connection)this.ovsdbConnections.get(identifier);
        if (connection != null) {
            this.ovsdbConnections.remove(identifier);
            return connection.disconnect();
        }
        return new Status(StatusCode.NOTFOUND);
    }

    @Override
    public Node connect(String identifier, Map<ConnectionConstants, String> params) {
        Integer port;
        InetAddress address;
        try {
            address = InetAddress.getByName(params.get(ConnectionConstants.ADDRESS));
        }
        catch (Exception e) {
            logger.error("Unable to resolve " + params.get(ConnectionConstants.ADDRESS), (Throwable)e);
            return null;
        }
        try {
            port = Integer.parseInt(params.get(ConnectionConstants.PORT));
            if (port == 0) {
                port = defaultOvsdbPort;
            }
        }
        catch (Exception e) {
            port = defaultOvsdbPort;
        }
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)new NioEventLoopGroup());
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(65535, 65535, 65535));
            bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    if (ConnectionService.this.handlers == null) {
                        channel.pipeline().addLast(new ChannelHandler[]{new JsonRpcDecoder(100000), new StringEncoder(CharsetUtil.UTF_8)});
                    } else {
                        for (ChannelHandler handler : ConnectionService.this.handlers) {
                            channel.pipeline().addLast(new ChannelHandler[]{handler});
                        }
                    }
                }
            });
            ChannelFuture future = bootstrap.connect(address, port.intValue()).sync();
            Channel channel = future.channel();
            return this.handleNewConnection(identifier, channel, this);
        }
        catch (InterruptedException e) {
            logger.error("Thread was interrupted during connect", (Throwable)e);
        }
        catch (ExecutionException e) {
            logger.error("ExecutionException in handleNewConnection for identifier " + identifier, (Throwable)e);
        }
        return null;
    }

    public List<ChannelHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<ChannelHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public Connection getConnection(Node node) {
        String identifier = (String)node.getID();
        return (Connection)this.ovsdbConnections.get(identifier);
    }

    @Override
    public List<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Connection connection : this.ovsdbConnections.values()) {
            nodes.add(connection.getNode());
        }
        return nodes;
    }

    public void notifyClusterViewChanged() {
    }

    public void notifyNodeDisconnectFromMaster(Node arg0) {
    }

    private Node handleNewConnection(String identifier, Channel channel, ConnectionService instance) throws InterruptedException, ExecutionException {
        Connection connection = new Connection(identifier, channel);
        Node node = connection.getNode();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        JsonRpcEndpoint factory = new JsonRpcEndpoint(objectMapper, channel);
        JsonRpcServiceBinderHandler binderHandler = new JsonRpcServiceBinderHandler(factory);
        binderHandler.setNode(node);
        channel.pipeline().addLast(new ChannelHandler[]{binderHandler});
        OvsdbRPC ovsdb = factory.getClient(node, OvsdbRPC.class);
        connection.setRpc(ovsdb);
        ovsdb.registerCallback(instance);
        this.ovsdbConnections.put(identifier, connection);
        ChannelConnectionHandler handler = new ChannelConnectionHandler();
        handler.setNode(node);
        handler.setConnectionService(this);
        ChannelFuture closeFuture = channel.closeFuture();
        closeFuture.addListener((GenericFutureListener)handler);
        new Thread(){
            Connection connection;
            String identifier;

            @Override
            public void run() {
                try {
                    ConnectionService.this.initializeInventoryForNewNode(this.connection);
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.error("Failed to initialize inventory for node with identifier " + this.identifier, (Throwable)e);
                    ConnectionService.this.ovsdbConnections.remove(this.identifier);
                }
            }

            public Thread initializeConnectionParams(String identifier, Connection connection) {
                this.identifier = identifier;
                this.connection = connection;
                return this;
            }
        }.initializeConnectionParams(identifier, connection).start();
        return node;
    }

    public void channelClosed(Node node) throws Exception {
        logger.info("Connection to Node : {} closed", (Object)node);
        this.disconnect(node);
        this.inventoryServiceInternal.removeNode(node);
    }

    private void initializeInventoryForNewNode(Connection connection) throws InterruptedException, ExecutionException {
        Channel channel = connection.getChannel();
        InetAddress address = ((InetSocketAddress)channel.remoteAddress()).getAddress();
        int port = ((InetSocketAddress)channel.remoteAddress()).getPort();
        IPAddressProperty addressProp = new IPAddressProperty(address);
        L4PortProperty l4Port = new L4PortProperty(port);
        HashSet<Property> props = new HashSet<Property>();
        props.add(addressProp);
        props.add(l4Port);
        this.inventoryServiceInternal.addNode(connection.getNode(), props);
        List<String> dbNames = Arrays.asList(Open_vSwitch.NAME.getName());
        ListenableFuture<DatabaseSchema> dbSchemaF = connection.getRpc().get_schema(dbNames);
        DatabaseSchema databaseSchema = (DatabaseSchema)dbSchemaF.get();
        this.inventoryServiceInternal.updateDatabaseSchema(connection.getNode(), databaseSchema);
        MonitorRequestBuilder monitorReq = new MonitorRequestBuilder();
        for (Table table : Tables.getTables()) {
            if (databaseSchema.getTables().keySet().contains(table.getTableName().getName())) {
                monitorReq.monitor(table);
                continue;
            }
            logger.debug("We know about table {} but it is not in the schema of {}", (Object)table.getTableName().getName(), (Object)connection.getNode().getNodeIDString());
        }
        ListenableFuture<TableUpdates> monResponse = connection.getRpc().monitor(monitorReq);
        TableUpdates updates = (TableUpdates)monResponse.get();
        if (updates.getError() != null) {
            logger.error("Error configuring monitor, error : {}, details : {}", updates.getError(), updates.getDetails());
            throw new RuntimeException("Failed to setup a monitor in OVSDB");
        }
        UpdateNotification monitor = new UpdateNotification();
        monitor.setUpdate(updates);
        this.update(connection.getNode(), monitor);
        if (autoConfigureController) {
            this.updateOFControllers(connection.getNode());
        }
        this.inventoryServiceInternal.notifyNodeAdded(connection.getNode());
    }

    private void startOvsdbManager() {
        new Thread(){

            @Override
            public void run() {
                ConnectionService.this.ovsdbManager();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ovsdbManager() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) throws Exception {
                    logger.debug("New Passive channel created : " + channel.toString());
                    InetAddress address = channel.remoteAddress().getAddress();
                    int port = channel.remoteAddress().getPort();
                    String identifier = address.getHostAddress() + ":" + port;
                    channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new JsonRpcDecoder(100000), new StringEncoder(CharsetUtil.UTF_8)});
                    Node node = ConnectionService.this.handleNewConnection(identifier, (Channel)channel, ConnectionService.this);
                    logger.debug("Connected Node : " + node.toString());
                }
            });
            b.option(ChannelOption.TCP_NODELAY, (Object)true);
            b.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(65535, 65535, 65535));
            ChannelFuture f = b.bind(ovsdbListenPort.intValue()).sync();
            this.serverListenChannel = f.channel();
            this.serverListenChannel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted", (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public void setClusterServices(IClusterGlobalServices i) {
        this.clusterServices = i;
    }

    public void unsetClusterServices(IClusterGlobalServices i) {
        if (this.clusterServices == i) {
            this.clusterServices = null;
        }
    }

    private List<InetAddress> getControllerIPAddresses(Connection connection) {
        List<InetAddress> controllers = null;
        InetAddress controllerIP = null;
        controllers = new ArrayList<InetAddress>();
        String addressString = System.getProperty("ovsdb.controller.address");
        if (addressString != null) {
            try {
                controllerIP = InetAddress.getByName(addressString);
                if (controllerIP != null) {
                    controllers.add(controllerIP);
                    return controllers;
                }
            }
            catch (UnknownHostException e) {
                logger.error("Host {} is invalid", (Object)addressString);
            }
        }
        if (this.clusterServices != null && (controllers = this.clusterServices.getClusteredControllers()) != null && controllers.size() > 0) {
            if (controllers.size() == 1) {
                InetAddress controller = controllers.get(0);
                if (!controller.equals(InetAddress.getLoopbackAddress())) {
                    return controllers;
                }
            } else {
                return controllers;
            }
        }
        if ((addressString = System.getProperty("of.address")) != null) {
            try {
                controllerIP = InetAddress.getByName(addressString);
                if (controllerIP != null) {
                    controllers.add(controllerIP);
                    return controllers;
                }
            }
            catch (UnknownHostException e) {
                logger.error("Host {} is invalid", (Object)addressString);
            }
        }
        try {
            controllerIP = ((InetSocketAddress)connection.getChannel().localAddress()).getAddress();
            controllers.add(controllerIP);
            return controllers;
        }
        catch (Exception e) {
            logger.debug("Invalid connection provided to getControllerIPAddresses", (Throwable)e);
            return controllers;
        }
    }

    private short getControllerOFPort() {
        Short defaultOpenFlowPort;
        Short openFlowPort = defaultOpenFlowPort = Short.valueOf((short)6633);
        String portString = System.getProperty("of.listenPort");
        if (portString != null) {
            try {
                openFlowPort = (short)Short.decode(portString);
            }
            catch (NumberFormatException e) {
                logger.warn("Invalid port:{}, use default({})", (Object)portString, (Object)openFlowPort);
            }
        }
        return openFlowPort;
    }

    @Override
    public Boolean setOFController(Node node, String bridgeUUID) throws InterruptedException, ExecutionException {
        String ofVersion;
        Connection connection = this.getConnection(node);
        if (connection == null) {
            return false;
        }
        OVSDBConfigService ovsdbTable = (OVSDBConfigService)ServiceHelper.getGlobalInstance(OVSDBConfigService.class, (Object)this);
        OvsDBSet<String> protocols = new OvsDBSet<String>();
        switch (ofVersion = System.getProperty("ovsdb.of.version", OPENFLOW_10)) {
            case "1.3": {
                protocols.add("OpenFlow13");
                break;
            }
            default: {
                protocols.add("OpenFlow10");
            }
        }
        Bridge bridge = new Bridge();
        bridge.setProtocols(protocols);
        Status status = ovsdbTable.updateRow(node, Bridge.NAME.getName(), null, bridgeUUID, bridge);
        logger.debug("Bridge {} updated to {} with Status {}", new Object[]{bridgeUUID, protocols.toArray()[0], status});
        List<InetAddress> ofControllerAddrs = this.getControllerIPAddresses(connection);
        short ofControllerPort = this.getControllerOFPort();
        for (InetAddress ofControllerAddress : ofControllerAddrs) {
            String newController = "tcp:" + ofControllerAddress.getHostAddress() + ":" + ofControllerPort;
            Controller controllerRow = new Controller();
            controllerRow.setTarget(newController);
            if (ovsdbTable == null) continue;
            ovsdbTable.insertRow(node, Controller.NAME.getName(), bridgeUUID, controllerRow);
        }
        return true;
    }

    private void updateOFControllers(Node node) {
        ConcurrentMap<String, Table<?>> bridges = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
        if (bridges == null) {
            return;
        }
        for (String bridgeUUID : bridges.keySet()) {
            try {
                this.setOFController(node, bridgeUUID);
            }
            catch (Exception e) {
                logger.error("Failed updateOFControllers", (Throwable)e);
            }
        }
    }

    @Override
    public void update(Node node, UpdateNotification updateNotification) {
        if (updateNotification == null) {
            return;
        }
        this.inventoryServiceInternal.processTableUpdates(node, updateNotification.getUpdate());
    }

    @Override
    public void locked(Node node, List<String> ids) {
    }

    @Override
    public void stolen(Node node, List<String> ids) {
    }

    static {
        ovsdbListenPort = defaultOvsdbPort = Integer.valueOf(6640);
        autoConfigureController = true;
    }
}

