/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import io.netty.channel.Channel;
import org.opendaylight.controller.sal.core.ConstructionException;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.ovsdb.lib.message.OvsdbRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private Node node;
    private String identifier;
    private Channel channel;
    private OvsdbRPC rpc;
    private Long idCounter;
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);

    public Long getIdCounter() {
        return this.idCounter;
    }

    public void setIdCounter(Long idCounter) {
        this.idCounter = idCounter;
    }

    public Connection(String identifier, Channel channel) {
        this.identifier = identifier;
        this.channel = channel;
        this.idCounter = 0L;
        try {
            this.node = new Node("OVS", (Object)identifier);
        }
        catch (ConstructionException e) {
            logger.error("Error creating OVS node with identifier " + identifier, (Throwable)e);
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public OvsdbRPC getRpc() {
        return this.rpc;
    }

    public void setRpc(OvsdbRPC rpc) {
        this.rpc = rpc;
    }

    public void sendMessage(String message) {
        this.channel.writeAndFlush((Object)message);
        Connection connection = this;
        Long l = connection.idCounter;
        Long l2 = connection.idCounter = Long.valueOf(connection.idCounter + 1L);
    }

    public Status disconnect() {
        this.channel.close();
        return new Status(StatusCode.SUCCESS);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Connection other = (Connection)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }
}

