/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.ConfigConstants;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.IPluginInBridgeDomainConfigService;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.ovsdb.lib.database.OVSInstance;
import org.opendaylight.ovsdb.lib.database.OvsdbType;
import org.opendaylight.ovsdb.lib.message.TransactBuilder;
import org.opendaylight.ovsdb.lib.message.operations.DeleteOperation;
import org.opendaylight.ovsdb.lib.message.operations.InsertOperation;
import org.opendaylight.ovsdb.lib.message.operations.MutateOperation;
import org.opendaylight.ovsdb.lib.message.operations.Operation;
import org.opendaylight.ovsdb.lib.message.operations.OperationResult;
import org.opendaylight.ovsdb.lib.message.operations.UpdateOperation;
import org.opendaylight.ovsdb.lib.notation.Condition;
import org.opendaylight.ovsdb.lib.notation.Function;
import org.opendaylight.ovsdb.lib.notation.Mutation;
import org.opendaylight.ovsdb.lib.notation.Mutator;
import org.opendaylight.ovsdb.lib.notation.OvsDBMap;
import org.opendaylight.ovsdb.lib.notation.OvsDBSet;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.table.Bridge;
import org.opendaylight.ovsdb.lib.table.Controller;
import org.opendaylight.ovsdb.lib.table.Interface;
import org.opendaylight.ovsdb.lib.table.Manager;
import org.opendaylight.ovsdb.lib.table.Mirror;
import org.opendaylight.ovsdb.lib.table.NetFlow;
import org.opendaylight.ovsdb.lib.table.Open_vSwitch;
import org.opendaylight.ovsdb.lib.table.Port;
import org.opendaylight.ovsdb.lib.table.Qos;
import org.opendaylight.ovsdb.lib.table.Queue;
import org.opendaylight.ovsdb.lib.table.SFlow;
import org.opendaylight.ovsdb.lib.table.SSL;
import org.opendaylight.ovsdb.lib.table.internal.Table;
import org.opendaylight.ovsdb.plugin.Connection;
import org.opendaylight.ovsdb.plugin.IConnectionServiceInternal;
import org.opendaylight.ovsdb.plugin.InventoryServiceInternal;
import org.opendaylight.ovsdb.plugin.OVSDBConfigService;
import org.opendaylight.ovsdb.plugin.OvsdbMessage;
import org.opendaylight.ovsdb.plugin.StatusWithUuid;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements IPluginInBridgeDomainConfigService,
OVSDBConfigService,
CommandProvider {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationService.class);
    IConnectionServiceInternal connectionService;
    InventoryServiceInternal inventoryServiceInternal;
    boolean forceConnect = false;

    void init() {
    }

    void destroy() {
    }

    void start() {
        this.registerWithOSGIConsole();
    }

    private void registerWithOSGIConsole() {
        BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        bundleContext.registerService(CommandProvider.class.getName(), (Object)this, null);
    }

    void stop() {
    }

    public void setConnectionServiceInternal(IConnectionServiceInternal connectionService) {
        this.connectionService = connectionService;
    }

    public void unsetConnectionServiceInternal(IConnectionServiceInternal connectionService) {
        if (this.connectionService == connectionService) {
            this.connectionService = null;
        }
    }

    public void setInventoryServiceInternal(InventoryServiceInternal inventoryServiceInternal) {
        this.inventoryServiceInternal = inventoryServiceInternal;
    }

    public void unsetInventoryServiceInternal(InventoryServiceInternal inventoryServiceInternal) {
        if (this.inventoryServiceInternal == inventoryServiceInternal) {
            this.inventoryServiceInternal = null;
        }
    }

    private Connection getConnection(Node node) {
        Connection connection = this.connectionService.getConnection(node);
        if (connection == null || !connection.getChannel().isActive()) {
            return null;
        }
        return connection;
    }

    public Status createBridgeDomain(Node node, String bridgeIdentifier, Map<ConfigConstants, Object> configs) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, Open_vSwitch.NAME.getName());
            String newBridge = "new_bridge";
            String newInterface = "new_interface";
            String newPort = "new_port";
            String newSwitch = "new_switch";
            Operation addSwitchRequest = null;
            if (ovsTable != null) {
                String ovsTableUUID = (String)ovsTable.keySet().toArray()[0];
                UUID bridgeUuidPair = new UUID(newBridge);
                Mutation bm = new Mutation("bridges", Mutator.INSERT, bridgeUuidPair);
                ArrayList<Mutation> mutations = new ArrayList<Mutation>();
                mutations.add(bm);
                UUID uuid = new UUID(ovsTableUUID);
                Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
                ArrayList<Condition> where = new ArrayList<Condition>();
                where.add(condition);
                addSwitchRequest = new MutateOperation(Open_vSwitch.NAME.getName(), where, mutations);
            } else {
                Open_vSwitch ovsTableRow = new Open_vSwitch();
                OvsDBSet<UUID> bridges = new OvsDBSet<UUID>();
                UUID bridgeUuidPair = new UUID(newBridge);
                bridges.add(bridgeUuidPair);
                ovsTableRow.setBridges(bridges);
                addSwitchRequest = new InsertOperation(Open_vSwitch.NAME.getName(), newSwitch, ovsTableRow);
            }
            Bridge bridgeRow = new Bridge();
            bridgeRow.setName(bridgeIdentifier);
            OvsDBSet<UUID> ports = new OvsDBSet<UUID>();
            UUID port = new UUID(newPort);
            ports.add(port);
            bridgeRow.setPorts(ports);
            InsertOperation addBridgeRequest = new InsertOperation(Bridge.NAME.getName(), newBridge, bridgeRow);
            Port portRow = new Port();
            portRow.setName(bridgeIdentifier);
            OvsDBSet<UUID> interfaces = new OvsDBSet<UUID>();
            UUID interfaceid = new UUID(newInterface);
            interfaces.add(interfaceid);
            portRow.setInterfaces(interfaces);
            InsertOperation addPortRequest = new InsertOperation(Port.NAME.getName(), newPort, portRow);
            Interface interfaceRow = new Interface();
            interfaceRow.setName(bridgeIdentifier);
            interfaceRow.setType("internal");
            InsertOperation addIntfRequest = new InsertOperation(Interface.NAME.getName(), newInterface, interfaceRow);
            String ovsTableUUID = (String)ovsTable.keySet().toArray()[0];
            Mutation bm = new Mutation("next_cfg", Mutator.SUM, 1);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(bm);
            UUID uuid = new UUID(ovsTableUUID);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            MutateOperation updateCfgVerRequest = new MutateOperation(Open_vSwitch.NAME.getName(), where, mutations);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addSwitchRequest, addIntfRequest, addPortRequest, addBridgeRequest, updateCfgVerRequest)));
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            Status status = new Status(StatusCode.SUCCESS);
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (tr.get(i) == null || ((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error creating Bridge : {}\n Error : {}\n Details : {}", new Object[]{bridgeIdentifier, result.getError(), result.getDetails()});
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (status.isSuccess()) {
                this.setBridgeOFController(node, bridgeIdentifier);
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in createBridgeDomain(): ", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    public Status addPort(Node node, String bridgeIdentifier, String portIdentifier, Map<ConfigConstants, Object> configs) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            if (connection != null) {
                ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
                String newBridge = "new_bridge";
                String newInterface = "new_interface";
                String newPort = "new_port";
                if (brTable != null) {
                    MutateOperation addBrMutRequest = null;
                    String brUuid = null;
                    for (String uuid : brTable.keySet()) {
                        Bridge bridge = (Bridge)brTable.get(uuid);
                        if (!bridge.getName().contains(bridgeIdentifier)) continue;
                        brUuid = uuid;
                    }
                    UUID brUuidPair = new UUID(newPort);
                    Mutation bm = new Mutation("ports", Mutator.INSERT, brUuidPair);
                    ArrayList<Mutation> mutations = new ArrayList<Mutation>();
                    mutations.add(bm);
                    UUID uuid = new UUID(brUuid);
                    Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
                    ArrayList<Condition> where = new ArrayList<Condition>();
                    where.add(condition);
                    addBrMutRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
                    OvsDBMap options = null;
                    String type = null;
                    OvsDBSet<BigInteger> tags = null;
                    if (configs != null) {
                        type = (String)configs.get(ConfigConstants.TYPE);
                        Map customConfigs = (Map)configs.get(ConfigConstants.CUSTOM);
                        if (customConfigs != null) {
                            options = new OvsDBMap();
                            for (String customConfig : customConfigs.keySet()) {
                                options.put(customConfig, customConfigs.get(customConfig));
                            }
                        }
                    }
                    Interface interfaceRow = new Interface();
                    interfaceRow.setName(portIdentifier);
                    if (type != null) {
                        if (type.equalsIgnoreCase(OvsdbType.PortType.TUNNEL.name())) {
                            interfaceRow.setType((String)configs.get(ConfigConstants.TUNNEL_TYPE));
                            if (options == null) {
                                options = new OvsDBMap();
                            }
                            options.put("remote_ip", (String)configs.get(ConfigConstants.DEST_IP));
                        } else if (type.equalsIgnoreCase(OvsdbType.PortType.VLAN.name())) {
                            tags = new OvsDBSet<BigInteger>();
                            tags.add(BigInteger.valueOf(Integer.parseInt((String)configs.get(ConfigConstants.VLAN))));
                        } else if (type.equalsIgnoreCase(OvsdbType.PortType.PATCH.name())) {
                            interfaceRow.setType(type.toLowerCase());
                        }
                    }
                    if (options != null) {
                        interfaceRow.setOptions(options);
                    }
                    InsertOperation addIntfRequest = new InsertOperation(Interface.NAME.getName(), newInterface, interfaceRow);
                    Port portRow = new Port();
                    portRow.setName(portIdentifier);
                    if (tags != null) {
                        portRow.setTag(tags);
                    }
                    OvsDBSet<UUID> interfaces = new OvsDBSet<UUID>();
                    UUID interfaceid = new UUID(newInterface);
                    interfaces.add(interfaceid);
                    portRow.setInterfaces(interfaces);
                    InsertOperation addPortRequest = new InsertOperation(Port.NAME.getName(), newPort, portRow);
                    TransactBuilder transaction = new TransactBuilder();
                    transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addBrMutRequest, addPortRequest, addIntfRequest)));
                    ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
                    List tr = (List)transResponse.get();
                    List<Operation> requests = transaction.getRequests();
                    Status status = new Status(StatusCode.SUCCESS);
                    for (int i = 0; i < tr.size(); ++i) {
                        if (i < requests.size()) {
                            requests.get(i).setResult((OperationResult)tr.get(i));
                        }
                        if (((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                        OperationResult result = (OperationResult)tr.get(i);
                        status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
                    }
                    if (tr.size() > requests.size()) {
                        OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                        logger.error("Error creating Bridge : {}\n Error : {}\n Details : {}", new Object[]{bridgeIdentifier, result.getError(), result.getDetails()});
                        status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
                    }
                    return status;
                }
                return new Status(StatusCode.INTERNALERROR);
            }
        }
        catch (Exception e) {
            logger.error("Error in addPort()", (Throwable)e);
        }
        return new Status(StatusCode.INTERNALERROR);
    }

    public boolean setManager(Node node, String managerip) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return false;
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return false;
            }
            if (connection != null) {
                String newmanager = "new_manager";
                OVSInstance instance = OVSInstance.monitorOVS(connection);
                LinkedHashMap<String, Object> ovsoutter = new LinkedHashMap<String, Object>();
                LinkedHashMap ovsinner = new LinkedHashMap();
                ArrayList ovsalist1 = new ArrayList();
                ArrayList<Object> ovsalist2 = new ArrayList<Object>();
                ArrayList<String> ovsalist3 = new ArrayList<String>();
                ArrayList<String> ovsalist4 = new ArrayList<String>();
                ovsoutter.put("where", ovsalist1);
                ovsalist1.add(ovsalist2);
                ovsalist2.add("_uuid");
                ovsalist2.add("==");
                ovsalist2.add(ovsalist3);
                ovsalist3.add("uuid");
                ovsalist3.add(instance.getUuid());
                ovsoutter.put("op", "update");
                ovsoutter.put("table", "Open_vSwitch");
                ovsoutter.put("row", ovsinner);
                ovsinner.put("manager_options", ovsalist4);
                ovsalist4.add("named-uuid");
                ovsalist4.add(newmanager);
                LinkedHashMap<String, Object> mgroutside = new LinkedHashMap<String, Object>();
                LinkedHashMap<String, String> mgrinside = new LinkedHashMap<String, String>();
                mgroutside.put("uuid-name", newmanager);
                mgroutside.put("op", "insert");
                mgroutside.put("table", "Manager");
                mgroutside.put("row", mgrinside);
                mgrinside.put("target", managerip);
                Object[] params = new Object[]{"Open_vSwitch", ovsoutter, mgroutside};
                OvsdbMessage msg = new OvsdbMessage("transact", params);
            }
        }
        catch (Exception e) {
            logger.error("Error in setManager(): ", (Throwable)e);
        }
        return true;
    }

    public Status addBridgeDomainConfig(Node node, String bridgeIdentfier, Map<ConfigConstants, Object> configs) {
        String mgmt = (String)configs.get(ConfigConstants.MGMT);
        if (mgmt != null && this.setManager(node, mgmt)) {
            return new Status(StatusCode.SUCCESS);
        }
        return new Status(StatusCode.BADREQUEST);
    }

    public Status addPortConfig(Node node, String bridgeIdentifier, String portIdentifier, Map<ConfigConstants, Object> configs) {
        return null;
    }

    public Status deletePort(Node node, String bridgeIdentifier, String portIdentifier) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            ConcurrentMap<String, Table<?>> portTable = this.inventoryServiceInternal.getTableCache(node, Port.NAME.getName());
            MutateOperation delPortRequest = null;
            String brUuid = null;
            String portUuid = null;
            if (brTable != null) {
                for (String uuid : brTable.keySet()) {
                    Bridge bridge = (Bridge)brTable.get(uuid);
                    if (!bridge.getName().contains(bridgeIdentifier)) continue;
                    brUuid = uuid;
                }
            }
            if (portTable != null) {
                for (String uuid : portTable.keySet()) {
                    Port port = (Port)portTable.get(uuid);
                    if (!port.getName().contains(portIdentifier)) continue;
                    portUuid = uuid;
                }
            }
            UUID portUuidPair = new UUID(portUuid);
            Mutation bm = new Mutation("ports", Mutator.DELETE, portUuidPair);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(bm);
            UUID uuid = new UUID(brUuid);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            delPortRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(delPortRequest)));
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            Status status = new Status(StatusCode.SUCCESS);
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error creating Bridge : {}\n Error : {}\n Details : {}", new Object[]{bridgeIdentifier, result.getError(), result.getDetails()});
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in deletePort()", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    public Node getBridgeDomainNode(Node node, String bridgeIdentifier) {
        return null;
    }

    public Map<ConfigConstants, Object> getPortConfigs(Node node, String bridgeIdentifier, String portIdentifier) {
        return null;
    }

    public Status removeBridgeDomainConfig(Node node, String bridgeIdentifier, Map<ConfigConstants, Object> configs) {
        return null;
    }

    public Status removePortConfig(Node node, String bridgeIdentifier, String portIdentifier, Map<ConfigConstants, Object> configs) {
        return null;
    }

    public Status deleteBridgeDomain(Node node, String bridgeIdentifier) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, Open_vSwitch.NAME.getName());
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            MutateOperation delBrRequest = null;
            String ovsUuid = null;
            String brUuid = null;
            if (brTable != null) {
                for (String uuid : brTable.keySet()) {
                    Bridge bridge = (Bridge)brTable.get(uuid);
                    if (!bridge.getName().contains(bridgeIdentifier)) continue;
                    brUuid = uuid;
                }
            }
            if (ovsTable != null) {
                ovsUuid = (String)ovsTable.keySet().toArray()[0];
            }
            UUID bridgeUuidPair = new UUID(brUuid);
            Mutation bm = new Mutation("bridges", Mutator.DELETE, bridgeUuidPair);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(bm);
            UUID uuid = new UUID(ovsUuid);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            delBrRequest = new MutateOperation(Open_vSwitch.NAME.getName(), where, mutations);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(delBrRequest)));
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            Status status = new Status(StatusCode.SUCCESS);
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (tr.get(i) == null || ((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error deleting Bridge : {}\n Error : {}\n Details : {}", new Object[]{bridgeIdentifier, result.getError(), result.getDetails()});
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in deleteBridgeDomain(): ", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    public Map<ConfigConstants, Object> getBridgeDomainConfigs(Node node, String bridgeIdentifier) {
        return null;
    }

    public List<String> getBridgeDomains(Node node) {
        ArrayList<String> brlist = new ArrayList<String>();
        ConcurrentMap<String, Table<?>> brTableCache = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
        if (brTableCache != null) {
            for (String uuid : brTableCache.keySet()) {
                Bridge bridge = (Bridge)brTableCache.get(uuid);
                brlist.add(bridge.getName());
            }
        }
        return brlist;
    }

    public NodeConnector getNodeConnector(Node arg0, String arg1, String arg2) {
        return null;
    }

    Boolean setBridgeOFController(Node node, String bridgeIdentifier) {
        if (this.connectionService == null) {
            logger.error("Couldn't refer to the ConnectionService");
            return false;
        }
        try {
            ConcurrentMap<String, Table<?>> brTableCache = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            for (String uuid : brTableCache.keySet()) {
                Bridge bridge = (Bridge)brTableCache.get(uuid);
                if (!bridge.getName().contains(bridgeIdentifier)) continue;
                return this.connectionService.setOFController(node, uuid);
            }
        }
        catch (Exception e) {
            logger.error("Error in setBridgeOFController()", (Throwable)e);
        }
        return false;
    }

    @Override
    public StatusWithUuid insertRow(Node node, String tableName, String parent_uuid, Table<?> row) {
        logger.debug("tableName : {}, parent_uuid : {} Row : {}", new Object[]{tableName, parent_uuid, row.toString()});
        StatusWithUuid statusWithUUID = null;
        if (row.getTableName().getName().equalsIgnoreCase("Bridge")) {
            statusWithUUID = this.insertBridgeRow(node, parent_uuid, (Bridge)row);
        } else {
            if (row.getTableName().getName().equalsIgnoreCase("Capability")) {
                return new StatusWithUuid(StatusCode.NOTIMPLEMENTED, "Insert operation for this Table is not implemented yet.");
            }
            if (row.getTableName().getName().equalsIgnoreCase("Controller")) {
                statusWithUUID = this.insertControllerRow(node, parent_uuid, (Controller)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("Interface")) {
                statusWithUUID = this.insertInterfaceRow(node, parent_uuid, (Interface)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("Manager")) {
                statusWithUUID = this.insertManagerRow(node, parent_uuid, (Manager)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("Mirror")) {
                statusWithUUID = this.insertMirrorRow(node, parent_uuid, (Mirror)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("NetFlow")) {
                statusWithUUID = this.insertNetFlowRow(node, parent_uuid, (NetFlow)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("Open_vSwitch")) {
                statusWithUUID = this.insertOpen_vSwitchRow(node, (Open_vSwitch)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("Port")) {
                statusWithUUID = this.insertPortRow(node, parent_uuid, (Port)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("QoS")) {
                statusWithUUID = this.insertQosRow(node, parent_uuid, (Qos)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("Queue")) {
                statusWithUUID = this.insertQueueRow(node, parent_uuid, (Queue)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("sFlow")) {
                statusWithUUID = this.insertSflowRow(node, parent_uuid, (SFlow)row);
            } else if (row.getTableName().getName().equalsIgnoreCase("SSL")) {
                statusWithUUID = this.insertSSLRow(node, parent_uuid, (SSL)row);
            }
        }
        return statusWithUUID;
    }

    @Override
    public Status updateRow(Node node, String tableName, String parentUUID, String rowUUID, Table<?> row) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, Open_vSwitch.NAME.getName());
            if (ovsTable == null) {
                return new Status(StatusCode.NOTFOUND, "There are no Open_vSwitch instance in the Open_vSwitch table");
            }
            UUID uuid = new UUID(rowUUID);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            UpdateOperation updateRequest = new UpdateOperation(tableName, where, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(updateRequest)));
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            Status status = new Status(StatusCode.SUCCESS);
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (tr.get(i) == null || ((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error Updating Row : {}/{}\n Error : {}\n Details : {}", new Object[]{tableName, row, result.getError(), result.getDetails()});
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (status.isSuccess()) {
                status = new Status(StatusCode.SUCCESS);
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in updateRow(): ", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    @Override
    public Status deleteRow(Node node, String tableName, String uuid) {
        if (tableName.equalsIgnoreCase("Bridge")) {
            return this.deleteBridgeRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Capbility")) {
            return new Status(StatusCode.NOTIMPLEMENTED, "Delete operation for this Table is not implemented yet.");
        }
        if (tableName.equalsIgnoreCase("Controller")) {
            return this.deleteControllerRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Interface")) {
            return this.deleteInterfaceRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Manager")) {
            return this.deleteManagerRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Mirror")) {
            return this.deleteMirrorRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("NetFlow")) {
            return this.deleteNetFlowRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Open_vSwitch")) {
            return this.deleteOpen_vSwitchRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Port")) {
            return this.deletePortRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("QoS")) {
            return this.deleteQosRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("Queue")) {
            return this.deleteQueueRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("sFlow")) {
            return this.deleteSflowRow(node, uuid);
        }
        if (tableName.equalsIgnoreCase("SSL")) {
            return this.deleteSSLRow(node, uuid);
        }
        return new Status(StatusCode.NOTFOUND, "Table " + tableName + " not supported");
    }

    @Override
    public ConcurrentMap<String, Table<?>> getRows(Node node, String tableName) throws Exception {
        try {
            if (this.inventoryServiceInternal == null) {
                throw new Exception("Inventory Service is Unavailable.");
            }
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, tableName);
            return ovsTable;
        }
        catch (Exception e) {
            throw new Exception("Unable to read table due to " + e.getMessage());
        }
    }

    @Override
    public Table<?> getRow(Node node, String tableName, String uuid) throws Exception {
        try {
            if (this.inventoryServiceInternal == null) {
                throw new Exception("Inventory Service is Unavailable.");
            }
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, tableName);
            if (ovsTable == null) {
                return null;
            }
            return (Table)ovsTable.get(uuid);
        }
        catch (Exception e) {
            throw new Exception("Unable to read table due to " + e.getMessage());
        }
    }

    @Override
    public String getSerializedRows(Node node, String tableName) throws Exception {
        try {
            ConcurrentMap<String, Table<?>> ovsTable = this.getRows(node, tableName);
            if (ovsTable == null) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(ovsTable);
        }
        catch (Exception e) {
            throw new Exception("Unable to read table due to " + e.getMessage());
        }
    }

    @Override
    public String getSerializedRow(Node node, String tableName, String uuid) throws Exception {
        try {
            Table<?> row = this.getRow(node, tableName, uuid);
            if (row == null) {
                return null;
            }
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(row);
        }
        catch (Exception e) {
            throw new Exception("Unable to read table due to " + e.getMessage());
        }
    }

    @Override
    public List<String> getTables(Node node) {
        ConcurrentMap<String, ConcurrentMap<String, Table<?>>> cache = this.inventoryServiceInternal.getCache(node);
        if (cache == null) {
            return null;
        }
        return new ArrayList<String>(cache.keySet());
    }

    private StatusWithUuid insertBridgeRow(Node node, String open_VSwitch_uuid, Bridge bridgeRow) {
        String insertErrorMsg = "bridge";
        String rowName = bridgeRow.getName();
        try {
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, Open_vSwitch.NAME.getName());
            if (ovsTable == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "There are no Open_vSwitch instance in the Open_vSwitch table");
            }
            String newBridge = "new_bridge";
            MutateOperation addSwitchRequest = null;
            String ovsTableUUID = open_VSwitch_uuid;
            if (ovsTableUUID == null) {
                ovsTableUUID = (String)ovsTable.keySet().toArray()[0];
            }
            UUID bridgeUuid = new UUID(newBridge);
            Mutation bm = new Mutation("bridges", Mutator.INSERT, bridgeUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(bm);
            UUID uuid = new UUID(ovsTableUUID);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            addSwitchRequest = new MutateOperation(Open_vSwitch.NAME.getName(), where, mutations);
            InsertOperation addBridgeRequest = new InsertOperation(Bridge.NAME.getName(), newBridge, bridgeRow);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addSwitchRequest, addBridgeRequest)));
            int bridgeInsertIndex = transaction.getRequests().indexOf(addBridgeRequest);
            return this._insertTableRow(node, transaction, bridgeInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertBridgeRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertPortRow(Node node, String bridge_uuid, Port portRow) {
        String insertErrorMsg = "port";
        String rowName = portRow.getName();
        try {
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            if (brTable == null || brTable.get(bridge_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "Bridge with UUID " + bridge_uuid + " Not found");
            }
            String newPort = "new_port";
            UUID portUUID = new UUID(newPort);
            Mutation bm = new Mutation("ports", Mutator.INSERT, portUUID);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(bm);
            UUID uuid = new UUID(bridge_uuid);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            MutateOperation addBrMutRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
            String newInterface = "new_interface";
            Interface interfaceRow = new Interface();
            interfaceRow.setName(portRow.getName());
            InsertOperation addIntfRequest = new InsertOperation(Interface.NAME.getName(), newInterface, interfaceRow);
            OvsDBSet<UUID> interfaces = new OvsDBSet<UUID>();
            UUID interfaceid = new UUID(newInterface);
            interfaces.add(interfaceid);
            portRow.setInterfaces(interfaces);
            InsertOperation addPortRequest = new InsertOperation(Port.NAME.getName(), newPort, portRow);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addBrMutRequest, addPortRequest, addIntfRequest)));
            int portInsertIndex = transaction.getRequests().indexOf(addPortRequest);
            return this._insertTableRow(node, transaction, portInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertPortRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertInterfaceRow(Node node, String port_uuid, Interface interfaceRow) {
        String insertErrorMsg = "interface";
        String rowName = interfaceRow.getName();
        try {
            ConcurrentMap<String, Table<?>> portTable = this.inventoryServiceInternal.getTableCache(node, Port.NAME.getName());
            if (portTable == null || portTable.get(port_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "Port with UUID " + port_uuid + " Not found");
            }
            String newInterface = "new_interface";
            UUID interfaceUUID = new UUID(newInterface);
            Mutation portTableMutation = new Mutation("interfaces", Mutator.INSERT, interfaceUUID);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(portTableMutation);
            UUID uuid = new UUID(port_uuid);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            MutateOperation addPortMutationRequest = new MutateOperation(Port.NAME.getName(), where, mutations);
            InsertOperation addIntfRequest = new InsertOperation(Interface.NAME.getName(), newInterface, interfaceRow);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addIntfRequest, addPortMutationRequest)));
            int interfaceInsertIndex = transaction.getRequests().indexOf(addIntfRequest);
            return this._insertTableRow(node, transaction, interfaceInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertInterfaceRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertOpen_vSwitchRow(Node node, Open_vSwitch row) {
        return new StatusWithUuid(StatusCode.NOTIMPLEMENTED, "Insert operation for this Table is not implemented yet.");
    }

    private StatusWithUuid insertControllerRow(Node node, String bridge_uuid, Controller row) {
        String insertErrorMsg = "controller";
        String rowName = row.getTableName().toString();
        try {
            StatusWithUuid status;
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            if (brTable == null || brTable.get(bridge_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "Bridge with UUID " + bridge_uuid + " Not found");
            }
            ConcurrentMap<String, Table<?>> controllerCache = this.inventoryServiceInternal.getTableCache(node, Controller.NAME.getName());
            String uuid_name = "new_controller";
            boolean controllerExists = false;
            if (controllerCache != null) {
                for (String uuid : controllerCache.keySet()) {
                    Controller controller = (Controller)controllerCache.get(uuid);
                    if (!controller.getTarget().equals(row.getTarget())) continue;
                    uuid_name = uuid;
                    controllerExists = true;
                    break;
                }
            }
            UUID controllerUUID = new UUID(uuid_name);
            Mutation bm = new Mutation("controller", Mutator.INSERT, controllerUUID);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(bm);
            UUID uuid = new UUID(bridge_uuid);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            MutateOperation addBrMutRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
            InsertOperation addControllerRequest = null;
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperation(addBrMutRequest);
            int portInsertIndex = -1;
            if (!controllerExists) {
                addControllerRequest = new InsertOperation(Controller.NAME.getName(), uuid_name, row);
                transaction.addOperation(addControllerRequest);
                portInsertIndex = transaction.getRequests().indexOf(addControllerRequest);
            }
            if ((status = this._insertTableRow(node, transaction, portInsertIndex, insertErrorMsg, rowName)).isSuccess() && controllerExists) {
                status = new StatusWithUuid(status.getCode(), controllerUUID);
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in insertControllerRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertSSLRow(Node node, String parent_uuid, SSL row) {
        String insertErrorMsg = "SSL";
        String rowName = SSL.NAME.getName();
        try {
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, Open_vSwitch.NAME.getName());
            if (ovsTable == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "There are no Open_vSwitch instance in the Open_vSwitch table");
            }
            String newSSL = "new_SSL";
            MutateOperation addOpen_vSwitchRequest = null;
            String ovsTableUUID = parent_uuid;
            if (ovsTableUUID == null) {
                ovsTableUUID = (String)ovsTable.keySet().toArray()[0];
            }
            UUID sslUuid = new UUID(newSSL);
            Mutation sslMutation = new Mutation("ssl", Mutator.INSERT, sslUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(sslMutation);
            UUID uuid = new UUID(ovsTableUUID);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            addOpen_vSwitchRequest = new MutateOperation(Open_vSwitch.NAME.getName(), where, mutations);
            InsertOperation addSSLRequest = new InsertOperation(SSL.NAME.getName(), newSSL, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addSSLRequest, addOpen_vSwitchRequest)));
            int sslInsertIndex = transaction.getRequests().indexOf(addSSLRequest);
            return this._insertTableRow(node, transaction, sslInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertSSLRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertSflowRow(Node node, String parent_uuid, SFlow row) {
        String insertErrorMsg = "sFlow";
        String rowName = SFlow.NAME.getName();
        try {
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            if (brTable == null || brTable.get(parent_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "Bridge with UUID " + parent_uuid + " Not found");
            }
            if (parent_uuid == null) {
                return new StatusWithUuid(StatusCode.BADREQUEST, "Require parent Bridge UUID.");
            }
            UUID uuid = new UUID(parent_uuid);
            String newSflow = "new_sflow";
            MutateOperation addBridgeRequest = null;
            UUID sflowUuid = new UUID(newSflow);
            Mutation sflowMutation = new Mutation("sflow", Mutator.INSERT, sflowUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(sflowMutation);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            addBridgeRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
            InsertOperation addSflowRequest = new InsertOperation(SFlow.NAME.getName(), newSflow, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addSflowRequest, addBridgeRequest)));
            int sflowInsertIndex = transaction.getRequests().indexOf(addSflowRequest);
            return this._insertTableRow(node, transaction, sflowInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertInterfaceRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertQueueRow(Node node, String parent_uuid, Queue row) {
        String insertErrorMsg = "Queue";
        String rowName = Queue.NAME.getName();
        try {
            ConcurrentMap<String, Table<?>> qosTable = this.inventoryServiceInternal.getTableCache(node, Qos.NAME.getName());
            if (qosTable == null || qosTable.get(parent_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "QoS with UUID " + parent_uuid + " Not found");
            }
            if (parent_uuid == null) {
                return new StatusWithUuid(StatusCode.BADREQUEST, "Require parent QoS UUID.");
            }
            String newQueue = "new_queue";
            InsertOperation addQueueRequest = new InsertOperation(Queue.NAME.getName(), newQueue, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addQueueRequest)));
            int queueInsertIndex = transaction.getRequests().indexOf(addQueueRequest);
            return this._insertTableRow(node, transaction, queueInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertQueueRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertQosRow(Node node, String parent_uuid, Qos row) {
        String insertErrorMsg = "Qos";
        String rowName = Qos.NAME.getName();
        try {
            String newQos = "new_qos";
            if (parent_uuid != null) {
                ConcurrentMap<String, Table<?>> portTable = this.inventoryServiceInternal.getTableCache(node, Port.NAME.getName());
                if (portTable == null || portTable.get(parent_uuid) == null) {
                    return new StatusWithUuid(StatusCode.NOTFOUND, "Port with UUID " + parent_uuid + " Not found");
                }
                UUID qosUuid = new UUID(newQos);
                Mutation qosMutation = new Mutation("qos", Mutator.INSERT, qosUuid);
                ArrayList<Mutation> mutations = new ArrayList<Mutation>();
                mutations.add(qosMutation);
                MutateOperation addPortRequest = null;
                UUID uuid = new UUID(parent_uuid);
                Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
                ArrayList<Condition> where = new ArrayList<Condition>();
                where.add(condition);
                addPortRequest = new MutateOperation(Port.NAME.getName(), where, mutations);
                InsertOperation addQosRequest = new InsertOperation(Qos.NAME.getName(), newQos, row);
                TransactBuilder transaction = new TransactBuilder();
                transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addQosRequest, addPortRequest)));
                int qosInsertIndex = transaction.getRequests().indexOf(addQosRequest);
                return this._insertTableRow(node, transaction, qosInsertIndex, insertErrorMsg, rowName);
            }
            InsertOperation addQosRequest = new InsertOperation(Qos.NAME.getName(), newQos, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addQosRequest)));
            int qosInsertIndex = transaction.getRequests().indexOf(addQosRequest);
            return this._insertTableRow(node, transaction, qosInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertQosRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertNetFlowRow(Node node, String parent_uuid, NetFlow row) {
        String insertErrorMsg = "netFlow";
        String rowName = NetFlow.NAME.getName();
        try {
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            if (brTable == null || brTable.get(parent_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "Bridge with UUID " + parent_uuid + " Not found");
            }
            if (parent_uuid == null) {
                return new StatusWithUuid(StatusCode.BADREQUEST, "Require parent Bridge UUID.");
            }
            UUID uuid = new UUID(parent_uuid);
            String newNetflow = "new_netflow";
            MutateOperation addBridgeRequest = null;
            UUID netFlowUuid = new UUID(newNetflow);
            Mutation netFlowMutation = new Mutation("netflow", Mutator.INSERT, netFlowUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(netFlowMutation);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            addBridgeRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
            InsertOperation addNetflowRequest = new InsertOperation(NetFlow.NAME.getName(), newNetflow, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addNetflowRequest, addBridgeRequest)));
            int netflowInsertIndex = transaction.getRequests().indexOf(addNetflowRequest);
            return this._insertTableRow(node, transaction, netflowInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertNetFlowRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertMirrorRow(Node node, String parent_uuid, Mirror row) {
        String insertErrorMsg = "mirror";
        String rowName = Mirror.NAME.getName();
        try {
            ConcurrentMap<String, Table<?>> brTable = this.inventoryServiceInternal.getTableCache(node, Bridge.NAME.getName());
            if (brTable == null || brTable.get(parent_uuid) == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "Bridge with UUID " + parent_uuid + " Not found");
            }
            if (parent_uuid == null) {
                return new StatusWithUuid(StatusCode.BADREQUEST, "Require parent Bridge UUID.");
            }
            UUID uuid = new UUID(parent_uuid);
            String newMirror = "new_mirror";
            MutateOperation addBridgeRequest = null;
            UUID mirrorUuid = new UUID(newMirror);
            Mutation mirrorMutation = new Mutation("mirrors", Mutator.INSERT, mirrorUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(mirrorMutation);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            addBridgeRequest = new MutateOperation(Bridge.NAME.getName(), where, mutations);
            InsertOperation addMirrorRequest = new InsertOperation(Mirror.NAME.getName(), newMirror, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addBridgeRequest, addMirrorRequest)));
            int mirrorInsertIndex = transaction.getRequests().indexOf(addMirrorRequest);
            return this._insertTableRow(node, transaction, mirrorInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertMirrorRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid insertManagerRow(Node node, String parent_uuid, Manager row) {
        String insertErrorMsg = "manager";
        String rowName = Manager.NAME.getName();
        try {
            ConcurrentMap<String, Table<?>> ovsTable = this.inventoryServiceInternal.getTableCache(node, Open_vSwitch.NAME.getName());
            if (ovsTable == null) {
                return new StatusWithUuid(StatusCode.NOTFOUND, "There are no Open_vSwitch instance in the Open_vSwitch table");
            }
            String newManager = "new_manager";
            MutateOperation addSwitchRequest = null;
            String ovsTableUUID = parent_uuid;
            if (ovsTableUUID == null) {
                ovsTableUUID = (String)ovsTable.keySet().toArray()[0];
            }
            UUID managerUuid = new UUID(newManager);
            Mutation managerMutation = new Mutation("manager_options", Mutator.INSERT, managerUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(managerMutation);
            UUID uuid = new UUID(ovsTableUUID);
            Condition condition = new Condition("_uuid", Function.EQUALS, uuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            addSwitchRequest = new MutateOperation(Open_vSwitch.NAME.getName(), where, mutations);
            InsertOperation addManagerRequest = new InsertOperation(Manager.NAME.getName(), newManager, row);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(addSwitchRequest, addManagerRequest)));
            int managerInsertIndex = transaction.getRequests().indexOf(addManagerRequest);
            return this._insertTableRow(node, transaction, managerInsertIndex, insertErrorMsg, rowName);
        }
        catch (Exception e) {
            logger.error("Error in insertManagerRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private StatusWithUuid _insertTableRow(Node node, TransactBuilder transaction, Integer insertIndex, String insertErrorMsg, String rowName) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new StatusWithUuid(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new StatusWithUuid(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            StatusWithUuid status = new StatusWithUuid(StatusCode.SUCCESS);
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (tr.get(i) == null || ((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new StatusWithUuid(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error creating {} : {}\n Error : {}\n Details : {}", new Object[]{insertErrorMsg, rowName, result.getError(), result.getDetails()});
                status = new StatusWithUuid(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (status.isSuccess()) {
                if (insertIndex >= 0 && insertIndex < tr.size() && tr.get(insertIndex) != null) {
                    UUID uuid = ((OperationResult)tr.get(insertIndex)).getUuid();
                    status = new StatusWithUuid(StatusCode.SUCCESS, uuid);
                } else {
                    status = new StatusWithUuid(StatusCode.SUCCESS, (UUID)null);
                }
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in _insertTableRow(): ", (Throwable)e);
            return new StatusWithUuid(StatusCode.INTERNALERROR);
        }
    }

    private Status deleteBridgeRow(Node node, String uuid) {
        String parentTableName = Open_vSwitch.NAME.getName();
        String childTableName = Bridge.NAME.getName();
        String parentColumn = "bridges";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deletePortRow(Node node, String uuid) {
        String parentTableName = Bridge.NAME.getName();
        String childTableName = Port.NAME.getName();
        String parentColumn = "ports";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteInterfaceRow(Node node, String uuid) {
        ConcurrentMap<String, Table<?>> portTable = this.inventoryServiceInternal.getTableCache(node, Port.NAME.getName());
        ConcurrentMap<String, Table<?>> interfaceTable = this.inventoryServiceInternal.getTableCache(node, Interface.NAME.getName());
        if (portTable == null || interfaceTable == null || uuid == null || interfaceTable.get(uuid) == null) {
            return new Status(StatusCode.NOTFOUND, "");
        }
        String parentTableName = Port.NAME.getName();
        String childTableName = Interface.NAME.getName();
        String parentColumn = "interfaces";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteControllerRow(Node node, String uuid) {
        String parentTableName = Bridge.NAME.getName();
        String childTableName = Controller.NAME.getName();
        String parentColumn = "controller";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteOpen_vSwitchRow(Node node, String uuid) {
        return new Status(StatusCode.NOTIMPLEMENTED, "delete operation for this Table is not implemented yet.");
    }

    private Status deleteSSLRow(Node node, String uuid) {
        String parentTableName = Open_vSwitch.NAME.getName();
        String childTableName = SSL.NAME.getName();
        String parentColumn = "ssl";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteSflowRow(Node node, String uuid) {
        String parentTableName = Bridge.NAME.getName();
        String childTableName = SFlow.NAME.getName();
        String parentColumn = "sflow";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteQueueRow(Node node, String uuid) {
        String childTableName = Queue.NAME.getName();
        return this._deleteRootTableRow(node, uuid, childTableName);
    }

    private Status deleteQosRow(Node node, String uuid) {
        String parentTableName = Port.NAME.getName();
        String childTableName = Qos.NAME.getName();
        String parentColumn = "qos";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteNetFlowRow(Node node, String uuid) {
        String parentTableName = Bridge.NAME.getName();
        String childTableName = NetFlow.NAME.getName();
        String parentColumn = "netflow";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteMirrorRow(Node node, String uuid) {
        String parentTableName = Bridge.NAME.getName();
        String childTableName = Mirror.NAME.getName();
        String parentColumn = "mirrors";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status deleteManagerRow(Node node, String uuid) {
        String parentTableName = Open_vSwitch.NAME.getName();
        String childTableName = Manager.NAME.getName();
        String parentColumn = "manager_options";
        return this._deleteTableRow(node, uuid, parentTableName, childTableName, parentColumn);
    }

    private Status _deleteTableRow(Node node, String uuid, String parentTableName, String childTableName, String parentColumn) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ConcurrentMap<String, Table<?>> parentTable = this.inventoryServiceInternal.getTableCache(node, parentTableName);
            ConcurrentMap<String, Table<?>> childTable = this.inventoryServiceInternal.getTableCache(node, childTableName);
            if (parentTable == null || childTable == null || uuid == null || childTable.get(uuid) == null) {
                return new Status(StatusCode.NOTFOUND, "");
            }
            MutateOperation delRequest = null;
            UUID rowUuid = new UUID(uuid);
            Mutation mutator = new Mutation(parentColumn, Mutator.DELETE, rowUuid);
            ArrayList<Mutation> mutations = new ArrayList<Mutation>();
            mutations.add(mutator);
            Status status = new Status(StatusCode.SUCCESS);
            Condition condition = new Condition(parentColumn, Function.INCLUDES, rowUuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            delRequest = new MutateOperation(parentTableName, where, mutations);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(delRequest)));
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (tr.get(i) == null || ((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error deleting: {}\n Error : {}\n Details : {}", new Object[]{uuid, result.getError(), result.getDetails()});
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in _deleteTableRow", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    private Status _deleteRootTableRow(Node node, String uuid, String TableName) {
        try {
            if (this.connectionService == null) {
                logger.error("Couldn't refer to the ConnectionService");
                return new Status(StatusCode.NOSERVICE);
            }
            Connection connection = this.getConnection(node);
            if (connection == null) {
                return new Status(StatusCode.NOSERVICE, "Connection to ovsdb-server not available");
            }
            ConcurrentMap<String, Table<?>> table = this.inventoryServiceInternal.getTableCache(node, TableName);
            if (table == null || table.get(uuid) == null) {
                return new Status(StatusCode.NOTFOUND, "");
            }
            DeleteOperation delRequest = null;
            UUID rowUuid = new UUID(uuid);
            Status status = new Status(StatusCode.SUCCESS);
            Condition condition = new Condition("_uuid", Function.EQUALS, rowUuid);
            ArrayList<Condition> where = new ArrayList<Condition>();
            where.add(condition);
            delRequest = new DeleteOperation(TableName, where);
            TransactBuilder transaction = new TransactBuilder();
            transaction.addOperations(new ArrayList<Operation>(Arrays.asList(delRequest)));
            ListenableFuture<List<OperationResult>> transResponse = connection.getRpc().transact(transaction);
            List tr = (List)transResponse.get();
            List<Operation> requests = transaction.getRequests();
            for (int i = 0; i < tr.size(); ++i) {
                if (i < requests.size()) {
                    requests.get(i).setResult((OperationResult)tr.get(i));
                }
                if (tr.get(i) == null || ((OperationResult)tr.get(i)).getError() == null || ((OperationResult)tr.get(i)).getError().trim().length() <= 0) continue;
                OperationResult result = (OperationResult)tr.get(i);
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            if (tr.size() > requests.size()) {
                OperationResult result = (OperationResult)tr.get(tr.size() - 1);
                logger.error("Error deleting: {}\n Error : {}\n Details : {}", new Object[]{uuid, result.getError(), result.getDetails()});
                status = new Status(StatusCode.BADREQUEST, result.getError() + " : " + result.getDetails());
            }
            return status;
        }
        catch (Exception e) {
            logger.error("Error in _deleteRootTableRow", (Throwable)e);
            return new Status(StatusCode.INTERNALERROR);
        }
    }

    public void _ovsconnect(CommandInterpreter ci) {
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        String ovsdbserver = ci.nextArgument();
        if (ovsdbserver == null) {
            ci.println((Object)"Please enter valid IP-Address");
            return;
        }
        try {
            InetAddress.getByName(ovsdbserver);
        }
        catch (UnknownHostException e) {
            logger.error("Unable to resolve " + ovsdbserver, (Throwable)e);
            ci.println((Object)"Please enter valid IP-Address");
            return;
        }
        String port = ci.nextArgument();
        if (port == null) {
            port = "6634";
        }
        ci.println((Object)("connecting to ovsdb server : " + ovsdbserver + ":" + port + " ... "));
        HashMap<ConnectionConstants, String> params = new HashMap<ConnectionConstants, String>();
        params.put(ConnectionConstants.ADDRESS, ovsdbserver);
        params.put(ConnectionConstants.PORT, port);
        Node node = this.connectionService.connect(bridgeName, params);
        if (node != null) {
            ci.println((Object)("Node Name: " + node.toString()));
        } else {
            ci.println((Object)"Could not connect to Node");
        }
    }

    public void _addBridge(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        Node node = Node.fromString((String)nodeName);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        Status status = this.createBridgeDomain(node, bridgeName, null);
        ci.println((Object)("Bridge creation status : " + status.toString()));
    }

    public void _getBridgeDomains(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        List<Object> brlist = new ArrayList();
        Node node = Node.fromString((String)nodeName);
        brlist = this.getBridgeDomains(node);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        ci.println((Object)("Existing Bridges: " + brlist.toString()));
    }

    public void _deleteBridgeDomain(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        Node node = Node.fromString((String)nodeName);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        Status status = this.deleteBridgeDomain(node, bridgeName);
        ci.println((Object)("Bridge deletion status : " + status.toString()));
    }

    public void _addPort(CommandInterpreter ci) {
        Node node;
        String configValue;
        String configKey;
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        String portName = ci.nextArgument();
        if (portName == null) {
            ci.println((Object)"Please enter Port Name");
            return;
        }
        String type = ci.nextArgument();
        HashMap<String, String> configs = new HashMap<String, String>();
        while ((configKey = ci.nextArgument()) != null && (configValue = ci.nextArgument()) != null) {
            configs.put(configKey, configValue);
        }
        HashMap<ConfigConstants, Object> customConfigs = null;
        if (type != null) {
            customConfigs = new HashMap<ConfigConstants, Object>();
            customConfigs.put(ConfigConstants.TYPE, type);
        }
        if (configs.size() > 0) {
            if (customConfigs == null) {
                customConfigs = new HashMap();
            }
            customConfigs.put(ConfigConstants.CUSTOM, configs);
            ci.println((Object)((Object)customConfigs).toString());
        }
        if ((node = Node.fromString((String)nodeName)) == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        Status status = this.addPort(node, bridgeName, portName, customConfigs);
        ci.println((Object)("Port creation status : " + status.toString()));
    }

    public void _deletePort(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        String portName = ci.nextArgument();
        if (portName == null) {
            ci.println((Object)"Please enter Port Name");
            return;
        }
        Node node = Node.fromString((String)nodeName);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        Status status = this.deletePort(node, bridgeName, portName);
        ci.println((Object)("Port deletion status : " + status.toString()));
    }

    public void _addPortVlan(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        String portName = ci.nextArgument();
        if (portName == null) {
            ci.println((Object)"Please enter Port Name");
            return;
        }
        String vlan = ci.nextArgument();
        if (vlan == null) {
            ci.println((Object)"Please enter Valid Vlan");
            return;
        }
        try {
            Integer.parseInt(vlan);
        }
        catch (NumberFormatException e) {
            ci.println((Object)"Please enter Valid Vlan");
            return;
        }
        HashMap<ConfigConstants, Object> configs = new HashMap<ConfigConstants, Object>();
        configs.put(ConfigConstants.TYPE, "VLAN");
        configs.put(ConfigConstants.VLAN, vlan);
        Node node = Node.fromString((String)nodeName);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        Status status = this.addPort(node, bridgeName, portName, configs);
        ci.println((Object)("Port creation status : " + status.toString()));
    }

    public void _addTunnel(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        String bridgeName = ci.nextArgument();
        if (bridgeName == null) {
            ci.println((Object)"Please enter Bridge Name");
            return;
        }
        String portName = ci.nextArgument();
        if (portName == null) {
            ci.println((Object)"Please enter Port Name");
            return;
        }
        String tunnelType = ci.nextArgument();
        if (tunnelType == null) {
            ci.println((Object)"Please enter Tunnel Type");
            return;
        }
        String remoteIp = ci.nextArgument();
        if (remoteIp == null) {
            ci.println((Object)"Please enter valid Remote IP Address");
            return;
        }
        try {
            InetAddress.getByName(remoteIp);
        }
        catch (Exception e) {
            logger.error("Unable to resolve " + remoteIp, (Throwable)e);
            ci.println((Object)"Please enter valid Remote IP Address");
            return;
        }
        HashMap<ConfigConstants, Object> configs = new HashMap<ConfigConstants, Object>();
        configs.put(ConfigConstants.TYPE, "TUNNEL");
        configs.put(ConfigConstants.TUNNEL_TYPE, tunnelType);
        configs.put(ConfigConstants.DEST_IP, remoteIp);
        Node node = Node.fromString((String)nodeName);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        Status status = this.addPort(node, bridgeName, portName, configs);
        ci.println((Object)("Port creation status : " + status.toString()));
    }

    public void _printCache(CommandInterpreter ci) {
        String nodeName = ci.nextArgument();
        if (nodeName == null) {
            ci.println((Object)"Please enter Node Name");
            return;
        }
        Node node = Node.fromString((String)nodeName);
        if (node == null) {
            ci.println((Object)"Invalid Node");
            return;
        }
        this.inventoryServiceInternal.printCache(node);
    }

    public void _forceConnect(CommandInterpreter ci) {
        String force = ci.nextArgument();
        if (force.equalsIgnoreCase("YES")) {
            this.forceConnect = true;
        } else if (force.equalsIgnoreCase("NO")) {
            this.forceConnect = false;
        } else {
            ci.println((Object)"Please enter YES or NO.");
        }
        ci.println((Object)("Current ForceConnect State : " + this.forceConnect));
    }

    public String getHelp() {
        StringBuilder help = new StringBuilder();
        help.append("---OVSDB CLI---\n");
        help.append("\t ovsconnect <ConnectionName> <ip-address>                        - Connect to OVSDB\n");
        help.append("\t addBridge <Node> <BridgeName>                                   - Add Bridge\n");
        help.append("\t getBridgeDomains <Node>                                         - Get Bridges\n");
        help.append("\t deleteBridgeDomain <Node> <BridgeName>                          - Delete a Bridge\n");
        help.append("\t addPort <Node> <BridgeName> <PortName> <type> <options pairs>   - Add Port\n");
        help.append("\t deletePort <Node> <BridgeName> <PortName>                       - Delete Port\n");
        help.append("\t addPortVlan <Node> <BridgeName> <PortName> <vlan>               - Add Port, Vlan\n");
        help.append("\t addTunnel <Node> <Bridge> <Port> <tunnel-type> <remote-ip>      - Add Tunnel\n");
        help.append("\t printCache <Node>                                               - Prints Table Cache");
        return help.toString();
    }
}

