/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.plugin;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.sal.connection.IPluginInConnectionService;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.inventory.IPluginInInventoryService;
import org.opendaylight.controller.sal.inventory.IPluginOutInventoryService;
import org.opendaylight.controller.sal.networkconfig.bridgedomain.IPluginInBridgeDomainConfigService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.INodeConnectorFactory;
import org.opendaylight.controller.sal.utils.INodeFactory;
import org.opendaylight.ovsdb.plugin.ConfigurationService;
import org.opendaylight.ovsdb.plugin.ConnectionService;
import org.opendaylight.ovsdb.plugin.IConnectionServiceInternal;
import org.opendaylight.ovsdb.plugin.InventoryService;
import org.opendaylight.ovsdb.plugin.InventoryServiceInternal;
import org.opendaylight.ovsdb.plugin.NodeConnectorFactory;
import org.opendaylight.ovsdb.plugin.NodeFactory;
import org.opendaylight.ovsdb.plugin.OVSDBConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public void init() {
        Node.NodeIDType.registerIDType((String)"OVS", String.class);
        NodeConnector.NodeConnectorIDType.registerIDType((String)"OVS", String.class, (String)"OVS");
    }

    public void destroy() {
        Node.NodeIDType.unRegisterIDType((String)"OVS");
        NodeConnector.NodeConnectorIDType.unRegisterIDType((String)"OVS");
    }

    public Object[] getGlobalImplementations() {
        Object[] res = new Object[]{ConnectionService.class, ConfigurationService.class, NodeFactory.class, NodeConnectorFactory.class, InventoryService.class};
        return res;
    }

    public void configureGlobalInstance(Component c, Object imp) {
        Hashtable<String, String> props;
        if (imp.equals(ConfigurationService.class)) {
            props = new Hashtable<String, String>();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), "OVS");
            c.setInterface(new String[]{IPluginInBridgeDomainConfigService.class.getName(), OVSDBConfigService.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IConnectionServiceInternal.class).setCallbacks("setConnectionServiceInternal", "unsetConnectionServiceInternal").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(InventoryServiceInternal.class).setCallbacks("setInventoryServiceInternal", "unsetInventoryServiceInternal").setRequired(true));
        }
        if (imp.equals(ConnectionService.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), "OVS");
            c.setInterface(new String[]{IPluginInConnectionService.class.getName(), IConnectionServiceInternal.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(InventoryServiceInternal.class).setCallbacks("setInventoryServiceInternal", "unsetInventoryServiceInternal").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IClusterGlobalServices.class).setCallbacks("setClusterServices", "unsetClusterServices").setRequired(false));
        }
        if (imp.equals(InventoryService.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), "OVS");
            c.setInterface(new String[]{IPluginInInventoryService.class.getName(), InventoryServiceInternal.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IPluginOutInventoryService.class, "(scope=Global)").setCallbacks("setPluginOutInventoryServices", "unsetPluginOutInventoryServices").setRequired(true));
        }
        if (imp.equals(NodeFactory.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), "OVS");
            ((Dictionary)props).put("protocolName", "OVS");
            c.setInterface(INodeFactory.class.getName(), props);
        }
        if (imp.equals(NodeConnectorFactory.class)) {
            props = new Hashtable();
            ((Dictionary)props).put(GlobalConstants.PROTOCOLPLUGINTYPE.toString(), "OVS");
            ((Dictionary)props).put("protocolName", "OVS");
            c.setInterface(INodeConnectorFactory.class.getName(), props);
        }
    }
}

