/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.message;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.opendaylight.ovsdb.lib.message.Response;
import org.opendaylight.ovsdb.lib.message.TableUpdate;
import org.opendaylight.ovsdb.lib.table.Bridge;
import org.opendaylight.ovsdb.lib.table.Capability;
import org.opendaylight.ovsdb.lib.table.Controller;
import org.opendaylight.ovsdb.lib.table.Flow_Sample_Collector_Set;
import org.opendaylight.ovsdb.lib.table.Flow_Table;
import org.opendaylight.ovsdb.lib.table.IPFIX;
import org.opendaylight.ovsdb.lib.table.Interface;
import org.opendaylight.ovsdb.lib.table.Manager;
import org.opendaylight.ovsdb.lib.table.Mirror;
import org.opendaylight.ovsdb.lib.table.NetFlow;
import org.opendaylight.ovsdb.lib.table.Open_vSwitch;
import org.opendaylight.ovsdb.lib.table.Port;
import org.opendaylight.ovsdb.lib.table.Qos;
import org.opendaylight.ovsdb.lib.table.Queue;
import org.opendaylight.ovsdb.lib.table.SFlow;
import org.opendaylight.ovsdb.lib.table.SSL;
import org.opendaylight.ovsdb.lib.table.internal.Table;

public class TableUpdates
extends Response {
    Map<Table.Name, TableUpdate> map = Maps.newHashMap();

    public Set<Table.Name> availableUpdates() {
        return this.map.keySet();
    }

    public <T extends Table> TableUpdate<T> getUpdate(Table.Name<T> name) {
        return this.map.get(name);
    }

    private <T extends Table> void put(Table.Name<T> name, TableUpdate<T> update) {
        this.map.put(name, update);
    }

    @JsonProperty(value="Interface")
    public TableUpdate<Interface> getInterfaceUpdate() {
        return this.getUpdate(Interface.NAME);
    }

    public void setInterfaceUpdate(TableUpdate<Interface> interfaceUpdate) {
        this.put(Interface.NAME, interfaceUpdate);
    }

    @JsonProperty(value="Bridge")
    TableUpdate<Bridge> getBridgeUpdate() {
        return this.getUpdate(Bridge.NAME);
    }

    public void setBridgeUpdate(TableUpdate<Bridge> bridgeUpdate) {
        this.put(Bridge.NAME, bridgeUpdate);
    }

    @JsonProperty(value="Port")
    TableUpdate<Port> getPortUpdate() {
        return this.getUpdate(Port.NAME);
    }

    void setPortUpdate(TableUpdate<Port> portUpdate) {
        this.put(Port.NAME, portUpdate);
    }

    @JsonProperty(value="Capability")
    public TableUpdate<Capability> getCapabilityUpdate() {
        return this.getUpdate(Capability.NAME);
    }

    public void setCapabilityUpdate(TableUpdate<Capability> capabilityUpdate) {
        this.put(Capability.NAME, capabilityUpdate);
    }

    @JsonProperty(value="Controller")
    public TableUpdate<Controller> getControllerUpdate() {
        return this.getUpdate(Controller.NAME);
    }

    public void setControllerUpdate(TableUpdate<Controller> controllerUpdate) {
        this.put(Controller.NAME, controllerUpdate);
    }

    @JsonProperty(value="Manager")
    public TableUpdate<Manager> getManagerUpdate() {
        return this.getUpdate(Manager.NAME);
    }

    public void setManagerUpdate(TableUpdate<Manager> managerUpdate) {
        this.put(Manager.NAME, managerUpdate);
    }

    @JsonProperty(value="Mirror")
    public TableUpdate<Mirror> getMirrorUpdate() {
        return this.getUpdate(Mirror.NAME);
    }

    public void setMirrorUpdate(TableUpdate<Mirror> mirrorUpdate) {
        this.put(Mirror.NAME, mirrorUpdate);
    }

    @JsonProperty(value="NetFlow")
    public TableUpdate<NetFlow> getNetFlowUpdate() {
        return this.getUpdate(NetFlow.NAME);
    }

    public void setNetFlowUpdate(TableUpdate<NetFlow> netFlowUpdate) {
        this.put(NetFlow.NAME, netFlowUpdate);
    }

    @JsonProperty(value="Open_vSwitch")
    public TableUpdate<Open_vSwitch> getOpen_vSwitchUpdate() {
        return this.getUpdate(Open_vSwitch.NAME);
    }

    public void setOpen_vSwitchUpdate(TableUpdate<Open_vSwitch> openVSwitchUpdate) {
        this.put(Open_vSwitch.NAME, openVSwitchUpdate);
    }

    @JsonProperty(value="QoS")
    public TableUpdate<Qos> getQosUpdate() {
        return this.getUpdate(Qos.NAME);
    }

    public void setQosUpdate(TableUpdate<Qos> qosUpdate) {
        this.put(Qos.NAME, qosUpdate);
    }

    @JsonProperty(value="Queue")
    public TableUpdate<Queue> getQueueUpdate() {
        return this.getUpdate(Queue.NAME);
    }

    public void setQueueUpdate(TableUpdate<Queue> queueUpdate) {
        this.put(Queue.NAME, queueUpdate);
    }

    @JsonProperty(value="sFlow")
    public TableUpdate<SFlow> getSFlowUpdate() {
        return this.getUpdate(SFlow.NAME);
    }

    public void setSFlowUpdate(TableUpdate<SFlow> sFlowUpdate) {
        this.put(SFlow.NAME, sFlowUpdate);
    }

    @JsonProperty(value="SSL")
    public TableUpdate<SSL> getSSLUpdate() {
        return this.getUpdate(SSL.NAME);
    }

    public void setSSLUpdate(TableUpdate<SSL> sslUpdate) {
        this.put(SSL.NAME, sslUpdate);
    }

    @JsonProperty(value="Flow_Table")
    public TableUpdate<Flow_Table> getFlow_TableUpdate() {
        return this.getUpdate(Flow_Table.NAME);
    }

    public void setFlow_TableUpdate(TableUpdate<Flow_Table> Flow_TableUpdate) {
        this.put(Flow_Table.NAME, Flow_TableUpdate);
    }

    @JsonProperty(value="Flow_Sample_Collector_Set")
    public TableUpdate<Flow_Sample_Collector_Set> getFlow_Sample_Collector_SetUpdate() {
        return this.getUpdate(Flow_Sample_Collector_Set.NAME);
    }

    public void setFlow_Sample_Collector_SetUpdate(TableUpdate<Flow_Sample_Collector_Set> Flow_Sample_Collector_SetUpdate) {
        this.put(Flow_Sample_Collector_Set.NAME, Flow_Sample_Collector_SetUpdate);
    }

    @JsonProperty(value="IPFIX")
    public TableUpdate<IPFIX> getIPFIXUpdate() {
        return this.getUpdate(IPFIX.NAME);
    }

    public void setIPFIXUpdate(TableUpdate<IPFIX> IPFIXUpdate) {
        this.put(IPFIX.NAME, IPFIXUpdate);
    }
}

