/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.message;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.ovsdb.lib.table.internal.Table;

public class TableUpdate<T extends Table> {
    Map<String, Row<T>> map = Maps.newHashMap();

    @JsonAnyGetter
    public Row<T> get(String rowId) {
        return this.map.get(rowId);
    }

    @JsonAnySetter
    public void set(String rowId, Row<T> value) {
        this.map.put(rowId, value);
        value.setId(rowId);
    }

    public Collection<Row<T>> getRows() {
        return this.map.values();
    }

    public String toString() {
        return "TableUpdate [map=" + this.map + "]";
    }

    public static class Row<T> {
        @JsonIgnore
        String id;
        @JsonProperty(value="new")
        T _new;
        T old;

        public String getId() {
            return this.id;
        }

        public T getNew() {
            return this._new;
        }

        public void setNew(T neww) {
            this._new = neww;
        }

        public T getOld() {
            return this.old;
        }

        public void setOld(T old) {
            this.old = old;
        }

        void setId(String id) {
            this.id = id;
        }

        public String toString() {
            return "Row{id='" + this.id + '\'' + ", _new=" + this._new.toString() + '}';
        }
    }
}

