/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.jsonrpc;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpcEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcServiceBinderHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(JsonRpcServiceBinderHandler.class);
    Map<Object, SettableFuture<Object>> waitingForReply = Maps.newHashMap();
    JsonRpcEndpoint factory = null;
    Node node = null;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public JsonRpcServiceBinderHandler(JsonRpcEndpoint factory) {
        this.factory = factory;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)msg;
            if (jsonNode.has("result")) {
                this.factory.processResult(jsonNode);
            } else if (jsonNode.hasNonNull("method") && jsonNode.has("id") && !Strings.isNullOrEmpty((String)jsonNode.get("id").asText())) {
                this.factory.processRequest(this.node, jsonNode);
            }
            return;
        }
        ctx.channel().close();
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }
}

