/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.jsonrpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.collect.Maps;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpc10Request;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpc10Response;
import org.opendaylight.ovsdb.lib.jsonrpc.Params;
import org.opendaylight.ovsdb.lib.message.OvsdbRPC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcEndpoint {
    protected static final Logger logger = LoggerFactory.getLogger(JsonRpcEndpoint.class);
    ObjectMapper objectMapper;
    Channel nettyChannel;
    Map<String, CallContext> methodContext = Maps.newHashMap();
    Map<Node, OvsdbRPC.Callback> requestCallbacks = Maps.newHashMap();

    public JsonRpcEndpoint(ObjectMapper objectMapper, Channel channel) {
        this.objectMapper = objectMapper;
        this.nettyChannel = channel;
    }

    public <T> T getClient(final Node node, Class<T> klazz) {
        return (T)Reflection.newProxy(klazz, (InvocationHandler)new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().equals("registerCallback")) {
                    if (args == null || args.length != 1 || !(args[0] instanceof OvsdbRPC.Callback)) {
                        return false;
                    }
                    JsonRpcEndpoint.this.requestCallbacks.put(node, (OvsdbRPC.Callback)args[0]);
                    return true;
                }
                JsonRpc10Request request = new JsonRpc10Request(UUID.randomUUID().toString());
                request.setMethod(method.getName());
                if (args != null && args.length != 0) {
                    List params = null;
                    if (args.length == 1) {
                        if (args[0] instanceof Params) {
                            params = ((Params)args[0]).params();
                        } else if (args[0] instanceof List) {
                            params = (List)args[0];
                        }
                        if (params == null) {
                            throw new RuntimeException("do not understand this argument yet");
                        }
                        request.setParams(params);
                    }
                }
                String s = JsonRpcEndpoint.this.objectMapper.writeValueAsString((Object)request);
                logger.trace("{}", (Object)s);
                SettableFuture sf = SettableFuture.create();
                JsonRpcEndpoint.this.methodContext.put(request.getId(), new CallContext(request, method, (SettableFuture<Object>)sf));
                JsonRpcEndpoint.this.nettyChannel.writeAndFlush((Object)s);
                return sf;
            }
        });
    }

    public void processResult(JsonNode response) throws NoSuchMethodException {
        Object result1;
        logger.trace("Response : {}", (Object)response.toString());
        CallContext returnCtxt = this.methodContext.get(response.get("id").asText());
        if (returnCtxt == null) {
            return;
        }
        if (ListenableFuture.class == returnCtxt.getMethod().getReturnType()) {
            TypeToken retType = TypeToken.of((Type)returnCtxt.getMethod().getGenericReturnType()).resolveType(ListenableFuture.class.getMethod("get", new Class[0]).getGenericReturnType());
            JavaType javaType = TypeFactory.defaultInstance().constructType(retType.getType());
            JsonNode result = response.get("result");
            logger.trace("Result : {}", (Object)result.toString());
            result1 = this.objectMapper.convertValue((Object)result, javaType);
            JsonNode error = response.get("error");
            if (error != null && !error.isNull()) {
                logger.error("Error : {}", (Object)error.toString());
            }
        } else {
            throw new RuntimeException("donno how to deal with this");
        }
        returnCtxt.getFuture().set(result1);
    }

    public void processRequest(Node node, JsonNode requestJson) {
        JsonRpc10Request request = new JsonRpc10Request(requestJson.get("id").asText());
        request.setMethod(requestJson.get("method").asText());
        logger.trace("Request : {} {}", (Object)requestJson.get("method"), (Object)requestJson.get("params"));
        OvsdbRPC.Callback callback = this.requestCallbacks.get(node);
        if (callback != null) {
            Method[] methods;
            for (Method m : methods = callback.getClass().getDeclaredMethods()) {
                if (!m.getName().equals(request.getMethod())) continue;
                Class<?>[] parameters = m.getParameterTypes();
                JsonNode params = requestJson.get("params");
                Object param = this.objectMapper.convertValue((Object)params, parameters[1]);
                try {
                    m.invoke((Object)callback, node, param);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    logger.error("Unable to invoke callback " + m.getName(), (Throwable)e);
                }
                return;
            }
        }
        if (request.getMethod().equals("echo")) {
            JsonRpc10Response response = new JsonRpc10Response(request.getId());
            response.setError(null);
            String s = null;
            try {
                s = this.objectMapper.writeValueAsString((Object)response);
                this.nettyChannel.writeAndFlush((Object)s);
            }
            catch (JsonProcessingException e) {
                logger.error("Exception while processing JSON string " + s, (Throwable)e);
            }
            return;
        }
        logger.error("No handler for Request : {} on {}", (Object)requestJson.toString(), (Object)node);
    }

    public Map<String, CallContext> getMethodContext() {
        return this.methodContext;
    }

    public class CallContext {
        Method method;
        JsonRpc10Request request;
        SettableFuture<Object> future;

        public CallContext(JsonRpc10Request request, Method method, SettableFuture<Object> future) {
            this.method = method;
            this.request = request;
            this.future = future;
        }

        public Method getMethod() {
            return this.method;
        }

        public JsonRpc10Request getRequest() {
            return this.request;
        }

        public SettableFuture<Object> getFuture() {
            return this.future;
        }
    }
}

