/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.jsonrpc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opendaylight.ovsdb.lib.jsonrpc.InvalidEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcDecoder
extends ByteToMessageDecoder {
    protected static final Logger logger = LoggerFactory.getLogger(JsonRpcDecoder.class);
    private int maxFrameLength;
    private JsonFactory jacksonJsonFactory = new MappingJsonFactory();
    private IOContext jacksonIOContext = new IOContext(new BufferRecycler(), null, false);
    private int lastRecordBytes = 0;
    private int leftCurlies = 0;
    private int rightCurlies = 0;
    private boolean inS = false;
    private int recordsRead;

    public JsonRpcDecoder(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
        int i;
        logger.trace("readable bytes {}, records read {}, incomplete record bytes {}", new Object[]{buf.readableBytes(), this.recordsRead, this.lastRecordBytes});
        if (this.lastRecordBytes == 0) {
            if (buf.readableBytes() < 4) {
                return;
            }
            JsonRpcDecoder.skipSpaces(buf);
            byte[] buff = new byte[4];
            buf.getBytes(buf.readerIndex(), buff);
            ByteSourceJsonBootstrapper strapper = new ByteSourceJsonBootstrapper(this.jacksonIOContext, buff, 0, 4);
            JsonEncoding jsonEncoding = strapper.detectEncoding();
            if (!JsonEncoding.UTF8.equals((Object)jsonEncoding)) {
                throw new InvalidEncodingException(jsonEncoding.getJavaName(), "currently only UTF-8 is supported");
            }
        }
        for (i = this.lastRecordBytes + buf.readerIndex(); i < buf.writerIndex(); ++i) {
            switch (buf.getByte(i)) {
                case 123: {
                    if (this.inS) break;
                    ++this.leftCurlies;
                    break;
                }
                case 125: {
                    if (this.inS) break;
                    ++this.rightCurlies;
                    break;
                }
                case 34: {
                    if (buf.getByte(i - 1) == 92) break;
                    boolean bl = this.inS = !this.inS;
                }
            }
            if (this.leftCurlies != 0 && this.leftCurlies == this.rightCurlies && !this.inS) {
                ByteBuf slice = buf.readSlice(1 + i - buf.readerIndex());
                JsonParser jp = this.jacksonJsonFactory.createParser((InputStream)new ByteBufInputStream(slice));
                JsonNode root = (JsonNode)jp.readValueAsTree();
                out.add(root);
                this.lastRecordBytes = 0;
                this.rightCurlies = 0;
                this.leftCurlies = 0;
                ++this.recordsRead;
                break;
            }
            if (i - buf.readerIndex() < this.maxFrameLength) continue;
            this.fail(ctx, i - buf.readerIndex());
        }
        if (i >= buf.writerIndex()) {
            this.lastRecordBytes = buf.readableBytes();
            return;
        }
    }

    public int getRecordsRead() {
        return this.recordsRead;
    }

    private static void skipSpaces(ByteBuf b) throws IOException {
        while (b.isReadable()) {
            int ch = b.getByte(b.readerIndex()) & 0xFF;
            if (ch != 32 && ch != 13 && ch != 10 && ch != 9) {
                return;
            }
            b.readByte();
        }
    }

    private void print(ByteBuf buf, String message) {
        this.print(buf, buf.readerIndex(), buf.readableBytes(), message == null ? "buff" : message);
    }

    private void print(ByteBuf buf, int startPos, int chars, String message) {
        if (null == message) {
            message = "";
        }
        if (startPos > buf.writerIndex()) {
            logger.trace("startPos out of bounds");
        }
        byte[] b = new byte[startPos + chars <= buf.writerIndex() ? chars : buf.writerIndex() - startPos];
        buf.getBytes(startPos, b);
        logger.trace("{} ={}", (Object)message, (Object)new String(b));
    }

    private void fail(ChannelHandlerContext ctx, long frameLength) {
        if (frameLength > 0L) {
            ctx.fireExceptionCaught((Throwable)new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + frameLength + " - discarded"));
        } else {
            ctx.fireExceptionCaught((Throwable)new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding"));
        }
    }
}

