/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.database;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.ovsdb.plugin.Connection;
import org.opendaylight.ovsdb.plugin.OvsdbMessage;

public class OVSBridge {
    private String uuid;
    private String name;

    public OVSBridge(String uuid, String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public static Map<String, OVSBridge> monitorBridge(Connection connection) {
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("_uuid");
        columns.add("name");
        HashMap<String, ArrayList<String>> row = new HashMap<String, ArrayList<String>>();
        row.put("columns", columns);
        HashMap<String, HashMap<String, ArrayList<String>>> tables = new HashMap<String, HashMap<String, ArrayList<String>>>();
        tables.put("Bridge", row);
        Object[] params = new Object[]{"Open_vSwitch", null, tables};
        OvsdbMessage msg = new OvsdbMessage("monitor", params);
        HashMap monitorResponse = new HashMap();
        Map bridgeTable = (Map)monitorResponse.get("Bridge");
        Object[] uuidObjects = bridgeTable.keySet().toArray();
        String[] uuids = (String[])Arrays.copyOf(uuidObjects, uuidObjects.length, String[].class);
        HashMap<String, OVSBridge> result = new HashMap<String, OVSBridge>();
        for (String uuid : uuids) {
            Map newRow = (Map)bridgeTable.get(uuid);
            Map newColumns = (Map)newRow.get("new");
            String name = (String)newColumns.get("name");
            result.put(name, new OVSBridge(uuid, name));
        }
        return result;
    }
}

