/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.implementation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronNetwork;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeutronSubnetInterface
implements INeutronSubnetCRUD,
IConfigurationContainerAware,
IObjectReader {
    private static final Logger logger = LoggerFactory.getLogger(NeutronSubnetInterface.class);
    private static final String FILE_NAME = "neutron.subnet.conf";
    private String containerName = null;
    private IClusterContainerServices clusterContainerService = null;
    private IConfigurationContainerService configurationService;
    private ConcurrentMap<String, NeutronSubnet> subnetDB;

    void setClusterContainerService(IClusterContainerServices s) {
        logger.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            logger.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service set: {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service removed: {}", (Object)service);
        this.configurationService = null;
    }

    private void allocateCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't create cache");
            return;
        }
        logger.debug("Creating Cache for Neutron Subnets");
        try {
            this.clusterContainerService.createCache("neutronSubnets", EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache couldn't be created for Neutron Subnets -  check cache mode");
        }
        catch (CacheExistException cce) {
            logger.error("Cache for Neutron Subnets already exists, destroy and recreate");
        }
        logger.debug("Cache successfully created for Neutron Subnets");
    }

    private void retrieveCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        logger.debug("Retrieving cache for Neutron Subnets");
        this.subnetDB = this.clusterContainerService.getCache("neutronSubnets");
        if (this.subnetDB == null) {
            logger.error("Cache couldn't be retrieved for Neutron Subnets");
        }
        logger.debug("Cache was successfully retrieved for Neutron Subnets");
    }

    private void destroyCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterMger, can't destroy cache");
            return;
        }
        logger.debug("Destroying Cache for HostTracker");
        this.clusterContainerService.destroyCache("neutronSubnets");
    }

    private void startUp() {
        this.allocateCache();
        this.retrieveCache();
        this.loadConfiguration();
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            logger.debug("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        this.startUp();
    }

    void destroy() {
        this.destroyCache();
    }

    void start() {
    }

    void stop() {
    }

    private boolean overwrite(Object target, Object delta) {
        Method[] methods;
        for (Method toMethod : methods = target.getClass().getMethods()) {
            if (!toMethod.getDeclaringClass().equals(target.getClass()) || !toMethod.getName().startsWith("set")) continue;
            String toName = toMethod.getName();
            String fromName = toName.replace("set", "get");
            try {
                Method fromMethod = delta.getClass().getMethod(fromName, new Class[0]);
                Object value = fromMethod.invoke(delta, (Object[])null);
                if (value == null) continue;
                toMethod.invoke(target, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean subnetExists(String uuid) {
        return this.subnetDB.containsKey(uuid);
    }

    public NeutronSubnet getSubnet(String uuid) {
        if (!this.subnetExists(uuid)) {
            return null;
        }
        return (NeutronSubnet)this.subnetDB.get(uuid);
    }

    public List<NeutronSubnet> getAllSubnets() {
        HashSet<NeutronSubnet> allSubnets = new HashSet<NeutronSubnet>();
        for (Map.Entry entry : this.subnetDB.entrySet()) {
            NeutronSubnet subnet = (NeutronSubnet)entry.getValue();
            allSubnets.add(subnet);
        }
        logger.debug("Exiting getAllSubnets, Found {} OpenStackSubnets", (Object)allSubnets.size());
        ArrayList<NeutronSubnet> ans = new ArrayList<NeutronSubnet>();
        ans.addAll(allSubnets);
        return ans;
    }

    public boolean addSubnet(NeutronSubnet input) {
        String id = input.getID();
        if (this.subnetExists(id)) {
            return false;
        }
        this.subnetDB.putIfAbsent(id, input);
        INeutronNetworkCRUD networkIf = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        NeutronNetwork targetNet = networkIf.getNetwork(input.getNetworkUUID());
        targetNet.addSubnet(id);
        return true;
    }

    public boolean removeSubnet(String uuid) {
        if (!this.subnetExists(uuid)) {
            return false;
        }
        NeutronSubnet target = (NeutronSubnet)this.subnetDB.get(uuid);
        INeutronNetworkCRUD networkIf = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        NeutronNetwork targetNet = networkIf.getNetwork(target.getNetworkUUID());
        targetNet.removeSubnet(uuid);
        this.subnetDB.remove(uuid);
        return true;
    }

    public boolean updateSubnet(String uuid, NeutronSubnet delta) {
        if (!this.subnetExists(uuid)) {
            return false;
        }
        NeutronSubnet target = (NeutronSubnet)this.subnetDB.get(uuid);
        return this.overwrite(target, delta);
    }

    public boolean subnetInUse(String subnetUUID) {
        if (!this.subnetExists(subnetUUID)) {
            return true;
        }
        NeutronSubnet target = (NeutronSubnet)this.subnetDB.get(subnetUUID);
        return target.getPortsInSubnet().size() > 0;
    }

    private void loadConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, FILE_NAME)) {
            NeutronSubnet ns = (NeutronSubnet)conf;
            this.subnetDB.put(ns.getID(), ns);
        }
    }

    public Status saveConfiguration() {
        return this.configurationService.persistConfiguration(new ArrayList(this.subnetDB.values()), FILE_NAME);
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }
}

