/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.implementation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.networkconfig.neutron.INeutronRouterCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronRouter;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeutronRouterInterface
implements INeutronRouterCRUD,
IConfigurationContainerAware,
IObjectReader {
    private static final Logger logger = LoggerFactory.getLogger(NeutronRouterInterface.class);
    private static final String FILE_NAME = "neutron.router.conf";
    private String containerName = null;
    private IClusterContainerServices clusterContainerService = null;
    private IConfigurationContainerService configurationService;
    private ConcurrentMap<String, NeutronRouter> routerDB;

    void setClusterContainerService(IClusterContainerServices s) {
        logger.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            logger.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service set: {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service removed: {}", (Object)service);
        this.configurationService = null;
    }

    private void allocateCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't create cache");
            return;
        }
        logger.debug("Creating Cache for Neutron Routers");
        try {
            this.clusterContainerService.createCache("neutronRouters", EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache couldn't be created for Neutron Routers -  check cache mode");
        }
        catch (CacheExistException cce) {
            logger.error("Cache for Neutron Routers already exists, destroy and recreate");
        }
        logger.debug("Cache successfully created for Neutron Routers");
    }

    private void retrieveCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        logger.debug("Retrieving cache for Neutron Routers");
        this.routerDB = this.clusterContainerService.getCache("neutronRouters");
        if (this.routerDB == null) {
            logger.error("Cache couldn't be retrieved for Neutron Routers");
        }
        logger.debug("Cache was successfully retrieved for Neutron Routers");
    }

    private void destroyCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterMger, can't destroy cache");
            return;
        }
        logger.debug("Destroying Cache for HostTracker");
        this.clusterContainerService.destroyCache("neutronRouters");
    }

    private void startUp() {
        this.allocateCache();
        this.retrieveCache();
        this.loadConfiguration();
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            logger.debug("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        this.startUp();
    }

    void destroy() {
        this.destroyCache();
    }

    void start() {
    }

    void stop() {
    }

    private boolean overwrite(Object target, Object delta) {
        Method[] methods;
        for (Method toMethod : methods = target.getClass().getMethods()) {
            if (!toMethod.getDeclaringClass().equals(target.getClass()) || !toMethod.getName().startsWith("set")) continue;
            String toName = toMethod.getName();
            String fromName = toName.replace("set", "get");
            try {
                Method fromMethod = delta.getClass().getMethod(fromName, new Class[0]);
                Object value = fromMethod.invoke(delta, (Object[])null);
                if (value == null) continue;
                toMethod.invoke(target, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean routerExists(String uuid) {
        return this.routerDB.containsKey(uuid);
    }

    public NeutronRouter getRouter(String uuid) {
        if (!this.routerExists(uuid)) {
            return null;
        }
        return (NeutronRouter)this.routerDB.get(uuid);
    }

    public List<NeutronRouter> getAllRouters() {
        HashSet<NeutronRouter> allRouters = new HashSet<NeutronRouter>();
        for (Map.Entry entry : this.routerDB.entrySet()) {
            NeutronRouter router = (NeutronRouter)entry.getValue();
            allRouters.add(router);
        }
        logger.debug("Exiting getAllRouters, Found {} Routers", (Object)allRouters.size());
        ArrayList<NeutronRouter> ans = new ArrayList<NeutronRouter>();
        ans.addAll(allRouters);
        return ans;
    }

    public boolean addRouter(NeutronRouter input) {
        if (this.routerExists(input.getID())) {
            return false;
        }
        this.routerDB.putIfAbsent(input.getID(), input);
        return true;
    }

    public boolean removeRouter(String uuid) {
        if (!this.routerExists(uuid)) {
            return false;
        }
        this.routerDB.remove(uuid);
        return true;
    }

    public boolean updateRouter(String uuid, NeutronRouter delta) {
        if (!this.routerExists(uuid)) {
            return false;
        }
        NeutronRouter target = (NeutronRouter)this.routerDB.get(uuid);
        return this.overwrite(target, delta);
    }

    public boolean routerInUse(String routerUUID) {
        if (!this.routerExists(routerUUID)) {
            return true;
        }
        NeutronRouter target = (NeutronRouter)this.routerDB.get(routerUUID);
        return target.getInterfaces().size() > 0;
    }

    private void loadConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, FILE_NAME)) {
            NeutronRouter nr = (NeutronRouter)conf;
            this.routerDB.put(nr.getID(), nr);
        }
    }

    public Status saveConfiguration() {
        return this.configurationService.persistConfiguration(new ArrayList(this.routerDB.values()), FILE_NAME);
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }
}

