/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.implementation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronNetwork;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeutronNetworkInterface
implements INeutronNetworkCRUD,
IConfigurationContainerAware,
IObjectReader {
    private static final Logger logger = LoggerFactory.getLogger(NeutronNetworkInterface.class);
    private static final String FILE_NAME = "neutron.network.conf";
    private String containerName = null;
    private ConcurrentMap<String, NeutronNetwork> networkDB;
    private IClusterContainerServices clusterContainerService = null;
    private IConfigurationContainerService configurationService;

    void setClusterContainerService(IClusterContainerServices s) {
        logger.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            logger.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service set: {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service removed: {}", (Object)service);
        this.configurationService = null;
    }

    private void allocateCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't create cache");
            return;
        }
        logger.debug("Creating Cache for Neutron Networks");
        try {
            this.clusterContainerService.createCache("neutronNetworks", EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache couldn't be created for Neutron Networks -  check cache mode");
        }
        catch (CacheExistException cce) {
            logger.error("Cache for Neutron Networks already exists, destroy and recreate");
        }
        logger.debug("Cache successfully created for Neutron Networks");
    }

    private void retrieveCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        logger.debug("Retrieving cache for Neutron Networks");
        this.networkDB = this.clusterContainerService.getCache("neutronNetworks");
        if (this.networkDB == null) {
            logger.error("Cache couldn't be retrieved for Neutron Networks");
        }
        logger.debug("Cache was successfully retrieved for Neutron Networks");
    }

    private void startUp() {
        this.allocateCache();
        this.retrieveCache();
        this.loadConfiguration();
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            logger.debug("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        this.startUp();
    }

    private void destroyCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterMger, can't destroy cache");
            return;
        }
        logger.debug("Destroying Cache for Neutron Networks");
        this.clusterContainerService.destroyCache("Neutron Networks");
    }

    void destroy() {
        this.destroyCache();
    }

    void start() {
    }

    void stop() {
    }

    private boolean overwrite(Object target, Object delta) {
        Method[] methods;
        for (Method toMethod : methods = target.getClass().getMethods()) {
            if (!toMethod.getDeclaringClass().equals(target.getClass()) || !toMethod.getName().startsWith("set")) continue;
            String toName = toMethod.getName();
            String fromName = toName.replace("set", "get");
            try {
                Method fromMethod = delta.getClass().getMethod(fromName, new Class[0]);
                Object value = fromMethod.invoke(delta, (Object[])null);
                if (value == null) continue;
                toMethod.invoke(target, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean networkExists(String uuid) {
        return this.networkDB.containsKey(uuid);
    }

    public NeutronNetwork getNetwork(String uuid) {
        if (!this.networkExists(uuid)) {
            return null;
        }
        return (NeutronNetwork)this.networkDB.get(uuid);
    }

    public List<NeutronNetwork> getAllNetworks() {
        HashSet<NeutronNetwork> allNetworks = new HashSet<NeutronNetwork>();
        for (Map.Entry entry : this.networkDB.entrySet()) {
            NeutronNetwork network = (NeutronNetwork)entry.getValue();
            allNetworks.add(network);
        }
        logger.debug("Exiting getAllNetworks, Found {} OpenStackNetworks", (Object)allNetworks.size());
        ArrayList<NeutronNetwork> ans = new ArrayList<NeutronNetwork>();
        ans.addAll(allNetworks);
        return ans;
    }

    public boolean addNetwork(NeutronNetwork input) {
        if (this.networkExists(input.getID())) {
            return false;
        }
        this.networkDB.putIfAbsent(input.getID(), input);
        return true;
    }

    public boolean removeNetwork(String uuid) {
        if (!this.networkExists(uuid)) {
            return false;
        }
        this.networkDB.remove(uuid);
        return true;
    }

    public boolean updateNetwork(String uuid, NeutronNetwork delta) {
        if (!this.networkExists(uuid)) {
            return false;
        }
        NeutronNetwork target = (NeutronNetwork)this.networkDB.get(uuid);
        return this.overwrite(target, delta);
    }

    public boolean networkInUse(String netUUID) {
        if (!this.networkExists(netUUID)) {
            return true;
        }
        NeutronNetwork target = (NeutronNetwork)this.networkDB.get(netUUID);
        return target.getPortsOnNetwork().size() > 0;
    }

    private void loadConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, FILE_NAME)) {
            NeutronNetwork nn = (NeutronNetwork)conf;
            this.networkDB.put(nn.getID(), nn);
        }
    }

    public Status saveConfiguration() {
        return this.configurationService.persistConfiguration(new ArrayList(this.networkDB.values()), FILE_NAME);
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }
}

