/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.implementation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.networkconfig.neutron.INeutronFloatingIPCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronPortCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronFloatingIP;
import org.opendaylight.controller.networkconfig.neutron.NeutronPort;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeutronFloatingIPInterface
implements INeutronFloatingIPCRUD,
IConfigurationContainerAware,
IObjectReader {
    private static final Logger logger = LoggerFactory.getLogger(NeutronFloatingIPInterface.class);
    private static final String FILE_NAME = "neutron.floatingip.conf";
    private String containerName = null;
    private IClusterContainerServices clusterContainerService = null;
    private IConfigurationContainerService configurationService;
    private ConcurrentMap<String, NeutronFloatingIP> floatingIPDB;

    void setClusterContainerService(IClusterContainerServices s) {
        logger.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            logger.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service set: {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        logger.trace("Configuration service removed: {}", (Object)service);
        this.configurationService = null;
    }

    private void allocateCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't create cache");
            return;
        }
        logger.debug("Creating Cache for Neutron FloatingIPs");
        try {
            this.clusterContainerService.createCache("neutronFloatingIPs", EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.error("Cache couldn't be created for Neutron -  check cache mode");
        }
        catch (CacheExistException cce) {
            logger.error("Cache for Neutron already exists, destroy and recreate");
        }
        logger.debug("Cache successfully created for NeutronFloatingIps");
    }

    private void retrieveCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterContainerService, can't retrieve cache");
            return;
        }
        logger.debug("Retrieving cache for Neutron FloatingIPs");
        this.floatingIPDB = this.clusterContainerService.getCache("neutronFloatingIPs");
        if (this.floatingIPDB == null) {
            logger.error("Cache couldn't be retrieved for Neutron FloatingIPs");
        }
        logger.debug("Cache was successfully retrieved for Neutron FloatingIPs");
    }

    private void destroyCache() {
        if (this.clusterContainerService == null) {
            logger.error("un-initialized clusterMger, can't destroy cache");
            return;
        }
        logger.debug("Destroying Cache for HostTracker");
        this.clusterContainerService.destroyCache("neutronFloatingIPs");
    }

    private void startUp() {
        this.allocateCache();
        this.retrieveCache();
        this.loadConfiguration();
    }

    void init(Component c) {
        Dictionary props = c.getServiceProperties();
        if (props != null) {
            this.containerName = (String)props.get("containerName");
            logger.debug("Running containerName: {}", (Object)this.containerName);
        } else {
            this.containerName = "";
        }
        this.startUp();
    }

    void destroy() {
        this.destroyCache();
    }

    void start() {
    }

    void stop() {
    }

    private boolean overwrite(Object target, Object delta) {
        Method[] methods;
        for (Method toMethod : methods = target.getClass().getMethods()) {
            if (!toMethod.getDeclaringClass().equals(target.getClass()) || !toMethod.getName().startsWith("set")) continue;
            String toName = toMethod.getName();
            String fromName = toName.replace("set", "get");
            try {
                Method fromMethod = delta.getClass().getMethod(fromName, new Class[0]);
                Object value = fromMethod.invoke(delta, (Object[])null);
                if (value == null) continue;
                toMethod.invoke(target, value);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean floatingIPExists(String uuid) {
        return this.floatingIPDB.containsKey(uuid);
    }

    public NeutronFloatingIP getFloatingIP(String uuid) {
        if (!this.floatingIPExists(uuid)) {
            return null;
        }
        return (NeutronFloatingIP)this.floatingIPDB.get(uuid);
    }

    public List<NeutronFloatingIP> getAllFloatingIPs() {
        HashSet<NeutronFloatingIP> allIPs = new HashSet<NeutronFloatingIP>();
        for (Map.Entry entry : this.floatingIPDB.entrySet()) {
            NeutronFloatingIP floatingip = (NeutronFloatingIP)entry.getValue();
            allIPs.add(floatingip);
        }
        logger.debug("Exiting getAllFloatingIPs, Found {} FloatingIPs", (Object)allIPs.size());
        ArrayList<NeutronFloatingIP> ans = new ArrayList<NeutronFloatingIP>();
        ans.addAll(allIPs);
        return ans;
    }

    public boolean addFloatingIP(NeutronFloatingIP input) {
        INeutronNetworkCRUD networkCRUD = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        INeutronSubnetCRUD subnetCRUD = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        INeutronPortCRUD portCRUD = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (this.floatingIPExists(input.getID())) {
            return false;
        }
        NeutronSubnet subnet = subnetCRUD.getSubnet((String)networkCRUD.getNetwork(input.getFloatingNetworkUUID()).getSubnets().get(0));
        if (input.getFloatingIPAddress() == null) {
            input.setFloatingIPAddress(subnet.getLowAddr());
        }
        subnet.allocateIP(input.getFloatingIPAddress());
        if (input.getPortUUID() != null) {
            NeutronPort port = portCRUD.getPort(input.getPortUUID());
            port.addFloatingIP(input.getFixedIPAddress(), input);
        }
        this.floatingIPDB.putIfAbsent(input.getID(), input);
        return true;
    }

    public boolean removeFloatingIP(String uuid) {
        INeutronNetworkCRUD networkCRUD = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        INeutronSubnetCRUD subnetCRUD = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        INeutronPortCRUD portCRUD = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (!this.floatingIPExists(uuid)) {
            return false;
        }
        NeutronFloatingIP floatIP = this.getFloatingIP(uuid);
        NeutronSubnet subnet = subnetCRUD.getSubnet((String)networkCRUD.getNetwork(floatIP.getFloatingNetworkUUID()).getSubnets().get(0));
        subnet.releaseIP(floatIP.getFloatingIPAddress());
        if (floatIP.getPortUUID() != null) {
            NeutronPort port = portCRUD.getPort(floatIP.getPortUUID());
            port.removeFloatingIP(floatIP.getFixedIPAddress());
        }
        this.floatingIPDB.remove(uuid);
        return true;
    }

    public boolean updateFloatingIP(String uuid, NeutronFloatingIP delta) {
        NeutronPort port;
        INeutronPortCRUD portCRUD = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (!this.floatingIPExists(uuid)) {
            return false;
        }
        NeutronFloatingIP target = (NeutronFloatingIP)this.floatingIPDB.get(uuid);
        if (target.getPortUUID() != null) {
            port = portCRUD.getPort(target.getPortUUID());
            port.removeFloatingIP(target.getFixedIPAddress());
        }
        if (delta.getPortUUID() != null) {
            port = portCRUD.getPort(delta.getPortUUID());
            port.addFloatingIP(delta.getFixedIPAddress(), delta);
        }
        target.setPortUUID(delta.getPortUUID());
        target.setFixedIPAddress(delta.getFixedIPAddress());
        return true;
    }

    private void loadConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, FILE_NAME)) {
            NeutronFloatingIP nfIP = (NeutronFloatingIP)conf;
            this.floatingIPDB.put(nfIP.getID(), nfIP);
        }
    }

    public Status saveConfiguration() {
        return this.configurationService.persistConfiguration(new ArrayList(this.floatingIPDB.values()), FILE_NAME);
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }
}

