/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.frm.meter;

import org.opendaylight.controller.frm.AbstractTransaction;
import org.opendaylight.controller.frm.meter.MeterTransactionValidator;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.AddMeterInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.RemoveMeterInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.SalMeterService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.UpdateMeterInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.OriginalMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.OriginalMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.UpdatedMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.meter.update.UpdatedMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.types.rev130918.MeterRef;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class MeterTransaction
extends AbstractTransaction {
    private final SalMeterService _salMeterService;

    public SalMeterService getSalMeterService() {
        return this._salMeterService;
    }

    public MeterTransaction(DataModification<InstanceIdentifier<? extends DataObject>, DataObject> modification, SalMeterService salMeterService) {
        super(modification);
        this._salMeterService = salMeterService;
    }

    @Override
    public void remove(InstanceIdentifier<? extends Object> instanceId, DataObject obj) {
        if (obj instanceof Meter) {
            RemoveMeterInputBuilder _removeMeterInputBuilder;
            Meter meter = (Meter)obj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            RemoveMeterInputBuilder builder = _removeMeterInputBuilder = new RemoveMeterInputBuilder(meter);
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            MeterRef _meterRef = new MeterRef(instanceId);
            builder.setMeterRef(_meterRef);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            RemoveMeterInput _build = builder.build();
            this._salMeterService.removeMeter(_build);
        }
    }

    @Override
    public void update(InstanceIdentifier<? extends Object> instanceId, DataObject originalObj, DataObject updatedObj) {
        boolean _and = false;
        if (!(originalObj instanceof Meter)) {
            _and = false;
        } else {
            boolean bl = _and = originalObj instanceof Meter && updatedObj instanceof Meter;
        }
        if (_and) {
            OriginalMeterBuilder _originalMeterBuilder;
            UpdatedMeterBuilder _updatedMeterBuilder;
            UpdateMeterInputBuilder _updateMeterInputBuilder;
            Meter originalMeter = (Meter)originalObj;
            Meter updatedMeter = (Meter)updatedObj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            UpdateMeterInputBuilder builder = _updateMeterInputBuilder = new UpdateMeterInputBuilder();
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            MeterRef _meterRef = new MeterRef(instanceId);
            builder.setMeterRef(_meterRef);
            UpdatedMeterBuilder ufb = _updatedMeterBuilder = new UpdatedMeterBuilder(updatedMeter);
            UpdatedMeter _build = ufb.build();
            builder.setUpdatedMeter(_build);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            OriginalMeterBuilder ofb = _originalMeterBuilder = new OriginalMeterBuilder(originalMeter);
            OriginalMeter _build_1 = ofb.build();
            builder.setOriginalMeter(_build_1);
            UpdateMeterInput _build_2 = builder.build();
            this._salMeterService.updateMeter(_build_2);
        }
    }

    @Override
    public void add(InstanceIdentifier<? extends Object> instanceId, DataObject obj) {
        if (obj instanceof Meter) {
            AddMeterInputBuilder _addMeterInputBuilder;
            Meter meter = (Meter)obj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            AddMeterInputBuilder builder = _addMeterInputBuilder = new AddMeterInputBuilder(meter);
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            MeterRef _meterRef = new MeterRef(instanceId);
            builder.setMeterRef(_meterRef);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            AddMeterInput _build = builder.build();
            this._salMeterService.addMeter(_build);
        }
    }

    @Override
    public void validate() throws IllegalStateException {
        MeterTransactionValidator.validate(this);
    }
}

