/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.frm.group;

import org.opendaylight.controller.frm.AbstractTransaction;
import org.opendaylight.controller.frm.group.GroupTransactionValidator;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.AddGroupInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.RemoveGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.RemoveGroupInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.SalGroupService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.UpdateGroupInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.OriginalGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.OriginalGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.UpdatedGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.group.update.UpdatedGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.GroupRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.groups.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class GroupTransaction
extends AbstractTransaction {
    private final SalGroupService _groupService;

    public SalGroupService getGroupService() {
        return this._groupService;
    }

    public GroupTransaction(DataModification<InstanceIdentifier<? extends DataObject>, DataObject> modification, SalGroupService groupService) {
        super(modification);
        this._groupService = groupService;
    }

    @Override
    public void remove(InstanceIdentifier<? extends Object> instanceId, DataObject obj) {
        if (obj instanceof Group) {
            RemoveGroupInputBuilder _removeGroupInputBuilder;
            Group group = (Group)obj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            RemoveGroupInputBuilder builder = _removeGroupInputBuilder = new RemoveGroupInputBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)group);
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            GroupRef _groupRef = new GroupRef(instanceId);
            builder.setGroupRef(_groupRef);
            RemoveGroupInput _build = builder.build();
            this._groupService.removeGroup(_build);
        }
    }

    @Override
    public void update(InstanceIdentifier<? extends Object> instanceId, DataObject originalObj, DataObject updatedObj) {
        boolean _and = false;
        if (!(originalObj instanceof Group)) {
            _and = false;
        } else {
            boolean bl = _and = originalObj instanceof Group && updatedObj instanceof Group;
        }
        if (_and) {
            OriginalGroupBuilder _originalGroupBuilder;
            UpdatedGroupBuilder _updatedGroupBuilder;
            UpdateGroupInputBuilder _updateGroupInputBuilder;
            Group originalGroup = (Group)originalObj;
            Group updatedGroup = (Group)updatedObj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            UpdateGroupInputBuilder builder = _updateGroupInputBuilder = new UpdateGroupInputBuilder();
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            GroupRef _groupRef = new GroupRef(instanceId);
            builder.setGroupRef(_groupRef);
            UpdatedGroupBuilder ufb = _updatedGroupBuilder = new UpdatedGroupBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)updatedGroup);
            UpdatedGroup _build = ufb.build();
            builder.setUpdatedGroup(_build);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            OriginalGroupBuilder ofb = _originalGroupBuilder = new OriginalGroupBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)originalGroup);
            OriginalGroup _build_1 = ofb.build();
            builder.setOriginalGroup(_build_1);
            UpdateGroupInput _build_2 = builder.build();
            this._groupService.updateGroup(_build_2);
        }
    }

    @Override
    public void add(InstanceIdentifier<? extends Object> instanceId, DataObject obj) {
        if (obj instanceof Group) {
            AddGroupInputBuilder _addGroupInputBuilder;
            Group group = (Group)obj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            AddGroupInputBuilder builder = _addGroupInputBuilder = new AddGroupInputBuilder((org.opendaylight.yang.gen.v1.urn.opendaylight.group.types.rev131018.Group)group);
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            GroupRef _groupRef = new GroupRef(instanceId);
            builder.setGroupRef(_groupRef);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            AddGroupInput _build = builder.build();
            this._groupService.addGroup(_build);
        }
    }

    @Override
    public void validate() throws IllegalStateException {
        GroupTransactionValidator.validate(this);
    }
}

