/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.frm.flow;

import org.opendaylight.controller.frm.AbstractTransaction;
import org.opendaylight.controller.frm.flow.FlowTransactionValidator;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Uri;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.inventory.rev130819.tables.Table;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.AddFlowInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.FlowTableRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.RemoveFlowInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SalFlowService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.UpdateFlowInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.OriginalFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.OriginalFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.UpdatedFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.flow.update.UpdatedFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.Flow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.types.rev131026.FlowRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class FlowTransaction
extends AbstractTransaction {
    private final SalFlowService _salFlowService;

    public SalFlowService getSalFlowService() {
        return this._salFlowService;
    }

    public FlowTransaction(DataModification<InstanceIdentifier<? extends DataObject>, DataObject> modification, SalFlowService salFlowService) {
        super(modification);
        this._salFlowService = salFlowService;
    }

    @Override
    public void remove(InstanceIdentifier<? extends Object> instanceId, DataObject obj) {
        if (obj instanceof Flow) {
            RemoveFlowInputBuilder _removeFlowInputBuilder;
            Flow flow = (Flow)obj;
            InstanceIdentifier tableInstanceId = instanceId.firstIdentifierOf(Table.class);
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            RemoveFlowInputBuilder builder = _removeFlowInputBuilder = new RemoveFlowInputBuilder(flow);
            FlowRef _flowRef = new FlowRef(instanceId);
            builder.setFlowRef(_flowRef);
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            FlowTableRef _flowTableRef = new FlowTableRef(tableInstanceId);
            builder.setFlowTable(_flowTableRef);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            RemoveFlowInput _build = builder.build();
            this._salFlowService.removeFlow(_build);
        }
    }

    @Override
    public void update(InstanceIdentifier<? extends Object> instanceId, DataObject originalObj, DataObject updatedObj) {
        boolean _and = false;
        if (!(originalObj instanceof Flow)) {
            _and = false;
        } else {
            boolean bl = _and = originalObj instanceof Flow && updatedObj instanceof Flow;
        }
        if (_and) {
            OriginalFlowBuilder _originalFlowBuilder;
            UpdatedFlowBuilder _updatedFlowBuilder;
            UpdateFlowInputBuilder _updateFlowInputBuilder;
            Flow originalFlow = (Flow)originalObj;
            Flow updatedFlow = (Flow)updatedObj;
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            UpdateFlowInputBuilder builder = _updateFlowInputBuilder = new UpdateFlowInputBuilder();
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            FlowRef _flowRef = new FlowRef(instanceId);
            builder.setFlowRef(_flowRef);
            UpdatedFlowBuilder ufb = _updatedFlowBuilder = new UpdatedFlowBuilder(updatedFlow);
            UpdatedFlow _build = ufb.build();
            builder.setUpdatedFlow(_build);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            OriginalFlowBuilder ofb = _originalFlowBuilder = new OriginalFlowBuilder(originalFlow);
            OriginalFlow _build_1 = ofb.build();
            builder.setOriginalFlow(_build_1);
            UpdateFlowInput _build_2 = builder.build();
            this._salFlowService.updateFlow(_build_2);
        }
    }

    @Override
    public void add(InstanceIdentifier<? extends Object> instanceId, DataObject obj) {
        if (obj instanceof Flow) {
            AddFlowInputBuilder _addFlowInputBuilder;
            Flow flow = (Flow)obj;
            InstanceIdentifier tableInstanceId = instanceId.firstIdentifierOf(Table.class);
            InstanceIdentifier nodeInstanceId = instanceId.firstIdentifierOf(Node.class);
            AddFlowInputBuilder builder = _addFlowInputBuilder = new AddFlowInputBuilder(flow);
            NodeRef _nodeRef = new NodeRef(nodeInstanceId);
            builder.setNode(_nodeRef);
            DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification = this.getModification();
            Object _identifier = _modification.getIdentifier();
            Uri _uri = new Uri((String)_identifier);
            builder.setTransactionUri(_uri);
            FlowRef _flowRef = new FlowRef(instanceId);
            builder.setFlowRef(_flowRef);
            FlowTableRef _flowTableRef = new FlowTableRef(tableInstanceId);
            builder.setFlowTable(_flowTableRef);
            AddFlowInput _build = builder.build();
            this._salFlowService.addFlow(_build);
        }
    }

    @Override
    public void validate() throws IllegalStateException {
        FlowTransactionValidator.validate(this);
    }
}

