/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.frm;

import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.opendaylight.controller.frm.flow.FlowProvider;
import org.opendaylight.controller.frm.group.GroupProvider;
import org.opendaylight.controller.frm.meter.MeterProvider;
import org.opendaylight.controller.sal.binding.api.AbstractBindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.data.DataProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.flow.service.rev130819.SalFlowService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.group.service.rev130918.SalGroupService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.meter.service.rev130918.SalMeterService;
import org.osgi.framework.BundleContext;

public class FRMActivator
extends AbstractBindingAwareProvider {
    private static FlowProvider provider = new Functions.Function0<FlowProvider>(){

        public FlowProvider apply() {
            FlowProvider _flowProvider = new FlowProvider();
            return _flowProvider;
        }
    }.apply();
    private static GroupProvider groupProvider = new Functions.Function0<GroupProvider>(){

        public GroupProvider apply() {
            GroupProvider _groupProvider = new GroupProvider();
            return _groupProvider;
        }
    }.apply();
    private static MeterProvider meterProvider = new Functions.Function0<MeterProvider>(){

        public MeterProvider apply() {
            MeterProvider _meterProvider = new MeterProvider();
            return _meterProvider;
        }
    }.apply();

    public void onSessionInitiated(BindingAwareBroker.ProviderContext session) {
        DataProviderService _sALService = (DataProviderService)session.getSALService(DataProviderService.class);
        provider.setDataService(_sALService);
        SalFlowService _rpcService = (SalFlowService)session.getRpcService(SalFlowService.class);
        provider.setSalFlowService(_rpcService);
        provider.start();
        DataProviderService _sALService_1 = (DataProviderService)session.getSALService(DataProviderService.class);
        groupProvider.setDataService(_sALService_1);
        SalGroupService _rpcService_1 = (SalGroupService)session.getRpcService(SalGroupService.class);
        groupProvider.setSalGroupService(_rpcService_1);
        groupProvider.start();
        DataProviderService _sALService_2 = (DataProviderService)session.getSALService(DataProviderService.class);
        meterProvider.setDataService(_sALService_2);
        SalMeterService _rpcService_2 = (SalMeterService)session.getRpcService(SalMeterService.class);
        meterProvider.setSalMeterService(_rpcService_2);
        meterProvider.start();
    }

    protected void stopImpl(BundleContext context) {
        try {
            provider.close();
            groupProvider.close();
            meterProvider.close();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

