/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.frm;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.common.api.data.DataCommitHandler;
import org.opendaylight.controller.md.sal.common.api.data.DataModification;
import org.opendaylight.controller.sal.common.util.Rpcs;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;

public abstract class AbstractTransaction
implements DataCommitHandler.DataCommitTransaction<InstanceIdentifier<? extends DataObject>, DataObject> {
    private final DataModification<InstanceIdentifier<? extends DataObject>, DataObject> _modification;

    public AbstractTransaction(DataModification<InstanceIdentifier<? extends DataObject>, DataObject> modification) {
        this._modification = modification;
    }

    public abstract void validate() throws IllegalStateException;

    public RpcResult<Void> finish() throws IllegalStateException {
        this.validate();
        this.callRpcs();
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)true, null, _emptySet);
    }

    public DataModification<InstanceIdentifier<? extends DataObject>, DataObject> getModification() {
        return this._modification;
    }

    public RpcResult<Void> rollback() throws IllegalStateException {
        this.rollbackRpcs();
        Set _emptySet = Collections.emptySet();
        return Rpcs.getRpcResult((boolean)true, null, _emptySet);
    }

    private void callRpcs() {
        Map _originalConfigurationData;
        HashSet _hashSet;
        Map _createdConfigurationData = this._modification.getCreatedConfigurationData();
        Set createdEntries = _createdConfigurationData.entrySet();
        HashSet updatedEntries = _hashSet = new HashSet();
        Map _updatedConfigurationData = this._modification.getUpdatedConfigurationData();
        Set _entrySet = _updatedConfigurationData.entrySet();
        updatedEntries.addAll(_entrySet);
        updatedEntries.removeAll(createdEntries);
        Set removeEntriesInstanceIdentifiers = this._modification.getRemovedConfigurationData();
        for (Map.Entry entry : createdEntries) {
            InstanceIdentifier _key = (InstanceIdentifier)entry.getKey();
            DataObject _value = (DataObject)entry.getValue();
            this.add((InstanceIdentifier<? extends Object>)_key, _value);
        }
        for (Map.Entry entry_1 : updatedEntries) {
            _originalConfigurationData = this._modification.getOriginalConfigurationData();
            InstanceIdentifier _key_1 = (InstanceIdentifier)entry_1.getKey();
            DataObject originalFlow = (DataObject)_originalConfigurationData.get(_key_1);
            DataObject updatedFlow = (DataObject)entry_1.getValue();
            InstanceIdentifier _key_2 = (InstanceIdentifier)entry_1.getKey();
            this.update((InstanceIdentifier<? extends Object>)_key_2, originalFlow, updatedFlow);
        }
        for (InstanceIdentifier instanceId : removeEntriesInstanceIdentifiers) {
            _originalConfigurationData = this._modification.getOriginalConfigurationData();
            DataObject removeValue = (DataObject)_originalConfigurationData.get(instanceId);
            this.remove((InstanceIdentifier<? extends Object>)instanceId, removeValue);
        }
    }

    public abstract void remove(InstanceIdentifier<? extends Object> var1, DataObject var2);

    public abstract void update(InstanceIdentifier<? extends Object> var1, DataObject var2, DataObject var3);

    public abstract void add(InstanceIdentifier<? extends Object> var1, DataObject var2);

    private void rollbackRpcs() {
        Map _originalConfigurationData;
        HashSet _hashSet;
        Map _createdConfigurationData = this._modification.getCreatedConfigurationData();
        Set createdEntries = _createdConfigurationData.entrySet();
        HashSet updatedEntries = _hashSet = new HashSet();
        Map _updatedConfigurationData = this._modification.getUpdatedConfigurationData();
        Set _entrySet = _updatedConfigurationData.entrySet();
        updatedEntries.addAll(_entrySet);
        updatedEntries.removeAll(createdEntries);
        Set removeEntriesInstanceIdentifiers = this._modification.getRemovedConfigurationData();
        for (Map.Entry entry : createdEntries) {
            InstanceIdentifier _key = (InstanceIdentifier)entry.getKey();
            DataObject _value = (DataObject)entry.getValue();
            this.remove((InstanceIdentifier<? extends Object>)_key, _value);
        }
        for (Map.Entry entry_1 : updatedEntries) {
            _originalConfigurationData = this._modification.getOriginalConfigurationData();
            InstanceIdentifier _key_1 = (InstanceIdentifier)entry_1.getKey();
            DataObject originalFlow = (DataObject)_originalConfigurationData.get(_key_1);
            DataObject updatedFlow = (DataObject)entry_1.getValue();
            InstanceIdentifier _key_2 = (InstanceIdentifier)entry_1.getKey();
            this.update((InstanceIdentifier<? extends Object>)_key_2, updatedFlow, originalFlow);
        }
        for (InstanceIdentifier instanceId : removeEntriesInstanceIdentifiers) {
            _originalConfigurationData = this._modification.getOriginalConfigurationData();
            DataObject removeValue = (DataObject)_originalConfigurationData.get(instanceId);
            this.add((InstanceIdentifier<? extends Object>)instanceId, removeValue);
        }
    }
}

