/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.northbound;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.table.internal.Table;
import org.opendaylight.ovsdb.lib.table.internal.Tables;
import org.opendaylight.ovsdb.northbound.OVSDBRow;
import org.opendaylight.ovsdb.northbound.OVSDBRows;
import org.opendaylight.ovsdb.plugin.OVSDBConfigService;
import org.opendaylight.ovsdb.plugin.StatusWithUuid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class OVSDBNorthbound {
    protected static final Logger logger = LoggerFactory.getLogger(OVSDBNorthbound.class);
    @Context
    private UriInfo _uriInfo;
    private String username;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private void handleNameMismatch(String name, String nameinURL) {
        if (name == null || nameinURL == null) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Name is null");
        }
        if (name.equalsIgnoreCase(nameinURL)) {
            return;
        }
        throw new ResourceConflictException(RestMessages.INVALIDDATA.toString() + " : Table Name in URL does not match the row name in request body");
    }

    private String getOVSTableName(String tableName) {
        List tables = Tables.getTables();
        for (Table table : tables) {
            if (!table.getTableName().getName().equalsIgnoreCase(tableName)) continue;
            return table.getTableName().getName();
        }
        return null;
    }

    @Path(value="/node/{nodeType}/{nodeId}/tables/{tableName}/rows")
    @POST
    @StatusCodes(value={@ResponseCode(code=201, condition="Row Inserted successfully"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation")})
    @Consumes(value={"application/json"})
    public Response addRow(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="tableName") String tableName, @TypeHint(value=OVSDBRow.class) OVSDBRow row) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation");
        }
        String ovsTableName = this.getOVSTableName(tableName);
        if (ovsTableName == null) {
            Status status = new Status(StatusCode.NOTFOUND, "Table " + tableName + " is not currently supported");
            return NorthboundUtils.getResponse((Status)status);
        }
        OVSDBConfigService ovsdbTable = (OVSDBConfigService)ServiceHelper.getGlobalInstance(OVSDBConfigService.class, (Object)this);
        if (ovsdbTable == null) {
            throw new ServiceUnavailableException("OVS Configuration Service " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (row != null && row.getRow() != null) {
            this.handleNameMismatch(tableName, row.getRow().getTableName().getName());
            Node node = Node.fromString((String)nodeType, (String)nodeId);
            StatusWithUuid statusWithUUID = ovsdbTable.insertRow(node, ovsTableName, row.getParent_uuid(), row.getRow());
            if (statusWithUUID.isSuccess()) {
                UUID uuid = statusWithUUID.getUuid();
                return Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)String.format("%s/%s", this._uriInfo.getAbsolutePath().toString(), uuid.toString())).entity((Object)uuid.toString()).build();
            }
            return NorthboundUtils.getResponse((Status)statusWithUUID);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="/node/{nodeType}/{nodeId}/tables/{tableName}/rows/{rowUuid}")
    @GET
    @StatusCodes(value={@ResponseCode(code=200, condition="Row Updated successfully"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation")})
    @Consumes(value={"application/json"})
    @TypeHint(value=OVSDBRow.class)
    public OVSDBRow getRow(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="tableName") String tableName, @PathParam(value="rowUuid") String rowUuid) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation");
        }
        String ovsTableName = this.getOVSTableName(tableName);
        if (ovsTableName == null) {
            return null;
        }
        OVSDBConfigService ovsdbTable = (OVSDBConfigService)ServiceHelper.getGlobalInstance(OVSDBConfigService.class, (Object)this);
        if (ovsdbTable == null) {
            throw new ServiceUnavailableException("UserManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Table row = null;
        try {
            row = ovsdbTable.getRow(node, ovsTableName, rowUuid);
        }
        catch (Exception e) {
            throw new BadRequestException(e.getMessage());
        }
        return new OVSDBRow(null, row);
    }

    @Path(value="/node/{nodeType}/{nodeId}/tables/{tableName}/rows")
    @GET
    @StatusCodes(value={@ResponseCode(code=200, condition="Row Updated successfully"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation")})
    @Consumes(value={"application/json"})
    @TypeHint(value=OVSDBRows.class)
    public OVSDBRows getAllRows(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="tableName") String tableName) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation");
        }
        String ovsTableName = this.getOVSTableName(tableName);
        if (ovsTableName == null) {
            return null;
        }
        OVSDBConfigService ovsdbTable = (OVSDBConfigService)ServiceHelper.getGlobalInstance(OVSDBConfigService.class, (Object)this);
        if (ovsdbTable == null) {
            throw new ServiceUnavailableException("UserManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        ConcurrentMap rows = null;
        try {
            rows = ovsdbTable.getRows(node, ovsTableName);
        }
        catch (Exception e) {
            throw new BadRequestException(e.getMessage());
        }
        return new OVSDBRows(rows);
    }

    @Path(value="/node/{nodeType}/{nodeId}/tables/{tableName}/rows/{rowUuid}")
    @PUT
    @StatusCodes(value={@ResponseCode(code=200, condition="Row Updated successfully"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation")})
    @Consumes(value={"application/json"})
    public Response updateRow(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="tableName") String tableName, @PathParam(value="rowUuid") String rowUuid, @TypeHint(value=OVSDBRow.class) OVSDBRow row) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation");
        }
        String ovsTableName = this.getOVSTableName(tableName);
        if (ovsTableName == null) {
            Status status = new Status(StatusCode.NOTFOUND, "Table " + tableName + " is not currently supported");
            return NorthboundUtils.getResponse((Status)status);
        }
        OVSDBConfigService ovsdbTable = (OVSDBConfigService)ServiceHelper.getGlobalInstance(OVSDBConfigService.class, (Object)this);
        if (ovsdbTable == null) {
            throw new ServiceUnavailableException("UserManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (row != null && row.getRow() != null) {
            this.handleNameMismatch(tableName, row.getRow().getTableName().getName());
            Node node = Node.fromString((String)nodeType, (String)nodeId);
            Status status = ovsdbTable.updateRow(node, ovsTableName, row.getParent_uuid(), rowUuid, row.getRow());
            return NorthboundUtils.getResponse((Status)status);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @Path(value="/node/{nodeType}/{nodeId}/tables/{tableName}/rows/{uuid}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="User Deleted Successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The userName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error : Removal of user failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response removeRow(@PathParam(value="nodeType") String nodeType, @PathParam(value="nodeId") String nodeId, @PathParam(value="tableName") String tableName, @PathParam(value="uuid") String uuid) {
        if (!NorthboundUtils.isAuthorized((String)this.getUserName(), (String)"default", (Privilege)Privilege.WRITE, (Object)this)) {
            throw new UnauthorizedException("User is not authorized to perform this operation");
        }
        String ovsTableName = this.getOVSTableName(tableName);
        if (ovsTableName == null) {
            Status status = new Status(StatusCode.NOTFOUND, "Table " + tableName + " is not currently supported");
            return NorthboundUtils.getResponse((Status)status);
        }
        OVSDBConfigService ovsdbTable = (OVSDBConfigService)ServiceHelper.getGlobalInstance(OVSDBConfigService.class, (Object)this);
        if (ovsdbTable == null) {
            throw new ServiceUnavailableException("UserManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Node node = Node.fromString((String)nodeType, (String)nodeId);
        Status status = ovsdbTable.deleteRow(node, ovsTableName, uuid);
        if (status.isSuccess()) {
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }
}

